/*
 * Created on 2004/07/02
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.socket.info.TaskScheduleInfo;


/**
 * GWƃ^XNXPW[𑗎M郁\bh
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConnectionTaskScheduleControl extends AbstractConnectionEngine {
    /* MO */
    private static Logger logger = null;

    /**
     * GWƃ^XNXPW[𑗎M郁\bh
     * NXCX^X𐶐܂B
     *
     * @param engineAddress GWAhX
     */
    public ConnectionTaskScheduleControl(final String engineAddress) {
        super(engineAddress);
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * ^XNXPW[Zbg܂B
     *
     * @param taskStartDate Jn
     * @param taskEndDate I
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public void setTaskSchedule(
        final Date taskStartDate, final Date taskEndDate)
        throws EngineConnectException, IOException {
        CommandInfo commandInfo = new CommandInfo();
        commandInfo.setCode(
            CommandMappingTableResource.TASK_SCHEDULE_CONTROL_COMMAND_ID);

        TaskScheduleInfo taskInfo = new TaskScheduleInfo();
        taskInfo.setTaskStartDate(taskStartDate);
        taskInfo.setTaskEndDate(taskEndDate);
        commandInfo.setTaskScheduleInfo(taskInfo);

        this.communicationToEngine(commandInfo);
    }

    /**
     * ^XNXPW[Xg擾܂B
     *
     * @return taskScheduleList ^XNXPW[Xg
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public ArrayList getTaskSchedule()
        throws EngineConnectException, IOException {
        ArrayList taskScheduleList = new ArrayList();
        HashMap responseTaskScheduleMapList = null;

        CommandInfo commandInfo = new CommandInfo();
        commandInfo.setCode(
            CommandMappingTableResource.TASK_SCHEDULE_GET_COMMAND_ID);

        responseTaskScheduleMapList =
            (HashMap) this.communicationToEngine(commandInfo);

        for (
            Iterator it = responseTaskScheduleMapList.keySet().iterator();
                it.hasNext();) {
            String keyId = (String) it.next();

            TaskScheduleInfo info =
                (TaskScheduleInfo) responseTaskScheduleMapList.get(keyId);
            taskScheduleList.add(info);
            logger.info("Task ID : " + info.getId());
            logger.info("Task Start Date : " + info.getTaskStartDate());
            logger.info("Task End Date : " + info.getTaskEndDate());
        }

        return taskScheduleList;
    }

    /**
     * w̃^XNIDLZ܂B
     *
     * @param taskId ^XNID
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public void cancelTaskSchedule(String taskId)
        throws EngineConnectException, IOException {
        CommandInfo commandInfo = new CommandInfo();
        commandInfo.setCode(
            CommandMappingTableResource.TASK_SCHEDULE_CANCEL_COMMAND_ID);

        TaskScheduleInfo taskInfo = new TaskScheduleInfo();
        taskInfo.setTaskID(taskId);
        commandInfo.setTaskScheduleInfo(taskInfo);

        this.communicationToEngine(commandInfo);
    }
}
