/*
 * Created on 2003/08/02
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket.info;

import java.io.Serializable;


/**
 * MIB̎ɂOID̏ێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MibGetResponse implements Serializable {
    /**
         * serialVersionUID
         */
    private static final long serialVersionUID = 8506413444233244936L;

    // MIB
    private String mibName;

    // OID
    private String mibOid;

    // MIBl
    private String mibValue;

    // MIB Type
    private String mibType;

    // MIBANZX
    private String mibAccess;

    /**
     * MIBANZXԂ܂B
     *
     * @return mibAccess MIBANZX
     */
    public String getMibAccess() {
        return mibAccess;
    }

    /**
     * MIBԂ܂B
     *
     * @return mibName MIB
     */
    public String getMibName() {
        return mibName;
    }

    /**
     * OIDԂ܂B
     *
     * @return mibOid OID
     */
    public String getMibOid() {
        return mibOid;
    }

    /**
     * MIB^CvԂ܂B
     *
     * @return mibType MIB^Cv
     */
    public String getMibType() {
        return mibType;
    }

    /**
     * MIBlԂ܂B
     *
     * @return mibValue MIBl
     */
    public String getMibValue() {
        return mibValue;
    }

    /**
     * MIBANZXZbg܂B
     *
     * @param string MIBANZX
     */
    public void setMibAccess(String string) {
        mibAccess = string;
    }

    /**
     * MIBZbg܂B
     *
     * @param string MIB
     */
    public void setMibName(String string) {
        mibName = string;
    }

    /**
     * OIDZbg܂B
     *
     * @param string OID
     */
    public void setMibOid(String string) {
        mibOid = string;
    }

    /**
     * MIB^CvZbg܂B
     *
     * @param string MIB^Cv
     */
    public void setMibType(String string) {
        mibType = string;
    }

    /**
     * MIBlZbg܂B
     *
     * @param string MIBl
     */
    public void setMibValue(String string) {
        mibValue = string;
    }
}
