/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.model.DatabaseTest;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyEmbeddedDerby;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyNetworkServer;
import netjfwatcher.database.access.model.hsqldb.HsqldbControl;
import netjfwatcher.engine.model.action.EngineStatus;
import netjfwatcher.engine.resource.DatabasePropertyResource;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.XMLOutputterFormat;
import netjfwatcher.engine.socket.info.DatabasePropertyInfo;
import netjfwatcher.engine.socket.info.ResourceInfo;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;


/**
 * DatabasẽvpeB\View\NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class DatabasePropertyView extends ViewPart {
    private static final int[] SCROLL_COMPOSITE_MIN_SIZE = { 1000, 400 };
    private static final int DATABASE_TEST_LIST_WIDTHHINT = 400;
    private static final int DATABASE_TEST_LIST_ITEM_HEIGHT = 7;

    /** f[^x[Xғ󋵃`FbNPhase0\ */
    public static final String PHASE0 = "Phase 0 : Engine Connect ";

    /** f[^x[Xғ󋵃`FbNPhase1\ */
    public static final String PHASE1 = "Phase 1 : JDBC Driver ";

    /** f[^x[Xғ󋵃`FbNPhase2\ */
    public static final String PHASE2 =
        "Phase 2 : DriverManager getConnection ";

    /** f[^x[Xғ󋵃`FbNPhase3\ */
    public static final String PHASE3 =
        "Phase 3 : Database create table execute ";

    /** f[^x[Xғ󋵃`FbNPhase4\ */
    public static final String PHASE4 =
        "Phase 4 : Database drop table execute ";

    /** f[^x[Xғ󋵃`FbNPhase\z */
    public static final String[] PHASE =
        { PHASE0, PHASE1, PHASE2, PHASE3, PHASE4 };

    /* DatabaseR{  */
    private static final int DATABASE_NAME_COMBO_WIDTH = 200;

    /* Text */
    private static final int TEXT_WIDTH = 200;

    /* MO */
    private static Logger logger;

    /* \[X */
    private ResourceInfo info;

    /* f[^x[XύXÕf[^x[XʁiݒύXoɎgpj */
    private String oldDatabaseName = "";

    /* f[^x[XvpeBXg */
    private ArrayList databasePropList;

    /* f[^x[XvpeB */
    private DatabasePropertyInfo databaseProp;

    /* f[^x[XICombo */
    private Combo databaseNameCombo;

    /* f[^x[XText */
    private Text databaseNameText;

    /* f[^x[XhCoText */
    private Text databaseDriverText;

    /* f[^x[XhCo Work Text */
    private Text workDatabaseDriverText;

    /* f[^x[XURL Text */
    private Text databaseUrlText;

    /* f[^x[XURL Work Text */
    private Text workDatabaseUrlText;

    /* f[^x[X[UText */
    private Text databaseUserText;

    /* f[^x[X[U Work Text */
    private Text workDatabaseUserText;

    /* f[^x[XpX[hText */
    private Text databasePasswordText;

    /* f[^x[XpX[h Work Text */
    private Text workDatabasePasswordText;

    /* f[^x[XvpeBZ[u{^ */
    private Button saveButton;

    /* f[^x[XvpeBRs[{^ */
    private Button copyButton;

    /* f[^x[Xғ󋵃eXg{^ */
    private Button testButton;

    /* f[^x[XғeXgʃXg */
    private List resultDatabaseTestList;

    /**
     * f[^x[XvpeBViewNXCX^X𐶐
     * ܂B
     *
     */
    public DatabasePropertyView() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * PartControl𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
        /* VXe\[X擾 */
        info =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo();
        oldDatabaseName = info.getDatabaseName();

        /* f[^x[XvpeBXg擾 */
        databasePropList =
            DatabasePropertyResource.getInstance().getdatabasePropList()
                                    .getDatabasePropList();

        /* ScrolledCompositeZbg */
        ScrolledComposite scrollComposite =
            new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout(layout);

        GridLayout gridLayout0 = new GridLayout(1, false);
        Composite baseComposite = new Composite(scrollComposite, SWT.LEFT);
        baseComposite.setLayout(gridLayout0);
        baseComposite.setLayoutData(
            new GridData(GridData.VERTICAL_ALIGN_BEGINNING));

        gridLayout0 = new GridLayout(3, false);

        Composite subBaseComposite = new Composite(baseComposite, SWT.LEFT);
        subBaseComposite.setLayout(gridLayout0);
        subBaseComposite.setLayoutData(
            new GridData(GridData.VERTICAL_ALIGN_BEGINNING));

        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(2, false);
        Composite leftComposite = new Composite(subBaseComposite, SWT.LEFT);
        leftComposite.setLayout(gridLayout);
        leftComposite.setLayoutData(
            new GridData(GridData.VERTICAL_ALIGN_BEGINNING));
        gridData = new GridData();

        gridLayout = new GridLayout(1, false);

        Composite centerComposite = new Composite(subBaseComposite, SWT.LEFT);
        centerComposite.setLayout(gridLayout);
        centerComposite.setLayoutData(
            new GridData(GridData.VERTICAL_ALIGN_BEGINNING));

        gridLayout = new GridLayout(2, false);

        Composite rightComposite = new Composite(subBaseComposite, SWT.LEFT);
        rightComposite.setLayout(gridLayout);
        rightComposite.setLayoutData(
            new GridData(GridData.VERTICAL_ALIGN_BEGINNING));

        // LeftLayout
        Label label = new Label(leftComposite, SWT.NONE);
        label.setText("Database Name");
        label.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_BEGINNING));
        databaseNameText = new Text(leftComposite, SWT.BORDER);
        gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        databaseNameText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Database Driver");
        gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        label.setLayoutData(gridData);
        databaseDriverText = new Text(leftComposite, SWT.BORDER);
        gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        databaseDriverText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Database URL");
        gridData = new GridData();
        label.setLayoutData(gridData);

        databaseUrlText = new Text(leftComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        databaseUrlText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Database User");
        label.setLayoutData(new GridData());
        databaseUserText = new Text(leftComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        databaseUserText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Database Password");
        label.setLayoutData(new GridData());
        databasePasswordText = new Text(leftComposite, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        databasePasswordText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        saveButton = new Button(leftComposite, SWT.NONE);
        saveButton.setText("Save");
        saveButton.setLayoutData(new GridData());

        label = new Label(leftComposite, SWT.NONE);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        // CenterLayout
        label = new Label(centerComposite, SWT.NONE);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 2;
        label.setLayoutData(gridData);

        copyButton = new Button(centerComposite, SWT.NONE);
        copyButton.setText("Copy");
        copyButton.setLayoutData(
            new GridData(GridData.VERTICAL_ALIGN_BEGINNING));

        label = new Label(centerComposite, SWT.NONE);
        label.setText(" <---");
        label.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_BEGINNING));

        // RightLayout
        label = new Label(rightComposite, SWT.NONE);
        label.setText("Database Name");
        label.setLayoutData(new GridData());

        databaseNameCombo =
            new Combo(rightComposite, SWT.DROP_DOWN | SWT.READ_ONLY);

        /* f[^x[XIXg쐬 */
        int selectDatabaseName = 0;

        for (int i = 0; i < databasePropList.size(); i++) {
            databaseNameCombo.add(
                ((DatabasePropertyInfo) databasePropList.get(i))
                .getDatabaseName());

            /* f[^x[XIԍZbg */
            if (
                info.getDatabaseName().equals(
                        ((DatabasePropertyInfo) databasePropList.get(i))
                        .getDatabaseName())) {
                selectDatabaseName = i;
            }
        }

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = DATABASE_NAME_COMBO_WIDTH;
        databaseNameCombo.setLayoutData(gridData);
        databaseNameCombo.select(selectDatabaseName);

        label = new Label(rightComposite, SWT.NONE);
        label.setText("Database Driver");
        label.setLayoutData(new GridData());
        workDatabaseDriverText = new Text(rightComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        workDatabaseDriverText.setLayoutData(gridData);

        label = new Label(rightComposite, SWT.NONE);
        label.setText("Database URL");
        label.setLayoutData(new GridData());
        workDatabaseUrlText = new Text(rightComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        workDatabaseUrlText.setLayoutData(gridData);

        label = new Label(rightComposite, SWT.NONE);
        label.setText("Database User");
        label.setLayoutData(new GridData());
        workDatabaseUserText = new Text(rightComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        workDatabaseUserText.setLayoutData(gridData);

        label = new Label(rightComposite, SWT.NONE);
        label.setText("Database Password");
        label.setLayoutData(new GridData());
        workDatabasePasswordText = new Text(rightComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        workDatabasePasswordText.setLayoutData(gridData);

        label = new Label(rightComposite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData(gridData);

        label = new Label(rightComposite, SWT.NONE);
        label.setText("");
        label.setLayoutData(new GridData());

        testButton = new Button(rightComposite, SWT.NONE);
        testButton.setText("Test");
        testButton.setLayoutData(new GridData());

        label = new Label(rightComposite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData(gridData);

        label = new Label(rightComposite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData(gridData);

        resultDatabaseTestList =
            new List(
                rightComposite,
                SWT.SINGLE | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);

        GridData data = new GridData(GridData.FILL_BOTH);
        data.horizontalSpan = 1;
        data.verticalSpan = 1;
        data.widthHint = DATABASE_TEST_LIST_WIDTHHINT;
        data.heightHint =
            resultDatabaseTestList.getItemHeight() * DATABASE_TEST_LIST_ITEM_HEIGHT;

        resultDatabaseTestList.select(0);
        resultDatabaseTestList.setLayoutData(data);

        gridLayout0 = new GridLayout(3, false);

        Composite composite01 = new Composite(baseComposite, SWT.NONE);
        composite01.setLayout(gridLayout0);
        composite01.setLayoutData(new GridData());

        gridLayout = new GridLayout(2, false);

        Composite composite11 = new Composite(composite01, SWT.LEFT);
        composite11.setLayout(gridLayout);
        composite11.setLayoutData(new GridData());

        gridLayout = new GridLayout(1, false);

        Composite composite12 = new Composite(composite01, SWT.LEFT);
        composite12.setLayout(gridLayout);
        composite12.setLayoutData(new GridData());

        gridLayout = new GridLayout(2, false);

        Composite composite13 = new Composite(composite01, SWT.LEFT);
        composite13.setLayout(gridLayout);
        composite13.setLayoutData(new GridData());

        setShowText();
        setSelectDatabase(selectDatabaseName);

        scrollComposite.setContent(baseComposite);
        scrollComposite.setMinSize(
            SCROLL_COMPOSITE_MIN_SIZE[0], SCROLL_COMPOSITE_MIN_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);

        /* Xi[Zbg */
        setListener();
    }

    /*
     * CombBoxIyу{^Xi[Zbg܂B
     */
    private void setListener() {
        /* Database CombBoxI */
        databaseNameCombo.addSelectionListener(
            new SelectionAdapter() {
                public void widgetSelected(SelectionEvent event) {
                    int smtpHostSelectIndex =
                        databaseNameCombo.getSelectionIndex();

                    setSelectDatabase(smtpHostSelectIndex);
                }
            });

        /*
         * f[^x[XғeXg{^Xi[
         */
        testButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    testButton.setEnabled(false);

                    try {
                        BusyIndicator.showWhile(
                            PlatformUI.getWorkbench().getDisplay(),
                            new Runnable() {
                                public void run() {
                                    testDatabase();
                                }
                            });
                    } finally {
                        testButton.setEnabled(true);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /* DatabaseCopy{^ */
        copyButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    info.setDatabaseName(databaseNameCombo.getText());
                    info.setDatabaseDriver(workDatabaseDriverText.getText());
                    info.setDatabaseUrl(workDatabaseUrlText.getText());
                    info.setDatabaseUser(workDatabaseUserText.getText());
                    info.setDatabasePassword(
                        workDatabasePasswordText.getText());

                    /* f[^x[XI\[X\
                     * eLXgɃZbg
                     */
                    setShowText();
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /*
         * f[^x[XvpeBZ[u{^Xi[
         */
        saveButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    saveButton.setEnabled(false);

                    try {
                        /* f[^x[XύXݒĎ */
                        if (!oldDatabaseName.equals(databaseNameText.getText())) {
                            /*
                             * f[^x[XύXꍇɂ́A]̃f[^x[X~
                             */
                            stopDatabase(oldDatabaseName);

                            if (EngineStatus.getInstance().isEngine()) {
                                /* EngineNłEngineċNvDialog */
                                MessageDialog.openInformation(
                                    getSite().getShell(), "Information",
                                    "Please Restart Engine");
                            }
                        }

                        /* f[^x[XvpeB񃊃\[XɊi[ */
                        info.setDatabaseName(databaseNameText.getText());
                        info.setDatabaseDriver(databaseDriverText.getText());
                        info.setDatabaseUrl(databaseUrlText.getText());
                        info.setDatabaseUser(databaseUserText.getText());
                        info.setDatabasePassword(
                            databasePasswordText.getText());
                        oldDatabaseName = databaseNameText.getText();
                        saveResourceXMLInfo(info);

                        DatabaseAccessControlKind.getInstance()
                                                 .updateDatabaseKindControl();
                    } finally {
                        saveButton.setEnabled(true);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
    }

    /*
     * f[^x[X~܂B
     *
     */
    private void stopDatabase(String oldDatabaseKind) {
        if (oldDatabaseKind.equals(AbstractDataAccessObject.HSQLDB)) {
            try {
                HsqldbControl.getInstance().stopHsqlDB();
            } catch (ClassNotFoundException e) {
                logger.warning(
                    "ClassNotFoundException HSQLDB " + e.getMessage());
            } catch (SQLException e) {
                logger.warning("SQLException HSQLDB " + e.getMessage());
            }
        } else if (oldDatabaseKind.equals(AbstractDataAccessObject.DERBY)) {
            try {
                ApacheDerbyNetworkServer.getInstance().stopDerbyNetworkServer();
            } catch (Exception e) {
                logger.warning("DERBY " + e.getMessage());
            }
        } else if (
            oldDatabaseKind.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
            try {
                ApacheDerbyEmbeddedDerby.getInstance().stopEmbeddedDerby();
            } catch (Exception e) {
                logger.warning("EMBEDDED_DERBY " + e.getMessage());
            }
        }
    }

    /*
     *
     */
    private void setShowText() {
        databaseNameText.setText(info.getDatabaseName());
        databaseDriverText.setText(info.getDatabaseDriver());
        databaseUrlText.setText(info.getDatabaseUrl());
        databaseUserText.setText(info.getDatabaseUser());
        databasePasswordText.setText(info.getDatabasePassword());
    }

    /*
     *
     */
    private void setSelectDatabase(int selectDatabaseName) {
        databaseProp =
            (DatabasePropertyInfo) databasePropList.get(selectDatabaseName);
        databaseNameCombo.setText(databaseProp.getDatabaseName());
        workDatabaseDriverText.setText(databaseProp.getDatabaseDriver());
        workDatabaseUrlText.setText(databaseProp.getDatabaseUrl());
        workDatabaseUserText.setText(databaseProp.getDatabaseUser());
        workDatabasePasswordText.setText(databaseProp.getDatabasePassword());
    }

    private void testDatabase() {
        resultDatabaseTestList.removeAll();

        String databaseName = databaseNameCombo.getText();
        String databaseDriver = workDatabaseDriverText.getText();
        String databaseUrl = workDatabaseUrlText.getText();
        String databaseUser = workDatabaseUserText.getText();
        String databasePassword = workDatabasePasswordText.getText();

        logger.info("databaseName : " + databaseName);
        logger.info("databaseDriver : " + databaseDriver);
        logger.info("databaseUrl : " + databaseUrl);
        logger.info("databaseUser : " + databaseUser);
        logger.info("databasePassword : " + databasePassword);

        /* f[^x[XғeXgs */
        DatabaseTest databaseTest = new DatabaseTest(databaseName);
        String[] testResult =
            databaseTest.checkDatabase(
                databaseDriver, databaseUrl, databaseUser, databasePassword);

        /* f[^x[XғeXgʂXgɕ\ */
        for (int i = 0; i < testResult.length; i++) {
            logger.info("Phase " + i + " : " + testResult[i]);

            /* i = 0EngineHttp ServerڑeXg */
            if (i != 0) {
                resultDatabaseTestList.add(PHASE[i] + " : " + testResult[i]);
            }
        }
    }

    /**
     * VXe\[XXMLt@CƂďóEi[܂B
     *
     * @param info VXe\[X
     */
    protected void saveResourceXMLInfo(ResourceInfo info) {
        // Document
        Document dom = null;

        // t@Co̓obt@
        BufferedWriter bufWriter = null;

        // SNMP\`XV
        dom = this.updateResource(info);
        bufWriter =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceFileWriter();

        // XMLt@Co
        this.outputXMLFile(bufWriter, dom);

        if (bufWriter != null) {
            try {
                bufWriter.close();
            } catch (IOException e) {
                logger.warning(
                    "Abort close BufferedWriter for snmp resource : "
                    + e.getMessage());
                e.printStackTrace();
            }
        }

        // FileɃCgɃCX^XXV
        SystemResourceConfig.getInstance().updateResourceset();
    }

    /**
     * \[XXVpDocumentԂ܂B
     *
     * @param info \[X
     * @return dom Document
     */
    protected Document updateResource(ResourceInfo info) {
        Document dom =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .updateDocument(info);

        return dom;
    }

    /**
     *@wBufferedWriteryDocumentXML Fileɏo͂܂B
     *
     * @param bufWriter BufferedWriter
     * @param dom Document
     */
    public void outputXMLFile(BufferedWriter bufWriter, Document dom) {
        logger = Logger.getLogger(this.getClass().getName());

        /*
         * qGgeGg2wAGgԂ̉s
                * w͂ȂiXMLt@CŌXsĂ邽߁j
                */

        // XMLOutputter outputter = new XMLOutputter("  ", true);
        XMLOutputter outputter =
            XMLOutputterFormat.getInstance().getXMLOutputterFormat();

        // XMLOutputter outputter = new XMLOutputter();
        // outputter.setIndent("  ");
        FileWriter writer = null;

        try {
            outputter.output(dom, System.out);
            outputter.output(dom, bufWriter);
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }

    /**
     * tH[JXZbgꂽ̏łB
     */
    public void setFocus() {
    }
}
