/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view;

import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.mail.MailSend;
import netjfwatcher.engine.mail.MailSendException;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.MailProperty;
import netjfwatcher.engine.socket.info.MailSendTestInformation;
import netjfwatcher.engine.socket.info.ResourceInfo;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;



/**
 * MailvpeB\ViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MailPropertyView extends ViewPart {
    /* Text/List */
    private static final int ENGINEID_TEXT_WIDTH = 200;
    private static final int MESSAGE_TEXT_HEIGH = 150;
    private static final int MESSAGE_TEXT_WIDTH = 300;
    private static final int MAIL_DESTINATION_LIST_WIDTH = 200;
    private static final int TEST_RESULT_HEIGH = 100;
    private static final int TEST_RESULT_WIDTH = 300;

    /* MO */
    private static Logger logger;

    /* \[X */
    private ResourceInfo info;

    /* MailvpeBi[z */
    private MailProperty[] mailProp;

    /* SMTP HostIԍ */
    private int smtpHostSelectIndex = 0;

    /* SMTPzXgComboBox */
    private Combo smtpHostCombo;

    /* Mail惊Xg */
    private List mailDestinationList;

    /* mail From\text */
    private Text mailFromText;

    /* Mail\Text */
    private Text destinationAddressText;

    /* Mail Subject\Text */
    private Text subjectText;

    /* Mail message\text */
    private Text messageText;

    /* MailMeXg{^ */
    private Button testButton;

    /* MailMeXgʕ\Text */
    private Text testResultText;

    /**
     * MailvpeB\ViewNXCX^X𐶐܂B
     *
     */
    public MailPropertyView() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * PartControl𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
        info =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo();
        mailProp = info.getMailPropertyList();

        /*
         * eCompositezueLayout
         * ieCompositec1ɔzuj
         */
        ScrolledComposite scrollComposite =
            new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);

        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout(layout);

        GridData gridData = null;

        GridLayout gridLayout0 = new GridLayout(1, false);
        Composite composite0 = new Composite(scrollComposite, SWT.LEFT);
        composite0.setLayout(gridLayout0);
        composite0.setLayoutData(new GridData());

        GridLayout gridLayout = new GridLayout(4, false);
        Composite composite = new Composite(composite0, SWT.LEFT);
        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData());

        gridData = new GridData();

        Label label;
        label = new Label(composite, SWT.NONE);
        label.setText("SMTP Host");
        label.setLayoutData(new GridData());

        smtpHostCombo = new Combo(composite, SWT.DROP_DOWN);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = ENGINEID_TEXT_WIDTH;
        smtpHostCombo.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("From");
        label.setLayoutData(new GridData());
        mailFromText = new Text(composite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = ENGINEID_TEXT_WIDTH;
        mailFromText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Destination Address");
        gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;

        // gridData.VERTICAL_ALIGN_BEGINNING;
        label.setLayoutData(gridData);

        destinationAddressText = new Text(composite, SWT.BORDER);
        gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        destinationAddressText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Destination list");
        gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        label.setLayoutData(gridData);

        mailDestinationList =
            new List(composite, SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL);

        GridData data = new GridData(GridData.FILL_BOTH);
        data.horizontalSpan = 1;
        data.verticalSpan = 1;
        data.widthHint = MAIL_DESTINATION_LIST_WIDTH;
        data.heightHint = mailDestinationList.getItemHeight() * 8;

        mailDestinationList.setLayoutData(data);

        label = new Label(composite, SWT.NONE);
        label.setText("Subject");
        gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        subjectText = new Text(composite, SWT.BORDER);
        gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        subjectText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Message");
        gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        messageText =
            new Text(
                composite, SWT.BORDER | SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.heightHint = MESSAGE_TEXT_HEIGH;
        gridData.widthHint = MESSAGE_TEXT_WIDTH;
        messageText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        testButton = new Button(composite, SWT.NONE);
        testButton.setText("Mail send test");
        testButton.setLayoutData(new GridData());

        /* Dummy column */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Test Result");
        gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        testResultText =
            new Text(
                composite, SWT.BORDER | SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.heightHint = TEST_RESULT_HEIGH;
        gridData.widthHint = TEST_RESULT_WIDTH;
        testResultText.setLayoutData(gridData);

        GridLayout gridLayout2 = new GridLayout(4, false);
        Composite composite2 = new Composite(composite0, SWT.NONE);
        composite2.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        composite2.setLayout(gridLayout2);

        scrollComposite.setContent(composite0);
        scrollComposite.setMinSize(800, 600);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);

        /* SMTP Host CombBoxI */
        smtpHostCombo.addSelectionListener(
            new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    smtpHostSelectIndex = smtpHostCombo.getSelectionIndex();

                    setShowTextData(smtpHostSelectIndex);
                }
            });

        /* Mail惊XgI */
        mailDestinationList.addSelectionListener(
            new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    int index = mailDestinationList.getSelectionIndex();
                    destinationAddressText.setText(
                        mailDestinationList.getItem(index));
                }
            });

        /*
         * MailMeXg{^Xi[
         */
        testButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    testButton.setEnabled(false);

                    String mailSendResult = "Mail Send Test OK";
                    testResultText.setText("Testing...");

                    try {
                        if (destinationAddressText.getText().equals("")) {
                            MessageDialog.openError(
                                getSite().getShell(),
                                "Illegal Destination Address",
                                "Illegal Destination Address.");
                            mailSendResult = "Illegal Destination Address.";
                            return;
                        }

                        testResultText.setText("Testing...");

                        MailSendTestInformation mailSendtestInfo =
                            new MailSendTestInformation();

                        mailSendtestInfo.setSmtpHost(
                            smtpHostCombo.getItem(smtpHostSelectIndex));
                        mailSendtestInfo.setMailFrom(mailFromText.getText());
                        mailSendtestInfo.setMailTo(
                            destinationAddressText.getText());
                        mailSendtestInfo.setMailSubject(subjectText.getText());
                        mailSendtestInfo.setMailBody(messageText.getText());

                        logger.info(
                            "SMTP Host : " + mailSendtestInfo.getSmtpHost());
                        logger.info("From : " + mailSendtestInfo.getMailFrom());
                        logger.info("To : " + mailSendtestInfo.getMailTo());
                        logger.info(
                            "Sunbject : " + mailSendtestInfo.getMailSubject());
                        logger.info("Body : " + mailSendtestInfo.getMailBody());

                        /* MailMs */
                        MailSend.getInstance().sendMail(
                            mailSendtestInfo.getSmtpHost(),
                            mailSendtestInfo.getMailFrom(),
                            mailSendtestInfo.getMailTo(),
                            mailSendtestInfo.getMailSubject(),
                            mailSendtestInfo.getMailBody());
                    } catch (MailSendException e1) {
                        mailSendResult = e1.getMessage();
                    } finally {
                        testButton.setEnabled(true);
                        testResultText.setText(mailSendResult);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        setShowTextData(0);
    }

    /*
     * Text\Zbg܂B
     *
     * @param index SMTP Host CombBoxIԍ
     */
    private void setShowTextData(int index) {
        smtpHostCombo.removeAll();
        mailDestinationList.removeAll();

        testResultText.setText("");

        /* SMTP Host ComboBoxUNAčēxAZbg */
        for (int i = 0; i < mailProp.length; i++) {
            smtpHostCombo.add(mailProp[i].getSmtpHost());
        }

        smtpHostCombo.select(index);

        /* Mail FromZbg */
        mailFromText.setText(mailProp[index].getFrom());

        /* Mail惊XgZbg */
        ArrayList list = mailProp[index].getToList();

        for (int i = 0; i < list.size(); i++) {
            mailDestinationList.add((String) list.get(i));
        }
    }

    /**
     * tH[JXZbgꂽ̏łB
     *
     */
    public void setFocus() {
    }
}
