/*
 * Created on 2006/11/07
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.canvas;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.filepreference.FilePreference;

import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;


public class CanvasViewConfigFileParse {

	private static final int CHART_VIEW_WIDTH = 1400;

	private static final int CHART_VIEW_HEIGHT = 800;
	
	/* ftHgXXP[ */
	private static final int X_POINT_VALUE0 = 1000;

	/* ftHgYXP[ */
	private static final int Y_POINT_VALUE0 = 450;

	protected static final int MAP_VIEW_WIDTH = 1900;

	protected static final int MAP_VIEW_HEIGHT = 1700;
	
	/* conf TAG */
	private static final String CONF_TAG = "conf";

	/* Chart TAG */
	private static final String CHART_TAG = "chart";

	/* Chart width TAG */
	private static final String CHART_WIDTH_TAG = "width";

	/* Chart height TAG */
	private static final String CHART_HEIGHT_TAG = "height";

	/* Chart X Scall TAG */
	private static final String CHART_X_SCALL_TAG = "x_scall";

	/* Chart Y Scall TAG */
	private static final String CHART_Y_SCALL_TAG = "y_scall";

	/* Node Map TAG */
	private static final String NODE_MAP_TAG = "node_map";

	/* Node Map width TAG */
	private static final String NODE_MAP_WIDTH_TAG = "width";

	/* Node Map height TAG */
	private static final String NODE_MAP_HEIGHT_TAG = "height";

	/* l */
	private static final String ATTRIBUTE_VALUE = "value";

	/* Logging */
	private static Logger logger = null;

	private int chartWidth = CHART_VIEW_WIDTH;

	private int chartHeight = CHART_VIEW_HEIGHT;

	private int chartXScall = X_POINT_VALUE0;

	private int chartYScall = Y_POINT_VALUE0;

	private int nodeMapWidth = MAP_VIEW_WIDTH;

	private int nodeMapHeight = MAP_VIEW_HEIGHT;

	private CanvasViewConfigFileParse() {
		logger = Logger.getLogger(this.getClass().getName());
		parseCanvasViewConfigFileParse();
	}

	public void parseCanvasViewConfigFileParse() {

		Document doc = null;
		doc = getResourceFileDocumentPath(FilePreference.CANVAS_DEFINE_FILE);


		try {
			// rootvfo
			Element root = doc.getRootElement();

			Element chartEl = root.getChild(CHART_TAG);
			chartWidth = Integer.parseInt((chartEl.getChild(CHART_WIDTH_TAG))
					.getAttributeValue(ATTRIBUTE_VALUE));
			chartHeight = Integer.parseInt((chartEl.getChild(CHART_HEIGHT_TAG))
					.getAttributeValue(ATTRIBUTE_VALUE));
			chartXScall = Integer
					.parseInt((chartEl.getChild(CHART_X_SCALL_TAG))
							.getAttributeValue(ATTRIBUTE_VALUE));
			chartYScall = Integer
					.parseInt((chartEl.getChild(CHART_Y_SCALL_TAG))
							.getAttributeValue(ATTRIBUTE_VALUE));

			Element nodeMapEl = root.getChild(NODE_MAP_TAG);
			nodeMapWidth = Integer.parseInt((nodeMapEl
					.getChild(NODE_MAP_WIDTH_TAG))
					.getAttributeValue(ATTRIBUTE_VALUE));
			nodeMapHeight = Integer.parseInt((nodeMapEl
					.getChild(NODE_MAP_HEIGHT_TAG))
					.getAttributeValue(ATTRIBUTE_VALUE));
		} catch (NullPointerException e) {
			e.printStackTrace();
		}
	}

	/**
	 * \[XBufferedWriterԂ܂B
	 * 
	 * @return bufferedWriter \[XBufferedWriter
	 */
	public BufferedWriter getResourceFileWriter() {
		File f = new File(FilePreference.CANVAS_DEFINE_FILE);
		// logger.info("Path : " + f.getAbsolutePath());

		if (f == null) {
			return null;
		}

		BufferedWriter bufferedWriter = null;

		try {
			FileWriter fi = new FileWriter(
					FilePreference.CANVAS_DEFINE_FILE);
			bufferedWriter = new BufferedWriter(fi);
		} catch (IOException e1) {
			e1.printStackTrace();

			return null;
		}

		return bufferedWriter;
	}

	/**
	 * wfBNgXMLt@C͂DocumentԂ܂B ijart@ČȂj
	 * 
	 * @param file
	 *            XMLt@C
	 * @return doc Document
	 */
	public Document getResourceFileDocumentPath(String file) {
		Document doc = null;

		File f = new File(file);
		// logger.info("Path : " + f.getAbsolutePath());

		if (f == null) {
			logger.warning("Abort create File : " + f.getAbsolutePath());

			return null;
		}

		BufferedReader d = null;

		try {
			FileReader fi = new FileReader(file);
			d = new BufferedReader(fi);
		} catch (FileNotFoundException e1) {
			logger.warning("FileNotFoundException : " + f.getPath() + " : "
					+ e1.getMessage());
			logger.warning("FileNotFoundException : " + f.getAbsolutePath()
					+ " : " + e1.getMessage());
			e1.printStackTrace();

			return null;
		}

		try {
			// FileInputStream stream = new FileInputStream(f);
			SAXBuilder builder = new SAXBuilder();
			doc = builder.build(d);
		} catch (JDOMException e) {
			logger.warning("JDOMException : " + e.getMessage());
			e.printStackTrace();
		} catch (NullPointerException e) {
			logger.warning("NullPointerException : " + e.getMessage());
			e.printStackTrace();
		} catch (IOException e) {
			logger.warning("IOException : " + e.getMessage());
			e.printStackTrace();
		}

		return doc;
	}

	/**
	 * jart@CXMLt@CE͂DocumentԂ܂B
	 * 
	 * @param file
	 *            XMLt@C
	 * @return doc Document
	 */
	protected Document getDocument(String file) {
		Document doc = null;

		URL url = null;

		try {

			Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
			url = bundle.getEntry(file);

			if (url == null) {
				/* bZ[W\[Xt@CȂꍇMO̎ */
				logger.severe("Resource XML file url : " + url);

				return null;
			}

			SAXBuilder builder = new SAXBuilder();
			doc = builder.build(url.openStream());
		} catch (JDOMException e) {
			logger.severe("JDOMException URL= "
					+ url + " " + e.getMessage());
			e.printStackTrace();
		} catch (NullPointerException e) {
			logger.severe("NullPointerException URL= "
					+ url + " " + e.getMessage());
			e.printStackTrace();
		} catch (IOException e) {
			logger.severe("IOException URL= "
					+ url + " " + e.getMessage());
			e.printStackTrace();
		}

		return doc;
	}

	/**
	 * \[X񂩂Document𐶐AԂ܂B
	 * 
	 * @param updateResourceInfo
	 *            \[X
	 * @return Document
	 */
	public Document updateDocument(CanvasViewInfo canvasViewInfo) {
		logger = Logger.getLogger(this.getClass().getName());

		Element rootElement = new Element(CONF_TAG);
		Document doc = new Document(rootElement);

		Element chartEl = new Element(CHART_TAG);
		Element chartWidthEl = new Element(CHART_WIDTH_TAG);
		Element chartHeightEl = new Element(CHART_HEIGHT_TAG);
		Element chartXScallEl = new Element(CHART_X_SCALL_TAG);
		Element chartYScallEl = new Element(CHART_Y_SCALL_TAG);
		
		rootElement.addContent(chartEl);
		
		chartEl.addContent(chartWidthEl);
		chartEl.addContent(chartHeightEl);
		chartEl.addContent(chartXScallEl);
		chartEl.addContent(chartYScallEl);
		
		chartWidthEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, Integer.toString(canvasViewInfo.getChartWidth())));
		chartHeightEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, Integer.toString(canvasViewInfo.getChartHeight())));
		chartXScallEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, Integer.toString(canvasViewInfo.getChartXScall())));
		chartYScallEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, Integer.toString(canvasViewInfo.getChartYScall())));

		Element nodeMapEl = new Element(NODE_MAP_TAG);
		Element nodeMapWidthEl = new Element(NODE_MAP_WIDTH_TAG);
		Element nodeMapHeightEl = new Element(NODE_MAP_HEIGHT_TAG);

		rootElement.addContent(nodeMapEl);
		nodeMapEl.addContent(nodeMapWidthEl);
		nodeMapEl.addContent(nodeMapHeightEl);
		
		nodeMapWidthEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, Integer.toString(canvasViewInfo.getNodeMapWidth())));
		nodeMapHeightEl.setAttribute(new Attribute(ATTRIBUTE_VALUE, Integer.toString(canvasViewInfo.getNodeMapHeight())));
		
		return doc;
	}
	
	public int getChartHeight() {
		return chartHeight;
	}

	public int getChartWidth() {
		return chartWidth;
	}

	public int getNodeMapHeight() {
		return nodeMapHeight;
	}

	public int getNodeMapWidth() {
		return nodeMapWidth;
	}

	public int getChartXScall() {
		return chartXScall;
	}

	public int getChartYScall() {
		return chartYScall;
	}

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static CanvasViewConfigFileParse getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final CanvasViewConfigFileParse RESOURCE = new CanvasViewConfigFileParse();
    }
}
