/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.common;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.canvas.CanvasViewConfigFileParse;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

/**
 * EditorPartɃOt`悷钊ۃNXłB Ot`悷郁\bhAzF̃o[Ȃǂ܂B
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
abstract public class AbstractEditorNodeChart extends AbstractEditorNodeView {
	/** Editor part Title suffix */
	public static final String TITLE_SUFFIX = " Chart";

	/** ʃf[^/Sf[^Ot\[hł̑Sf[^Ot\` */
	protected static final String ALL_DRAW_MODE = "all";
	/** MAPTv`ItZbg */
	public static final int OFFSET = 20;



	/* Scroll Composite size */
	private int[] scrollCompositeSize = new int[2];

	/** Ot`JnW */
	public static final int X_POINT0 = 50;

	/* XXP[ */
	private int chartXScall;

	/* YXP[ */
	private int chartYScall;

	/* Ot'0' XYW */
	private int[] pointXY0 = new int[2];

	/* XC̏I_W */
	private int[] xAxisPoint = new int[2];

	/* YC̏I_W */
	private static final int[] Y_AXIS_POINT = { X_POINT0, X_POINT0 };

	/* Yڐ */
	private static final int Y_NOCTH = 10;

	/* Xڐ ŏ */
	private static final int X_SCALL_MIN_PITCH = 5;
	/* Ot Nij\Jbg */
	private static final int DATE_YEAR_CUTLENGTH = 5;

	/* zFColor` */
	private static Color whiteColor = new Color(null, 255, 255, 255);

	private static Color blackColor = new Color(null, 0, 0, 0);

	private static Color redColor = new Color(null, 255, 0, 0);

	private static Color blueColor = new Color(null, 0, 0, 255);

	private static Color limeColor = new Color(null, 0, 255, 0);

	private static Color navyColor = new Color(null, 0, 0, 128);

	private static Color yellowColor = new Color(null, 255, 255, 0);

	private static Color tealColor = new Color(null, 0, 128, 128);

	private static Color greenColor = new Color(null, 0, 128, 0);

	/* XColor */
	private static final Color X_LINE_COLOR = navyColor;

	/* YColor */
	private static final Color Y_LINE_COLOR = navyColor;

	/* YڐColor */
	private static final Color Y_SCALL_COLOR = navyColor;

	/* Ot̐̃J[(C`斈ɐFI) */
	private static final Color[] LINE_COLOR = { limeColor, redColor, blueColor,
			yellowColor, greenColor, tealColor, blackColor, navyColor };

	/* Ot̐̃^Cv(C`斈ɑI) */
	private static final int[] LINE_STYLE = { SWT.LINE_SOLID, SWT.LINE_SOLID,
			SWT.LINE_SOLID, SWT.LINE_SOLID, SWT.LINE_SOLID, SWT.LINE_SOLID,
			SWT.LINE_SOLID, SWT.LINE_SOLID, SWT.LINE_DASHDOT, SWT.LINE_DASHDOT,
			SWT.LINE_DASHDOT, SWT.LINE_DASHDOT, SWT.LINE_DASHDOT,
			SWT.LINE_DASHDOT, SWT.LINE_DASHDOT, SWT.LINE_DASHDOT };

	/** ʃf[^/Sf[^Ot\[h */
	protected static String mode = ALL_DRAW_MODE;

	/* MO */
	private static Logger logger;

	/**
	 * Ot`f[^Iԍ (pNXŃZbg)
	 */
	protected int selectNo = 0;

	/** Canvas */
	protected Canvas canvas;

	/* GC */
	private GC gc;

	/** m[hĎ */
	protected NodeInformation targetNodeInfo;

	/** wm[hSnmpv񒆂̑ΏOID */
	protected String inputOid;

	/** ef[^̍őli[z */
	protected String[] maxData;

	/** ef[^̍ŏli[z */
	protected String[] minData;

	/** PopUpj[ */
	protected Menu popUpMenu;

	/* Sf[^̍ől */
	private double maxDataDouble;

	/* Sf[^̍ŏl */
	private double minDataDouble;

	private float yNotch = Y_NOCTH;

	/** f[^ArrayListi[List */
	protected ArrayList allStatisticsDataList;

	/** OtX(Date) */
	protected ArrayList dateList;

	/** Ot̃CTitle */
	protected ArrayList itemNameList;

	protected EditorNodeChartMouseListener mouseListener;

	protected ScrolledComposite scrollComposite;

	protected Image zoominImage;

	protected Image zoomoutImage;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public AbstractEditorNodeChart() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		setCanvasSize();
		/* ͐ݒlm[hĎ擾 */
		EditorInputNodeChart nodeViewEditorInput = (EditorInputNodeChart) getEditorInput();

		/* m[hĎZbg */
		targetNodeInfo = nodeViewEditorInput.getNodeInfo();
		isSocket = nodeViewEditorInput.isSocket();

		/* ől/ŏlZbg */
		maxData = nodeViewEditorInput.getMaxData();
		minData = nodeViewEditorInput.getMinData();

		/* ef[^Xgi[XgZbg */
		allStatisticsDataList = nodeViewEditorInput.getDataList();

		/* f[^̎XgZbg */
		dateList = nodeViewEditorInput.getDateList();

		/* ef[^Zbg */
		itemNameList = nodeViewEditorInput.getItemNameList();

		/* OIDZbg */
		inputOid = nodeViewEditorInput.getOid();

		if (maxData == null) {
			try {
				getChartData();
			} catch (DatabaseConnectionException e1) {
				logger.warning(e1.getMessage());
				e1.printStackTrace();
			} catch (SQLException e1) {
				logger.warning(e1.getMessage());
				e1.printStackTrace();
			}
		}

		scrollComposite = new ScrolledComposite(parent, SWT.H_SCROLL
				| SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, true);
		scrollComposite.setLayout(layout);
		scrollComposite.setBackground(whiteColor);

		canvas = new Canvas(scrollComposite, SWT.NULL);
		canvas.addPaintListener(new PaintListener() {
			public void paintControl(PaintEvent event) {

				redraw();
			}
		});

		gc = new GC(canvas);

		gc.setBackground(scrollComposite.getBackground());
		scrollComposite.setContent(canvas);
		scrollComposite.setMinSize(scrollCompositeSize[0],
				scrollCompositeSize[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		mouseListener = new EditorNodeChartMouseListener(scrollComposite,
				parent.getDisplay(), parent, canvas, gc, this, false);

		scrollComposite.addMouseListener(mouseListener);
		canvas.addMouseListener(mouseListener);

		/* PopUpj[Zbg */
		setPopupMenu(parent);
		createZoomImage();
	}

	private void setCanvasSize() {
		
		
		/* XXP[ */
		chartXScall = CanvasViewConfigFileParse.getInstance().getChartXScall();

		/* YXP[ */
		chartYScall = CanvasViewConfigFileParse.getInstance().getChartYScall();
		
		/* Ot'0' XYW */
		pointXY0[0] = X_POINT0;
		pointXY0[1] = chartYScall;

		/* XC̏I_W */
		xAxisPoint[0] = chartXScall;
		xAxisPoint[1] = chartYScall;
		
		scrollCompositeSize[0] = CanvasViewConfigFileParse.getInstance().getChartWidth();
		scrollCompositeSize[1] = CanvasViewConfigFileParse.getInstance().getChartHeight();
	}
	/**
	 * PopUpj[Zbg܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	abstract protected void setPopupMenu(Composite parent);

	/**
	 * f[^x[XOt\f[^擾܂B
	 * 
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV擾łȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	abstract protected void getChartData() throws DatabaseConnectionException,
			SQLException;

	/**
	 * Otĕ`悵܂B
	 * 
	 */
	protected void redraw() {
		int height = canvas.getClientArea().height - 1;
		int width = canvas.getClientArea().width - 1;
		gc.setForeground(tealColor);
		gc.drawLine(0, 0, width, 0);
		gc.drawLine(0, 0, 0, height);
		gc.setForeground(whiteColor);
		gc.drawLine(width, 0, width, height);
		gc.drawLine(0, height, width, height);
		gc.setForeground(blackColor);

		gc.fillRectangle(canvas.getClientArea());

		/* Ot^CggcɃZbg */
		gc.drawString(getTitle(), 5, 5);

		/* Ot` */
		drawChart();

		setZoomButton();
	}

	/**
	 * Ot`悵܂B
	 */
	protected void drawChart() {
		double[] checkMaxData = new double[maxData.length];
		double[] checkMinData = new double[minData.length];

		for (int i = 0; i < maxData.length; i++) {
			if (maxData[i] == null) {
				return;
			}

			checkMaxData[i] = Double.parseDouble(maxData[i]);
			checkMinData[i] = Double.parseDouble(minData[i]);
		}

		if (mode.equals(ALL_DRAW_MODE)) {
			// ől𒊏o
			maxDataDouble = checkMaxData[0];

			if (maxData.length > 1) {
				for (int i = 0; i < (maxData.length - 1); i++) {
					for (int j = maxData.length - 1; j > i; j--) {
						double work0 = checkMaxData[j];
						double work1 = checkMaxData[j - 1];

						if (work0 > work1) {
							double work = checkMaxData[j - 1];
							checkMaxData[j - 1] = checkMaxData[j];
							checkMaxData[j] = work;
						}
					}
				}

				maxDataDouble = checkMaxData[0];
			}
		} else {
			maxDataDouble = checkMaxData[selectNo];
			minDataDouble = checkMinData[selectNo];
		}

		/* Y̍őڐlZo */
		double dataYMax = createYMaxScall(maxDataDouble, minDataDouble);

		/* XC` */
		gc.setLineStyle(SWT.LINE_SOLID);
		gc.setForeground(X_LINE_COLOR);
		gc.drawLine(pointXY0[0], pointXY0[1], xAxisPoint[0], xAxisPoint[1]);

		/*
		 * logger.info("maxDataDouble : " + maxDataDouble);
		 * logger.info("minDataDouble : " + minDataDouble);
		 * logger.info("dataYMax : " + dataYMax); logger.info("X_AXIS_POINT[0] : " +
		 * xAxisPoint[0]); logger.info("X_AXIS_POINT[1] : " + xAxisPoint[1]);
		 */
		/*
		 * X`(dot) (Xƃf[^獏݂Zo)
		 */
		double xScallPitch = (double) (xAxisPoint[0] - pointXY0[0])
				/ (double) dateList.size();

		double plotX = pointXY0[0]; // `Jnʒu

		/* Xڐŏ */
		double xNotch = xScallPitch;

		if (xScallPitch < X_SCALL_MIN_PITCH) {
			xNotch = X_SCALL_MIN_PITCH;
		}

		/*
		 * XڐText\ (݂ɖڐText\邩)
		 */
		double xScallShowTextPos = (dateList.size() / 9) + 1;

		if (xScallShowTextPos > 10) {
			xScallShowTextPos = 10;
		}

		/* ڐTexti/iݕ\tO */
		double sghowTextToggleFlag = 0;

		for (double i = 0; (i <= dateList.size())
				&& (plotX <= (xAxisPoint[0] - xNotch)); i++) {
			/* Xڐ */
			gc.drawLine((int) plotX, pointXY0[1] - 5, (int) plotX, pointXY0[1]);

			if ((i % xScallShowTextPos) == 0) {
				gc.drawLine((int) plotX, pointXY0[1], (int) plotX,
						pointXY0[1] + 5);
				gc.setLineStyle(SWT.LINE_DOT);
				gc.drawLine((int) plotX, pointXY0[1], (int) plotX,
						Y_AXIS_POINT[1] - 20);
				gc.setLineStyle(SWT.LINE_SOLID);

				/* Xڐ()eLXg */
				String dateWork = (String) dateList.get((int) i);

				/* \ڐ̔N폜 */
				/*
				 * String[] dateWorkArray = dateWork.split(" "); String
				 * dateText;
				 * 
				 * if (dateWorkArray.length > 1) { dateText =
				 * dateWorkArray[1].substring(0, dateWorkArray[1]
				 * .indexOf(".")); } else { dateText = dateWork; }
				 */
				String dateText;
				if (dateWork.length() >= DATE_YEAR_CUTLENGTH) {
					dateText = dateWork.substring(DATE_YEAR_CUTLENGTH, dateWork
							.length());
				} else {
					dateText = dateWork;
				}
				/* Text\݂ɕ\ */
				if ((sghowTextToggleFlag % 2) == 0) {
					gc.drawString(dateText, (int) plotX, pointXY0[1] + 10);
				} else {
					gc.drawString(dateText, (int) plotX, pointXY0[1] + 24);
				}

				sghowTextToggleFlag++;
			}

			plotX += xNotch;
		}

		/* YC` */
		gc.setLineStyle(SWT.LINE_SOLID);
		gc.setForeground(Y_LINE_COLOR);
		gc.drawLine(pointXY0[0], pointXY0[1], Y_AXIS_POINT[0],
				Y_AXIS_POINT[1] - 20);

		/*
		 * Yڐ`
		 * 
		 */
		double pichData;

		if (mode.equals(ALL_DRAW_MODE)) {
			pichData = picth(dataYMax, yNotch); /* Y̖ڐl */
		} else {
			if ((dataYMax - minDataDouble) >= 0) {
				/* ŏlőlł̖ڐ */
				pichData = picth((dataYMax - minDataDouble), yNotch); /* Y̖ڐl */
			} else {
				/* 0őlł̖ڐ */
				pichData = picth((dataYMax), yNotch); /* Y̖ڐl */
			}
		}

		gc.setLineStyle(SWT.LINE_DOT);
		gc.setForeground(Y_SCALL_COLOR);

		double plotDataY = dataYMax;

		/*
		 * f[^̃OtłȂASOt\̏ꍇ ́AY0ől̕ƂB
		 * ̑If[^̃Ot\̏ꍇÝAŏlől̕ƂB
		 */
		if (mode.equals(ALL_DRAW_MODE)) {
			// Sf[^\ÝA0ől
			while (plotDataY >= pichData) {
				/* őڐ珇ڐlZo */
				double yScall = (100 - ((plotDataY / dataYMax) * 100));
				double yScallPosition = ((yScall * (pointXY0[1] - Y_AXIS_POINT[1])) / 100)
						+ Y_AXIS_POINT[1];

				gc.drawLine(pointXY0[0], (int) yScallPosition, xAxisPoint[0],
						(int) yScallPosition);

				/* YڐeLXg */
				gc.drawString(Double.toString(plotDataY), xAxisPoint[0] + 5,
						(int) yScallPosition - 10);
				plotDataY = (plotDataY - pichData);
			}
		} else {
			/* If[^\ÝAŏlől */
			int count = 0;

			while (yNotch >= count) {
				/* őڐ珇ڐlZo */
				double yScall = count / yNotch;
				double yScallPosition = (yScall * (pointXY0[1] - Y_AXIS_POINT[1]))
						+ Y_AXIS_POINT[1];

				gc.drawLine(pointXY0[0], (int) yScallPosition, xAxisPoint[0],
						(int) yScallPosition);

				/* YڐeLXg */
				gc.drawString(Double.toString(plotDataY), xAxisPoint[0] + 5,
						(int) yScallPosition - 10);
				count++;
				plotDataY = (dataYMax - (pichData * count));
			}
		}

		/*
		 * }`
		 */
		if (mode.equals(ALL_DRAW_MODE)) {
			/* Sf[^̖}` */
			if (itemNameList != null) {
				for (int i = 0; i < itemNameList.size(); i++) {
					/* }჉Cyі}f[^` */
					introNotes(i, i);
				}
			}
		} else {
			/* If[^̖}჉Cyі}f[^` */
			introNotes(0, selectNo);
		}

		/*
		 * Ot`搔̊ef[^𒊏oăXgɊi[
		 */
		ArrayList[] statisticsDataList = null;
		statisticsDataList = new ArrayList[allStatisticsDataList.size()];

		for (int instanceCount = 0; instanceCount < allStatisticsDataList
				.size(); instanceCount++) {
			/* CX^Xf[^Xgi[XgCX^Xf[^Xgo */
			statisticsDataList[instanceCount] = (ArrayList) allStatisticsDataList
					.get(instanceCount);
		}

		/*
		 * If[^Sf[^̃OtC`
		 */
		if (mode.equals(ALL_DRAW_MODE)) {
			for (int j = 0; j < statisticsDataList.length; j++) {
				drawLine(j, statisticsDataList[j], dataYMax, xScallPitch);
			}
		} else {
			drawLine(selectNo, statisticsDataList[selectNo], dataYMax,
					xScallPitch);
		}
	}

	/**
	 * Zoom{^C[W𐶐܂B
	 * 
	 */
	protected void createZoomImage() {
		zoominImage = ImageDescriptor.createFromURL(
				NetJFWatcherPlugin.getInstance().getBundle().getEntry(
						"icons/zoomin.gif")).createImage();
		zoomoutImage = ImageDescriptor.createFromURL(
				NetJFWatcherPlugin.getInstance().getBundle().getEntry(
						"icons/zoomout.gif")).createImage();
	}

	/**
	 * Zoom{^Zbg܂B
	 * 
	 */
	protected void setZoomButton() {

		/* SCanvasɂVieẅʒu */
		Point canvaPoint = canvas.getLocation();

		int canvaAbsPointX = Math.abs(canvaPoint.x);
		int canvaAbsPointY = Math.abs(canvaPoint.y);
		/* \ĂMapr[TCY */
		Point mapScrollCompositePoint = scrollComposite.getSize();
		// Rectangle mapViewRectangle = gc.getClipping();
		int overviewPointX = canvaAbsPointX;
		int overviewPointY = canvaAbsPointY + mapScrollCompositePoint.y
				- zoominImage.getBounds().height - OFFSET;

		gc.drawImage(zoominImage, overviewPointX, overviewPointY);
		gc.drawImage(zoomoutImage, overviewPointX + 20, overviewPointY);
	}

	/**
	 * }`悵܂B
	 * 
	 * @param drawCount
	 *            Ot`JE^Ŗ}̕`̈ʒu 
	 * @param selectNo
	 *            f[^IJE^Ŗ}̐FAX^C 
	 */
	protected void introNotes(int drawCount, int selectNo) {
		/* }჉C */
		int colorNum = selectNo & 0x07;
		gc.setForeground(LINE_COLOR[colorNum]);

		int styleNum = selectNo & 0x0F;
		gc.setLineStyle(LINE_STYLE[styleNum]);
		gc.drawLine(xAxisPoint[0] + 100, Y_AXIS_POINT[1] + (drawCount * 20),
				xAxisPoint[0] + 130, Y_AXIS_POINT[1] + (drawCount * 20));

		/* }f[^ */
		gc.setForeground(blackColor);
		gc.drawString((String) itemNameList.get(selectNo), xAxisPoint[0] + 140,
				(Y_AXIS_POINT[1] + (drawCount * 20)) - 7);
	}

	/**
	 * OtC`悵܂B
	 * 
	 * @param drawCount
	 *            `JE^ŃC̐FAX^C
	 * @param list
	 *            f[^i[Xg
	 * @param dataYMax
	 *            Yől
	 * @param xScallPitch
	 *            X̃sb`
	 */
	protected void drawLine(int drawCount, ArrayList list, double dataYMax,
			double xScallPitch) {
		double[] data = new double[list.size()];

		if (mode.equals(ALL_DRAW_MODE)) {
			for (int i = 0; i < list.size(); i++) {
				// f[^Y̑Έʒu%Zo
				double dataFloat = Double.parseDouble((String) list.get(i));
				double relatiX = (100 - ((dataFloat / dataYMax) * 100));

				// f[^ŸʒuiItZbglZbg
				// (΃f[^ * Y)YʒuƃItZbgʒu
				double relatiData = ((relatiX * (pointXY0[1] - Y_AXIS_POINT[1])) / 100)
						+ Y_AXIS_POINT[1];

				data[i] = relatiData;
			}
		} else {
			for (int i = 0; i < list.size(); i++) {
				/* f[^Y̑ΈʒuZo */
				double dataDouble = Double.parseDouble((String) list.get(i));

				/*
				 * If[^őlƍŏlYŕ`悵悤 ꍇɍőlƍŏlł΁Aől
				 * ̑ΈʒuYɂ
				 */
				double relatiX;

				if ((maxDataDouble == minDataDouble)
						&& ((dataDouble - minDataDouble) <= 0)) {

					if (dataDouble == 0) {
						/*
						 * l0̏ꍇɂ́Aől1ƂĂA݂1 ƂĂ̂ō1̈ʒuɂȂ
						 */
						relatiX = (1 / yNotch) * 100;
					} else {
						relatiX = (100 - ((dataDouble / dataYMax) * 100));
					}
				} else {
					/* If[^őlƍŏlY̑Έʒu */
					double denomi = 0;

					if ((dataYMax - minDataDouble) > 0) {
						denomi = (dataYMax - minDataDouble);
					} else {
						denomi = (minDataDouble - dataYMax);
					}

					relatiX = (100 - (((dataDouble - minDataDouble) / (denomi)) * 100));
				}

				/*
				 * f[^ŸʒuItZbgltăZbg ((΃f[^ * Y)ɂYʒuƃItZbgʒu)
				 */
				double relatiData = ((relatiX * (pointXY0[1] - Y_AXIS_POINT[1])) / 100)
						+ Y_AXIS_POINT[1];

				data[i] = relatiData;
			}
		}

		/*
		 * ܂OtɃf[^`
		 */
		/* `XW */
		double timePlotX = pointXY0[0];

		/* C̐FAX^CI */
		int colorNum = drawCount & 0x07;
		gc.setForeground(LINE_COLOR[colorNum]);

		int styleNum = drawCount & 0x0F;
		gc.setLineStyle(LINE_STYLE[styleNum]);

		/* C` */
		for (int i = 0; i < (data.length - 1); i++) {
			gc.drawLine((int) timePlotX, (int) data[i],
					(int) (timePlotX + xScallPitch), (int) data[i + 1]);

			timePlotX += xScallPitch;
		}
	}

	/**
	 * Y̍őڐlZoĕԂ܂B f[^̍őlۂߍ݂܂B
	 * 
	 * @param maxData
	 *            ől
	 * @param minData
	 *            ŏl
	 * @return maxYData Y̍őڐl
	 */
	protected double createYMaxScall(double maxData, double minData) {
		if (maxData < 1) {
			maxData = 1;
		}

		double maxYData = 0;

		if (maxData > 2) {
			long workMaxdata = (long) maxData;

			String stringCreateMaxData = Long.toString(workMaxdata);
			String stringSourceMaxData = Long.toString(workMaxdata);

			if (stringSourceMaxData.length() > 6) {
				int chk1 = Integer
						.parseInt(stringSourceMaxData.substring(0, 1));
				int chk2 = Integer
						.parseInt(stringSourceMaxData.substring(1, 2));
				int chk3 = Integer
						.parseInt(stringSourceMaxData.substring(2, 3));

				if (chk3 >= 5) {
					chk2++;
					chk3 = 0;
				}

				if (chk2 >= 10) {
					chk1++;
					chk2 = 0;
				}

				stringCreateMaxData = "" + chk1 + chk2 + chk3;

				for (int i = 0; i < (stringSourceMaxData.length() - 3); i++) {
					stringCreateMaxData += "0";
				}

				float checkMinYData = Float.parseFloat(stringCreateMaxData);

				if ((minData > checkMinYData) || (maxData > checkMinYData)) {
					chk3++;

					if (chk3 >= 5) {
						chk2++;
						chk3 = 0;
					}

					if (chk2 >= 10) {
						chk1++;
						chk2 = 0;
					}

					stringCreateMaxData = "" + chk1 + chk2 + chk3;

					for (int i = 0; i < (stringSourceMaxData.length() - 3); i++) {
						stringCreateMaxData += "0";
					}
				}
			} else if (stringSourceMaxData.length() > 3) {
				int chk1 = Integer
						.parseInt(stringSourceMaxData.substring(0, 1));
				int chk2 = Integer
						.parseInt(stringSourceMaxData.substring(1, 2));
				int chk3 = Integer
						.parseInt(stringSourceMaxData.substring(2, 3));

				if (chk3 >= 5) {
					chk2++;
				}

				if (chk2 >= 10) {
					chk1++;
					chk2 = 0;
				}

				stringCreateMaxData = "" + chk1 + chk2;

				for (int i = 0; i < (stringSourceMaxData.length() - 2); i++) {
					stringCreateMaxData += "0";
				}

				float checkMinYData = Float.parseFloat(stringCreateMaxData);

				if ((minData > checkMinYData) || (maxData > checkMinYData)) {
					chk2++;
					stringCreateMaxData = "" + chk1 + chk2;

					for (int i = 0; i < (stringSourceMaxData.length() - 2); i++) {
						stringCreateMaxData += "0";
					}
				}
			} else if (stringSourceMaxData.length() == 3) {
				int chk1 = Integer
						.parseInt(stringSourceMaxData.substring(0, 1));
				int chk2 = Integer
						.parseInt(stringSourceMaxData.substring(1, 2));
				int chk3 = Integer
						.parseInt(stringSourceMaxData.substring(2, 3));

				if (chk3 >= 5) {
					chk2++;
				}

				if (chk2 >= 10) {
					chk1++;
					chk2 = 0;
				}

				stringCreateMaxData = "" + chk1 + chk2 + "0";

				float checkMinYData = Float.parseFloat(stringCreateMaxData);

				if ((minData > checkMinYData) || (maxData > checkMinYData)) {
					chk2++;
					stringCreateMaxData = "" + chk1 + chk2 + "0";
				}

				/*
				 * for (int i = 0; i < (stringSourceMaxData.length() - 1); i++) {
				 * strinfCreateMaxData += "0"; }
				 */
			} else if (stringSourceMaxData.length() == 2) {
				int chk1 = Integer
						.parseInt(stringSourceMaxData.substring(0, 1));
				int chk2 = Integer
						.parseInt(stringSourceMaxData.substring(1, 2));

				if (chk2 >= 5) {
					chk1++;
				}

				stringCreateMaxData = "" + chk1 + "0";

				float checkMinYData = Float.parseFloat(stringCreateMaxData);

				if (minData > checkMinYData) {
					chk1++;
					stringCreateMaxData = "" + chk1 + "0";
				}
			}

			maxYData = Float.parseFloat(stringCreateMaxData);
		} else {
			maxYData = (float) maxData;
		}

		if(maxData > maxYData) {
			maxYData += maxYData;
		}
		return maxYData;
	}

	/**
	 * YڐZoĕԂ܂B
	 * 
	 * @param dataYMax
	 *            Yől
	 * @param kizami
	 *            Y
	 * @return Yڐ
	 */
	protected long picth(double dataYMax, float kizami) {
		long yScall = (long) (dataYMax * (1 / kizami));

		if (yScall < 1) {
			yScall = 1;
		}

		long workMaxdata = yScall;

		String stringCreateMaxData = Long.toString(workMaxdata);
		String stringSourceMaxData = Long.toString(workMaxdata);

		if (stringSourceMaxData.length() > 3) {
			int chk1 = Integer.parseInt(stringSourceMaxData.substring(0, 1));
			int chk2 = Integer.parseInt(stringSourceMaxData.substring(1, 2));
			int chk3 = Integer.parseInt(stringSourceMaxData.substring(2, 3));

			if (chk3 >= 5) {
				chk2++;
			}

			if (chk2 >= 10) {
				chk1++;
				chk2 = 0;
			}

			stringCreateMaxData = "" + chk1 + chk2;

			for (int i = 0; i < (stringSourceMaxData.length() - 2); i++) {
				stringCreateMaxData += "0";
			}
		} else if (stringSourceMaxData.length() == 3) {
			int chk1 = Integer.parseInt(stringSourceMaxData.substring(0, 1));
			int chk2 = Integer.parseInt(stringSourceMaxData.substring(1, 2));
			int chk3 = Integer.parseInt(stringSourceMaxData.substring(2, 3));

			if (chk3 >= 5) {
				chk2++;
			}

			if (chk2 >= 10) {
				chk1++;
				chk2 = 0;
			}

			stringCreateMaxData = "" + chk1;

			for (int i = 0; i < (stringSourceMaxData.length() - 1); i++) {
				stringCreateMaxData += "0";
			}
		} else if (stringSourceMaxData.length() == 2) {
			int chk1 = Integer.parseInt(stringSourceMaxData.substring(0, 1));
			int chk2 = Integer.parseInt(stringSourceMaxData.substring(1, 2));

			if (chk2 >= 5) {
				chk1++;
			} else if (chk1 > 5) {
				chk1++;
			}

			stringCreateMaxData = "" + chk1 + "0";
		}

		yScall = Long.parseLong(stringCreateMaxData);

		return yScall;
	}

	/**
	 * XXP[Zbg܂B
	 * 
	 * @param chartXScall
	 *            XXP[
	 */
	public void setChartXScall(int chartXScall) {
		this.chartXScall = chartXScall;
		this.xAxisPoint[0] = chartXScall;
	}

	/**
	 * YXP[Zbg܂B
	 * 
	 * @param chartYScall
	 *            YXP[
	 */
	public void setChartYScall(int chartYScall) {
		this.chartYScall = chartYScall;
		this.xAxisPoint[1] = chartYScall;
		this.pointXY0[1] = chartYScall;
	}

	/**
	 * XXP[Ԃ܂B
	 * 
	 * @return XXP[
	 */
	public int getChartXScall() {
		return chartXScall;
	}

	/**
	 * YXP[Ԃ܂B
	 * 
	 * @return YXP[
	 */
	public int getChartYScall() {
		return chartYScall;
	}

	protected void finalize() throws Throwable {
		super.finalize();

		if (zoominImage != null && !zoominImage.isDisposed()) {
			zoominImage.dispose();
		}

		if (zoomoutImage != null && !zoomoutImage.isDisposed()) {
			zoomoutImage.dispose();
		}

		if (gc != null && !gc.isDisposed()) {
			gc.dispose();
		}

		if (canvas != null && !canvas.isDisposed()) {
			canvas.dispose();
		}
	}
}
