/*
 * Created on 2004/10/11
 *
 *
 */
package netjfwatcher.snmp.messageformat;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.integer.SnmpTimeTicks;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpIPAddress;



/**
 * SNMP V2C/V3 Trap\NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpTrap2PDU extends SnmpSequence {
    /**
     * Snmp V2C܂V3 TrapCX^X𐶐܂B
     *
     * @param agentStartTime Agent Start Time
     * @param snmpTrapOidValueString  Trap OID
     * @param variablePair  variable pair
     * @throws SnmpBadValueException Trap PDUɎsꍇ
     */
    public SnmpTrap2PDU(
        long agentStartTime, String snmpTrapOidValueString,
        SnmpVariablePair variablePair) throws SnmpBadValueException {
        super();

        tag = SnmpBERCodec.SNMPTRAP2; // ^OR[hݒi0xA7j

        /* TrapReci[XgvarBindListi[
         * varBindListɂ͈ȉi[Ă
         * (1) SysUpTime OID
         * (2) Trap OID
         * (3) varBindList
         */
        List trapContentsList = Collections.synchronizedList(new ArrayList());

        /* Snmp sysUpTime OIDstart timeɂvarBind */
        SnmpSequence varBindList = new SnmpSequence();
        SnmpObjectIdentifier snmpSysupTimeOID =
            new SnmpObjectIdentifier(SnmpPreference.SNMP_SYSUPTIME_OID);
        SnmpTimeTicks sysUpTime = new SnmpTimeTicks(agentStartTime);
        varBindList.addSNMPObject(
            new SnmpVariablePair(snmpSysupTimeOID, sysUpTime));

        /* Snmp Trap OIDValueƂĂSnmp Trap OID ValueɂvarBind */
        SnmpObjectIdentifier snmpTrapOID =
            new SnmpObjectIdentifier(SnmpPreference.SNMP_TRAP_OID);
        SnmpObjectIdentifier snmpTrapOIDValue =
            new SnmpObjectIdentifier(snmpTrapOidValueString);
        varBindList.addSNMPObject(
            new SnmpVariablePair(snmpTrapOID, snmpTrapOIDValue));

        /* varBindList */
        varBindList.addSNMPObject(variablePair);
        trapContentsList.add(varBindList);

        // NXf[^Ƃĕێ
        this.setValue(trapContentsList);
    }

    /**
     * Create a new Trap PDU of the specified type, with given request ID,
     * error status, and error index,
     * and containing an empty SNMP sequence (VarBindList) as additional data.
     *
     * @param enterpriseOID Enterprise OID
     * @param agentAddress AgnetAhX
     * @param genericTrap Generic TrapR[h
     * @param specificTrap Specific TrapR[h
     * @param timestamp Timestamp
     * @throws SnmpBadValueException Trap PDUɎsꍇ
     */
    public SnmpTrap2PDU(
        SnmpObjectIdentifier enterpriseOID, SnmpIPAddress agentAddress,
        int genericTrap, int specificTrap, SnmpTimeTicks timestamp)
        throws SnmpBadValueException {
        super();

        tag = SnmpBERCodec.SNMPTRAP2;

        List contents = Collections.synchronizedList(new ArrayList());

        contents.add(enterpriseOID);
        contents.add(agentAddress);
        contents.add(new SnmpInteger(genericTrap));
        contents.add(new SnmpInteger(specificTrap));
        contents.add(timestamp);
        contents.add(new SnmpVarBindList());

        this.setValue(contents);
    }

    /**
     * oCgzf[^BER encodingɂTrapCX^X𐶐܂B
     *
     * Create a new PDU of the specified type from the supplied BER encoding.
     * @param enc oCgz
     * @throws SnmpBadValueException Indicates invalid SNMP PDU encoding supplied in enc.
     */
    public SnmpTrap2PDU(byte[] enc) throws SnmpBadValueException {
        tag = SnmpBERCodec.SNMPTRAP2;
        extractFromBEREncoding(enc);
    }

    /**
     * Trap PDUɎʔԍAG[Xe[^XyуG[Indext܂B
     *
     * @param requestID NGXgID
     * @param errorStatus G[Xe[^X
     * @param errorIndex G[Index
     */
    public void setPDU(int requestID, int errorStatus, int errorIndex) {
        sequenceList.add(0, new SnmpInteger(requestID));
        sequenceList.add(1, new SnmpInteger(errorStatus));
        sequenceList.add(2, new SnmpInteger(errorIndex));
    }

    /**
     * PDU^CvԂ܂B
     *
     * @return tag PDU^Cv
     */
    public byte getPDUType() {
        return tag;
    }

    /**
     * VarBindListԂ܂B
     *
     * A utility method that extracts the variable binding list from the pdu. Useful for retrieving
     * the set of (object identifier, value) pairs returned in response to a request to an SNMP
     * device. The variable binding list is just an SNMP sequence containing the identifier, value pairs.
     * @see snmp.SnmpVarBindList
     * @return VarBindList
     */
    public SnmpSequence getVarBindList() {
        List contents = (List) (this.getValue());

        return (SnmpSequence) (contents.get(5));
    }

    /**
     * Enterprise OIDԂ܂B
     *
     * A utility method that extracts the enterprise OID from this PDU.
     *
     * @return Enterprise OID
     */
    public SnmpObjectIdentifier getEnterpriseOID() {
        List contents = (List) (this.getValue());

        return (SnmpObjectIdentifier) contents.get(0);
    }

    /**
     * G[WFgAddressԂ܂B
     *
     * @return G[WFgAddress
     */
    public SnmpIPAddress getAgentAddress() {
        List contents = (List) (this.getValue());

        if (contents.get(1) instanceof SnmpIPAddress) {
            return (SnmpIPAddress) contents.get(1);
        }

        return null;
    }

    /**
     * Generic TrapR[hԂ܂B
     *
     * A utility method that returns the generic trap code for this PDU.
     *
     * @return Generic TrapR[h
     */
    public int getGenericTrap() {
        List contents = (List) (this.getValue());

        return ((BigInteger) ((SnmpInteger) (contents.get(2))).getValue())
        .intValue();
    }

    /**
     * Specific TrapR[hԂ܂B
     *
     * A utility method that returns the specific trap code for this PDU.
     *
     * @return Specific TrapR[h
     */
    public int getSpecificTrap() {
        List contents = (List) (this.getValue());

        return ((BigInteger) ((SnmpInteger) (contents.get(3))).getValue())
        .intValue();
    }

    /**
     * TimestampԂ܂B
     *
     * A utility method that returns the timestamp for this PDU.
     *
     * @return Timestamp
     */
    public long getTimestamp() {
        List contents = (List) (this.getValue());

        return ((BigInteger) ((SnmpTimeTicks) (contents.get(4))).getValue())
        .longValue();
    }
}
