/*
 * Created on 2005/03/01
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.mibtree;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;

import javax.swing.tree.DefaultMutableTreeNode;

import netjfwatcher.application.NetJFWatcherPlugin;

import org.osgi.framework.Bundle;


/**
 * MIB`CSVt@CMIB OID Tree𐶐钊ۃNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public abstract class AbstractMibTree {
    /** SNMPIuWFNg Integer^Cv */
    public static final String INTEGER = "INTEGER";

    /** SNMPIuWFNg Counter32^Cv */
    public static final String COUNTER32 = "Counter32";

    /** SNMPIuWFNg Counter64^Cv */
    public static final String COUNTER64 = "Counter64";

    /** SNMPIuWFNg Gauge32^Cv */
    public static final String GAUGE32 = "Gauge32";

    /** SNMPIuWFNg OctetString^Cv */
    public static final String OCTETSTRING = "OctetString";

    /** SNMPIuWFNg IpAddress^Cv */
    public static final String IPADDRESS = "IpAddress";

    /** SNMPIuWFNg ObjectID^Cv */
    public static final String OBJECTID = "ObjectID";

    /** SNMPIuWFNg TimeTicks^Cv */
    public static final String TIMETICKS = "TimeTicks";

    /** SNMPIuWFNg Uinteger32^Cv */
    public static final String UINTEGER32 = "Uinteger32";

    /** SNMPIuWFNg Bits^Cv */
    public static final String BITS = "Bits";

    /** SNMPIuWFNg Opaque^Cv */
    public static final String OPAQUE = "Opaque";

    /** SNMPIuWFNg DisplayString^Cv */
    public static final String DISPLAYSTRING = "DisplayString";

    /* MO */
    private static Logger logger;

    /** MIB`CSVt@CMIBi[郊Xg */
    public ArrayList<MibInfo> oidList = new ArrayList<MibInfo>();

    /** OIDL[ƂMIBێ郊Xg */
    public HashMap<String, MibInfo> oidHashMap = new HashMap<String, MibInfo>();

    /** OIDL[ƂMIBێ郊Xg */
    public HashMap<String, MibInfo> mibDescripHashMap = new HashMap<String, MibInfo>();

    /** TreeNode */
    public DefaultMutableTreeNode rootTreeNode;

    /**
     * MIB`CSVt@CMIB OID Tree𐶐钊ۃNX
     * CX^X𐶐܂B
     *
     */
    public AbstractMibTree() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * wMIB`CSVt@COID Treeč\z܂B
     *
     * @param fileName MIB`CSVt@C
     */
    public void reloadOidTree(String fileName) {
        oidList.clear();
        oidHashMap.clear();
        mibDescripHashMap.clear();
        rootTreeNode = null;

        this.parseCSVFile(fileName);
    }

    /**
    * CSVt@CA1sƂOIDŁAJ}ŋ؂ꂽ񂩂
    * OIDƂăXgɊi[Ă
    *
    * @param fileName MIB`CSVt@C
    */
    public void parseCSVFile(String fileName) {
        oidList = new ArrayList<MibInfo>();

        int cnt = 0;

        logger.info("Mib table create start ..." + fileName);

        InputStream instream = null;
        InputStreamReader instreamReader = null;
        BufferedReader bufReader = null;

        try {
            /* MIB`t@CURL擾 */
            URL url = this.getDocumentURL(fileName);

            /*
             * MIB`t@Cǂݍ
             */
            instream = url.openStream();
            instreamReader = new InputStreamReader(instream);
            bufReader = new BufferedReader(instreamReader);

            // CSVt@CsPʂɓǂݍޕ
            String lineString;
            Pattern pattern;
            String[] mibLineItemArray;

            while ((lineString = bufReader.readLine()) != null) {
                if (lineString.indexOf("#") >= 0) {
                    // cnt++;
                    continue;
                }

                pattern = Pattern.compile(",");
                mibLineItemArray = pattern.split(lineString);

                try {
                    if (mibLineItemArray.length != 4) {
                        logger.info(lineString);
                    } else {
                        oidList.add(new MibInfo(mibLineItemArray));
                    }
                } catch (Exception e1) {
                    logger.warning(lineString);
                    e1.printStackTrace();
                }

                cnt++;
            }
        } catch (FileNotFoundException e) {
            // logger.severe("FileNotFoundException : " + filePath);
            e.printStackTrace();
        } catch (IOException e) {
            logger.severe(e.getMessage());
            e.printStackTrace();
        } finally {
            if (bufReader != null) {
                try {
                    bufReader.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }

            if (instreamReader != null) {
                try {
                    instreamReader.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }

            if (instream != null) {
                try {
                    instream.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }

        /* MIB Tree Rootݒ */
        rootTreeNode = ((MibInfo) oidList.get(0)).getTreeNode();
        this.setupTreeNode(
            rootTreeNode, ((MibInfo) oidList.get(1)).getTreeNode());
        ((MibInfo) oidList.get(1)).setParentOid(
            ((MibInfo) oidList.get(0)).getOid());

        /*
         *
         */
        int muchParenNodeCnt = 0;
        int parentOidIndexCnt = -1;

        for (int childNodeCnt = 0; childNodeCnt < cnt; childNodeCnt++) {
            /* Nodeeq֌Wm肵ۂtO */
            boolean found = false;

            /*
             * eNode OIDɍvqNode OID
             */
            for (
                int parentNodeCnt = 1;
                    (parentNodeCnt < (childNodeCnt + 1))
                    && ((parentNodeCnt + 1) < cnt); parentNodeCnt++) {
                /*
                     * qNode OIDeNode OID܂(eq֌W)`FbN
                     */
                parentOidIndexCnt =
                    ((MibInfo) oidList.get(childNodeCnt)).getOid().indexOf(
                        ((MibInfo) oidList.get(parentNodeCnt)).getOid());

                if (parentOidIndexCnt == 0) {
                    parentOidIndexCnt =
                        ((MibInfo) oidList.get(childNodeCnt)).getOid().indexOf(
                            ((MibInfo) oidList.get(parentNodeCnt + 1)).getOid());

                    if (
                        ((parentOidIndexCnt != 0)
                            || ((parentNodeCnt + 1) == childNodeCnt))
                            || ((parentOidIndexCnt == 0)
                            && (((MibInfo) oidList.get(childNodeCnt)).getLayer() == ((MibInfo) oidList
                            .get(parentNodeCnt + 1)).getLayer()))) {
                        Pattern pattern;
                        String[] item;
                        String[] item2;

                        pattern = Pattern.compile("[.]");
                        item =
                            pattern.split(
                                ((MibInfo) oidList.get(parentNodeCnt)).getOid());
                        item2 =
                            pattern.split(
                                ((MibInfo) oidList.get(childNodeCnt)).getOid());

                        if (
                            item[item.length - 1].equals(
                                    item2[item.length - 1])) {
                            if (parentNodeCnt != childNodeCnt) {
                                if (
                                    ((MibInfo) oidList.get(childNodeCnt))
                                        .getLayer() != ((MibInfo) oidList.get(
                                            parentNodeCnt)).getLayer()) {
                                    muchParenNodeCnt = parentNodeCnt;
                                    found = true;
                                }
                            }
                        }
                    }
                }
            }

            if (found) {
                /*
                     * Nodeeq֌WZbg
                     */
                this.setupTreeNode(
                    ((MibInfo) oidList.get(muchParenNodeCnt)).getTreeNode(),
                    ((MibInfo) oidList.get(childNodeCnt)).getTreeNode());
                ((MibInfo) oidList.get(childNodeCnt)).setParentOid(
                    ((MibInfo) oidList.get(muchParenNodeCnt)).getOid());
            }
        }

        /*
         * Node TreeǂāAHashMapZbgB
         * ɂAOID̎OID̃ZbgAyуj[Nۏ؂
         */
        Enumeration enumNodeTree =
            ((MibInfo) oidList.get(0)).getTreeNode().preorderEnumeration();

        int oidListCnt = 0;

        while (enumNodeTree.hasMoreElements()) {
            DefaultMutableTreeNode node =
                (DefaultMutableTreeNode) (enumNodeTree.nextElement());

            if (((MibInfo) oidList.get(oidListCnt)).getTreeNode().equals(node)) {
                MibInfo miboid = (MibInfo) oidList.get(oidListCnt);

                if (oidList.size() > (oidListCnt + 1)) {
                    MibInfo nextMibOid = (MibInfo) oidList.get(oidListCnt + 1);
                    miboid.setNextMibOid(nextMibOid.getOid());
                } else {
                    miboid.setNextMibOid("1.4");
                }

                oidHashMap.put(
                    ((MibInfo) oidList.get(oidListCnt)).getOid(),
                    oidList.get(oidListCnt));
                mibDescripHashMap.put(
                    ((MibInfo) oidList.get(oidListCnt)).getDescrip(),
                    oidList.get(oidListCnt));
            } else {
                logger.warning(
                    "unmuch :tree: " + node + " :array:"
                    + ((MibInfo) oidList.get(oidListCnt)).getTreeNode());

                break;
            }

            oidListCnt++;
        }

        // logger.info("Mib table create end.");

        /*
        int nodeCount = rootTreeNode.getLeafCount();
        logger.info("Agent instance node count : " + nodeCount);
        */
    }

    /**
     * w̃t@CURLԂ܂B
     *
     * @param fileName t@C
     * @return url URL
     */
    public URL getDocumentURL(String fileName) {
        /* 摜肷邽߂PluginResource bundle */
        Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
        URL url = null;
        url = bundle.getEntry(fileName);

        if (url == null) {
            /* bZ[W\[Xt@CȂꍇMO̎ */
            logger.severe("MIB defined CSV file : " + fileName);
        }

        return url;
    }

    /**
     * wNode̐eq֌Wݒ肵܂B
     *
     * @param parentNode em[h
     * @param childNode qm[h
     */
    private void setupTreeNode(Object parentNode, Object childNode) {
        DefaultMutableTreeNode leaf = ((DefaultMutableTreeNode) childNode);
        DefaultMutableTreeNode parent = ((DefaultMutableTreeNode) parentNode);
        parent.add(leaf);
    }

    /**
     * MIB`OIDL[ƂĕێMapԂ܂B
     *
     * @return oidHashMap MIB`OIDL[ƂĕێMap
     */
    public HashMap getOidHashMap() {
        return oidHashMap;
    }

    /**
     * MIB`ێListԂ܂B
     *
     * @return oidList MIB`ێList
     */
    public ArrayList getOidList() {
        return oidList;
    }

    /**
     * MIB`MIBLqL[ƂĕێMapԂ܂B
     *
     * @return mibDescripHashMap MIB`MIBLqL[ƂĕێMap
     */
    public HashMap getMibDescripHashMap() {
        return mibDescripHashMap;
    }

    /**
     * MIB`OIDL[ƂĕێMapZbg܂B
     *
     * @param map MIB`OIDL[ƂĕێMap
     */
    public void setOidHashMap(HashMap map) {
        oidHashMap = map;
    }

    /**
     * MIB`񃊃XgZbg܂B
     *
     * @param list MIB`񃊃Xg
     */
    public void setOidList(ArrayList list) {
        oidList = list;
    }
}
