/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.preference;


/**
 * ASN.1(Abstract Syntax Notaion 1) BER(Basic Encoding Rule)GR[fBO
 * ł̒`LqNXłB
 *
 */
public class SnmpBERCodec {
    /** SNMP Integer TAG Description */
    public static final String SNMPINTEGER = "INTEGER";

    /** SNMP Bit String TAG Description */
    public static final String SNMPBITSTRING = "BITSTRING";

    /** SNMP Octet String TAG Description */
    public static final String SNMPOCTETSTRING = "OCTETSTRING";

    /** SNMP Null TAG Description */
    public static final String SNMPNULL = "NULL";

    /** SNMP Object Indentifier TAG Description */
    public static final String SNMPOBJECTIDENTIFIER = "OBJECTIDENTIFIER";

    /** SNMP Integer TAG Description */
    public static final String SNMPSEQUENCE = "SEQUENCE";

    /** SNMP IP Address TAG Description */
    public static final String SNMPIPADDRESS = "IPADDRESS";

    /** SNMP Integer32 TAG Description */
    public static final String SNMPUINTEGER32 = "INTEGER32";

    /** SNMP Counter32 TAG Description */
    public static final String SNMPCOUNTER32 = "COUNTER32";

    /** SNMP Counter64 TAG Description */
    public static final String SNMPCOUNTER64 = "COUNTER64";

    /** SNMP Gauge32 TAG Description */
    public static final String SNMPGAUGE32 = "GAUGE32";

    /** SNMP TimeTicks TAG Description */
    public static final String SNMPTIMETICKS = "TIMETICKS";

    /** SNMP Opaque TAG Description */
    public static final String SNMPOPAQUE = "OPAQUE";

    /** SNMP NSAP Address TAG Description */
    public static final String SNMPNSAPADDRESS = "NSAPADDRESS";

    /* ----------------------------------------------------------- */
    /* TAGtB[h`ɂbitӖ                            */

    /** TAG Classłuniversal bit */
    public static final int TAG_CLASS_UNIVERSAL = 0x00;

    /** TAG Classłapplication-wide bit */
    public static final int TAG_CLASS_APPLICATION_WIDE = 0x040;

    /** TAG Classłcontext-specific bit */
    public static final int TAG_CLASS_CONTEXT_SPECIFIC = 0x80;

    /** TAG Classłprivate bit */
    public static final int TAG_CLASS_PRIVATE = 0xC0;

    /** TAGtB[hprimitive/constructed bitłconstructed bit */
    public static final byte TAG_FLAG_CONSTRUCTED = 0x20;

    /* ----------------------------------------------------------- */
    /* TAGԍ                                                     */

    /** Integer TAGԍ */
    public static final byte SNMPINTEGER_TAG = 0x02;

    /** Bit String TAGԍ */
    public static final byte SNMPBITSTRING_TAG = 0x03;

    /** Octet String TAGԍ */
    public static final byte SNMPOCTETSTRING_TAG = 0x04;

    /** Null TAGԍ*/
    public static final byte SNMPNULL_TAG = 0x05;

    /** Object Identifier TAGԍ */
    public static final byte SNMPOBJECTIDENTIFIER_TAG = 0x06;

    /** Object Descriptor TAGԍ */
    public static final byte SNMPOBJECTDESCRIPTOR_TAG = 0x07;

    /** SEQUENCE TAGԍ */
    public static final byte SNMPSEQUENCE_TAG_NUMBER = 0x10;

    /** TAGtB[hłSEQUENCEl */
    public static final byte SNMPSEQUENCE_TAG =
        TAG_FLAG_CONSTRUCTED | SNMPSEQUENCE_TAG_NUMBER;

    /* ----------------------------------------------------------- */
    /*                                                             */

    /** IP Aaddress TAGԍ */
    public static final byte SNMPIPADDRESS_TAG = (byte) 0x40;

    /** Counter32 TAGԍ */
    public static final byte SNMPCOUNTER32_TAG = (byte) 0x41;

    /** Gauge32 TAGԍ */
    public static final byte SNMPGAUGE32_TAG = (byte) 0x42;

//    /** TimeTicks TAGԍ */
    public static final byte SNMPTIMETICKS_TAG = (byte) 0x43;

    /** Opaque TAGԍ */
    public static final byte SNMPOPAQUE_TAG = (byte) 0x44;

    /** NsapAddress TAGԍ */
    public static final byte SNMPNSAPADDRESS_TAG = (byte) 0x45;

    /** Counter64 TAGԍ */
    public static final byte SNMPCOUNTER64_TAG = (byte) 0x46;

    /** Integer32 TAGԍ */
    public static final byte SNMPUINTEGER32_TAG = (byte) 0x47;

    /** <p>Opaque ^ 64bits JE^[</p> */
    public static final int OPAQUE_COUNTER64 = 0x76;

    /** <p>Opaque ^ 32bits _(float)</p> */
    public static final int OPAQUE_FLOAT = 0x78;

    /** <p>Opaque ^ 64bits _(double)</p> */
    public static final int OPAQUE_DOUBLE = 0x79;

    /** <p>Opaque ^ 64bits 萮</p> */
    public static final int OPAQUE_INTEGER64 = 0x7a;

    /** <p>Opaque ^ 64bits Ȃ</p> */
    public static final int OPAQUE_UNSIGNED64 = 0x7b;

    /* ----------------------------------------------------------- */
    /* PDU TypeiSNMPR}hj                                    */

    /**
     * Get Request-PDU types in SNMPv1, SNMPsec, SNMPv2p, SNMPv2c,
     * SNMPv2u, SNMPv2*, and SNMPv3
     */
    public static final byte SNMPGETREQUEST = (byte) 0xA0;

    /**
     * Get Next Request-PDU types in SNMPv1, SNMPsec, SNMPv2p, SNMPv2c,
     * SNMPv2u, SNMPv2*, and SNMPv3
     */
    public static final byte SNMPGETNEXTREQUEST = (byte) 0xA1;

    /**
     * Get Response-PDU types in SNMPv1, SNMPsec, SNMPv2p, SNMPv2c,
     * SNMPv2u, SNMPv2*, and SNMPv3
     */
    public static final byte SNMPGETRESPONSE = (byte) 0xA2;

    /**
     * Set Request-PDU types in SNMPv1, SNMPsec, SNMPv2p, SNMPv2c,
     * SNMPv2u, SNMPv2*, and SNMPv3
     */
    public static final byte SNMPSETREQUEST = (byte) 0xA3;

    /**
     * Trap-PDU types in SNMPv1 and SNMPsec
     */
    public static final byte SNMPTRAP = (byte) 0xA4;

    /**
     * Get Bulk-PDU types in SNMPv2p, SNMPv2c, SNMPv2u,
     * SNMPv2*, and SNMPv3
     */
    public static final byte SNMPGETBULK = (byte) 0xA5;

    /**
     * Inform-PDU types in SNMPv2p, SNMPv2c, SNMPv2u,
     * SNMPv2*, and SNMPv3
     */
    public static final byte SNMPINFORM = (byte) 0xA6;

    /**
     * Trap2-PDU types in SNMPv2p, SNMPv2c, SNMPv2u, SNMPv2*,
     * and SNMPv3
     */
    public static final byte SNMPTRAP2 = (byte) 0xA7;

    /**
     * Report-PDU types SNMPv2u, SNMPv2*, and SNMPv3
     */
    public static final byte SNMP_MSG_REPORT = (byte) 0xA8;

    // SNMPv2p constants; unused!!

    /** SNMP V2P Communication PDU type */
    public static final byte SNMP_V2P_COMMUNICATION = (byte) 0xA2;

    /** SNMP V2P Authorized Message PDU type */
    public static final byte SNMP_V2P_AUTHORIZEDMESSAGE = (byte) 0xA1;

    /** SNMP V2P Encrypted Message PDU type */
    public static final byte SNMP_V2P_ENCRYPTEDMESSAGE = (byte) 0xA1;

    /** SNMP V2P Encrypted Data PDU type */
    public static final byte SNMP_V2P_ENCRYPTEDDATA = (byte) 0xA1;

    /* ----------------------------------------------------------- */
    /* Command(PDU Type) Description                               */

    /** Trap PDU type Description */
    public static final String COMMAND_TRAP_PDU_DESCRIPTION = "Trap-PDU";

    /** Trap2 PDU type Description */
    public static final String COMMAND_TRAP2_PDU_DESCRIPTION = "Trap2-PDU";

    /** Inform PDU type Description */
    public static final String COMMAND_INFORM_PDU_DESCRIPTION = "Inform-PDU";

    /** Get Request PDU type Description */
    public static final String COMMAND_GET_REQUEST_DESCRIPTION = "GetRequest";

    /** Get Next Request PDU type Description */
    public static final String COMMAND_GET_NEXT_REQUEST_DESCRIPTION =
        "GetNextRequest";

    /** Set Request PDU type Description */
    public static final String COMMAND_SET_REQUEST_DESCRIPTION = "SetRequest";

    /** Get Response PDU type Description */
    public static final String COMMAND_GET_RESPONSE_DESCRIPTION = "GetResponse";

    /** SNMP Unknown Object TAG */
    public static final byte SNMPUNKNOWNOBJECT_TAG = 0x00;

    /** SNMP Unknown Object Description */
    public static final String SNMPUNKNOWNOBJECT = "UNKNOWNOBJECT";
}
