/*
 * Created on 2004/09/22
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpv3;

import java.io.Serializable;


/**
 * SNMP V3 engineID𐶐A삷郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpEngineID implements Serializable {
    /*
     * serialVersionUID
     */
    private static final long serialVersionUID = -8329761101443998815L;
    private static final int ID_LENGTH = 32;

    /* snmpEngineID */
    private byte[] id = null;

    /**
     * SnmpEngineID ̃CX^X𐶐܂B
     * w肳ꂽoCgz 32 oCgzꍇA擪 32 oCg
     * SnmpEngineID ɐݒ肵܂B
     *
     * @param engineID snmpEngineID
     */
    public SnmpEngineID(byte[] engineID) {
        int length = 0;

        if (engineID != null) {
            length = engineID.length;
        }

        if (length > ID_LENGTH) {
            length = ID_LENGTH;
        }

        id = new byte[length];
        System.arraycopy(engineID, 0, id, 0, length);
    }

    /**
     * SnmpEngineID ̃CX^X𐶐܂B
     * w肳ꂽ 16 i\Ƃĉ߂܂B񒷂 64 (32 oCg)
     * zꍇA擪 64  SnmpEngineID ɐݒ肵܂B
     *
     * @param engineID snmpEngineID
     * @throws NumberFormatException w肳ꂽ 16 i\
     * łȂꍇɃX[܂B
     */
    public SnmpEngineID(String engineID) throws NumberFormatException {
        int length = 0;

        if (engineID != null) {
            if ((engineID.length() % 2) != 0) {
                engineID = "0".concat(engineID);
            }

            length = engineID.length() / 2;
        }

        if (length > ID_LENGTH) {
            length = ID_LENGTH;
        }

        id = new byte[length];

        for (int i = 0; i < length; i++) {
            id[i] =
                (byte) Integer.parseInt(
                    engineID.substring(i * 2, (i * 2) + 2), 16);
        }
    }

    /**
     * ̃IuWFNgƎw肳ꂽIuWFNgr܂B
     *  null łȂÃIuWFNgƓ snmpEngineID \
     * SnmpEngineID IuWFNgłꍇɂAʂ true ɂȂ
     * ܂B
     *
     * @param obj  SnmpEngineID ƔrIuWFNg
     * @return snmpEngineID ꍇ trueAłȂꍇ false
     */
    public boolean equals(Object obj) {
        if ((obj == null) || !(obj instanceof SnmpEngineID)) {
            return false;
        }

        SnmpEngineID engineID = (SnmpEngineID) obj;

        if (this.id.length != engineID.id.length) {
            return false;
        }

        for (int i = 0, li = this.id.length; i < li; i++) {
            if (this.id[i] != engineID.id[i]) {
                return false;
            }
        }

        return true;
    }

    /**
     * ̃IuWFNg̕\Ԃ܂B
     *
     * @return ̃IuWFNg̕\
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();

        for (int i = 0, li = id.length; i < li; i++) {
            String str = Integer.toHexString(id[i] & 0xff);

            if (str.length() == 1) {
                sb.append("0");
            }

            sb.append(str);
        }

        return sb.toString();
    }

    /**
     * engineIDԂ܂B
     *
     * @return id engineID
     */
    public byte[] getId() {
        return id;
    }

    /**
     * engineIDZbg܂B
     *
     * @param id engineID
     */
    public void setId(byte[] id) {
        this.id = id;
    }
}
