/*
 * Created on 2004/09/22
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpv3;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import javax.crypto.SecretKey;


/**
 * USM[JCYKeyێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class UsmLocalizeKey implements SecretKey {
    /*
     * serialVersionUID
     */
    private static final long serialVersionUID = 1L;
    
    /** MD5 ASY */
    public static final String KEY_GEN_ALGO_HMAC_MD5 = "HmacMD5";

    /** SHA ASY */
    public static final String KEY_GEN_ALGO_HMAC_SHA = "HmacSHA1";

    /* ASY */
    private String algorithm = null;

    /* f[^ */
    private byte[] key = null;

    /**
     * UsmLocalizeKey ̃CX^X𐶐܂B
     *
     * @param password pX[h
     * @param snmpEngineID SnmpEngineID
     * @param algorithm 𐶐̂ɎgpASY
     * @throws NoSuchAlgorithmException algorithm  MD5 ܂ SHA ȊO
     * ꍇɃX[܂B
     */
    protected UsmLocalizeKey(
        String password, SnmpEngineID snmpEngineID, String algorithm)
        throws NoSuchAlgorithmException {
        if (algorithm.equals(KEY_GEN_ALGO_HMAC_MD5)) {
            this.algorithm = KEY_GEN_ALGO_HMAC_MD5;
            key = passwordToKeyMD5(password, snmpEngineID);
        } else if (algorithm.equals(KEY_GEN_ALGO_HMAC_SHA)) {
            this.algorithm = KEY_GEN_ALGO_HMAC_SHA;
            key = passwordToKeySHA(password, snmpEngineID);
        } else {
            throw new NoSuchAlgorithmException(
                new StringBuffer("Unsupported algorithm: ").append(algorithm)
                                                           .toString());
        }
    }


    /**
     * ̌ɑ΂WASYԂ܂B
     *
     * @return ̌Ɋ֘AASY̖O
     */
    public String getAlgorithm() {
        return algorithm;
    }

    /**
     * ̔閧̌f[^Ԃ܂B
     *
     * @return f[^
     */
    public byte[] getEncoded() {
        int length = key.length;
        byte[] array = new byte[length];
        System.arraycopy(key, 0, array, 0, length);

        return array;
    }

    /**
     * ̔閧̕`̖OԂ܂B
     *
     * @return  "USM"
     */
    public String getFormat() {
        return "RAW";
    }

    /**
     * MD5 pă[JCYEL[𐶐܂B
     *
     * @param password pX[h
     * @param snmpEngineID SnmpEngineID
     * @return [JCYEL[
     * @throws NoSuchAlgorithmException MD5ASYĂяo
     * Ŏgp\łȂꍇɃX[܂
     */
    private byte[] passwordToKeyMD5(String password, SnmpEngineID snmpEngineID)
        throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(UsmUserManager.MSG_DIGEST_MD5);
        byte[] buff = new byte[64];
        byte[] passwd = password.getBytes();
        byte[] engineID = snmpEngineID.getId();

        int count = 0;
        int index = 0;

        while (count < 1048576) {
            for (int i = 0; i < 64; i++) {
                buff[i] = passwd[index++ % passwd.length];
            }

            md.update(buff, 0, 64);
            count += 64;
        }

        byte[] key = md.digest();

        for (int i = 0; i < 16; i++) {
            buff[i] = key[i];
        }

        for (int i = 0; i < engineID.length; i++) {
            buff[i + 16] = engineID[i];
        }

        for (int i = 0; i < 16; i++) {
            buff[i + 16 + engineID.length] = key[i];
        }

        md.update(buff, 0, 32 + engineID.length);

        return md.digest();
    }

    /**
     * SHA pă[JCYEL[𐶐܂B
     *
     * @param password pX[h
     * @param snmpEngineID SnmpEngineID
     * @return [JCYEL[
     * @throws NoSuchAlgorithmException SHAASYĂяo̊
     * gp\łȂꍇɃX[܂
     */
    private byte[] passwordToKeySHA(String password, SnmpEngineID snmpEngineID)
        throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(UsmUserManager.MSG_DIGEST_SHA1);
        byte[] buff = new byte[72];
        byte[] passwd = password.getBytes();
        byte[] engineID = snmpEngineID.getId();

        int count = 0;
        int index = 0;

        while (count < 1048576) {
            for (int i = 0; i < 64; i++) {
                buff[i] = passwd[index++ % passwd.length];
            }

            md.update(buff, 0, 64);
            count += 64;
        }

        byte[] key = md.digest();

        for (int i = 0; i < 20; i++) {
            buff[i] = key[i];
        }

        for (int i = 0; i < engineID.length; i++) {
            buff[i + 20] = engineID[i];
        }

        for (int i = 0; i < 20; i++) {
            buff[i + 20 + engineID.length] = key[i];
        }

        md.update(buff, 0, 40 + engineID.length);

        return md.digest();
    }
}
