/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent;

import java.util.logging.Logger;

import netjfwatcher.snmpagent.model.AgentMonitorMessageQueue;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;



/**
 * Snmp AgentƂē쒆ɂ鑗Mf[^j^[\
 * ߂ViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AgentCommunicationMonitorView extends AbstractAgentView {
    /** j^[\f[^L[Ď */
    public static final int AGENT_MONITOR_TIMER = 1000;

    /* MO */
    private static Logger logger;

    /* j^[\eLXg */
    private Text moniterText;

    /* Display */
    private Display display;

    /* j^\f[^L[ĎThread */
    private TimerProcessorThread timerProcessor;

    /* j^Zbg{^ */
    private Button monitorResetButton;

    /* j^Jn{^ */
    private Button startButton;

    /* j^~{^ */
    private Button stopButton;

    /**
     * PartControl𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
        logger = Logger.getLogger(this.getClass().getName());

        display = parent.getDisplay();

        // j^\f[^L[Ď^C}[Thread̐
        timerProcessor = new TimerProcessorThread();

        /*
         * eCompositezueLayout
         * ieCompositec1ɔzuj
         */
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout(layout);

        GridData gridData = null;

        /*
         * ButtonzuComposite
         */
        GridLayout gridLayout = new GridLayout(3, false);
        Composite composite = new Composite(parent, SWT.NULL);

        gridData = new GridData();
        composite.setLayout(gridLayout);
        composite.setLayoutData(gridData);

        monitorResetButton = new Button(composite, SWT.BORDER);
        monitorResetButton.setText("Reset");

        startButton = new Button(composite, SWT.BORDER);
        startButton.setText("Start");

        stopButton = new Button(composite, SWT.BORDER);
        stopButton.setText("Stop");

        GridLayout gridLayout2 = new GridLayout(1, true);
        Composite composite2 = new Composite(parent, SWT.NONE);
        composite2.setLayoutData(new GridData(GridData.FILL_BOTH));
        composite2.setLayout(gridLayout2);

        moniterText =
            new Text(
                composite2, SWT.MULTI | SWT.BORDER | SWT.V_SCROLL | SWT.WRAP);
        moniterText.setText("");

        gridData = new GridData(GridData.FILL_BOTH);

        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;

        moniterText.setLayoutData(gridData);

        startButton.setEnabled(true);
        stopButton.setEnabled(false);
        monitorResetButton.setEnabled(true);

        /**
         * j^Zbg{^Xi[
         */
        monitorResetButton.addSelectionListener(
            new SelectionListener() {
                /**
                 * j^[ZbgłB
                 *
                 * @param event SelectionEvent
                 */
                public void widgetSelected(SelectionEvent event) {
                    logger = Logger.getLogger(this.getClass().getName());

                    /* Snmp Agentj^[\Zbg */
                    moniterText.setText("");
                }

                /*
                 *  (non-Javadoc)
                 * @see org.eclipse.swt.events.
                 * SelectionListener#widgetDefaultSelected(org.eclipse.swt.
                 * events.SelectionEvent)
                 */
                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /**
         * j^Jn{^Xi[
         */
        startButton.addSelectionListener(
            new SelectionListener() {
                /**
                 * j^Jn܂B
                 *
                 * @param event SelectionEvent
                 */
                public void widgetSelected(SelectionEvent event) {
                    logger.info("Snmp Agent monitor start");
                    AgentMonitorMessageQueue.getInstance().setMonitor(true);
                    display.timerExec(AGENT_MONITOR_TIMER, timerProcessor);
                    startButton.setEnabled(false);
                    stopButton.setEnabled(true);
                    monitorResetButton.setEnabled(true);
                }

                /*
                 *  (non-Javadoc)
                 * @see org.eclipse.swt.events.
                 * SelectionListener#widgetDefaultSelected(org.eclipse.swt.
                 * events.SelectionEvent)
                 */
                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /**
         * Snmp Agentj^[ Stop{^ɂSnmp Agent
         * j^[~܂B
         *
         */
        stopButton.addSelectionListener(
            new SelectionListener() {
                /**
                 * Snmp Agentj^[~{^łB
                 *
                 * @param event SelectionEvent
                 */
                public void widgetSelected(SelectionEvent event) {
                    logger.info("Snmp Agent monitor stop");
                    AgentMonitorMessageQueue.getInstance().setMonitor(false);

                    /* Snmp Agentj^N^C}[~ */
                    display.timerExec(-1, timerProcessor);
                    startButton.setEnabled(true);
                    stopButton.setEnabled(false);
                    monitorResetButton.setEnabled(true);
                }

                /*
                 *  (non-Javadoc)
                 * @see org.eclipse.swt.events.
                 * SelectionListener#widgetDefaultSelected(org.eclipse.swt.
                 * events.SelectionEvent)
                 */
                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
    }

    /**
     * DisplayԂ܂B
     * j^̊Jn/~/ċNsj[ANVG[WFge[uView
     * ̊ej[ANVĂ΂܂B
     *
     * @return display Display
     */
    public Display getDisplay() {
        return display;
    }

    /**
     * j^\f[^L[ĎTimerProcessorԂ܂B
     * j^̊Jn/~/ċNsj[ANVG[WFge[uView
     * ̊ej[ANVĂ΂܂B
     *
     * @return timerProcessor TimerProcessorThread
     */
    public TimerProcessorThread getTimerProcessor() {
        return timerProcessor;
    }

    /**
     * Snmp AgentƂē쒆̃XbhPush郂j^[\f[^L[
     * IɊĎA\f[^L[ɑ݂ꍇɂ́Af[^o
     * j^[r[ɕ\NXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class TimerProcessorThread implements Runnable {
        /**
         * j^[\f[^L[IɊĎAL[Ƀf[^
         * ꍇɂ̓f[^Popăj^[\r[ɕ\
         * ܂B
         *
         */
        public void run() {
            /*
             * j^[\f[^L[Ď
             */
            String message =
                (String) AgentMonitorMessageQueue.getInstance().popAgentMessage();

            while (message != null) {
                // j^[\r[ɃbZ[W\
                moniterText.append(
                    message + System.getProperty("line.separator"));
                moniterText.append(System.getProperty("line.separator"));
                message =
                    (String) AgentMonitorMessageQueue.getInstance()
                                                  .popAgentMessage();
            }

            // ^C}[p
            display.timerExec(AGENT_MONITOR_TIMER, this);
        }
    }
}
