/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;


/**
 * SnmpG[WFgp[XyNeBu\NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AgentPerspective implements IPerspectiveFactory {
	public static final String ID = "netjfwatcher.snmpagent.AgentPerspective";
    private static final float TABLE_VIEW_RATIO = 0.45f;
    private static final float OPERATION_VIEW_RATIO = 0.50f;

    /**
     * p[XyNeBȕCAEgݒs܂B
     *
     * @param layout IPageLayout
     */
    public void createInitialLayout(IPageLayout layout) {
        layout.setEditorAreaVisible(false);

        String editorArea = layout.getEditorArea();

        /* SnmpG[WFgCX^Xf[^e[u\ */
        IFolderLayout top =
            layout.createFolder(
                "bottom", IPageLayout.BOTTOM, TABLE_VIEW_RATIO, editorArea);
        top.addView(AgentOperationView.class.getName());
        top.addView(AgentTrapSendView.class.getName());
        top.addView(AgentInstanceControlOperationView.class.getName());
        top.addView(AgentCommunicationMonitorView.class.getName());
        top.addView(AgentDataEditorView.class.getName());

        /* SnmpG[WFgr[ */
        IFolderLayout bottom =
            layout.createFolder(
                "top", IPageLayout.TOP, OPERATION_VIEW_RATIO, editorArea);
        bottom.addView(AgentTableView.class.getName());
    }
}
