package netjfwatcher.snmpagent.netjfwatcher;

import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.snmpagent.model.AgentDataImport;

import org.eclipse.core.runtime.internal.adaptor.PluginParser.PluginInfo;
import org.eclipse.swt.widgets.Table;

public class SnmpNetJFWatcher extends DataStringDisplay {

	private int ifNumber;

	private ArrayList<NicInfo> nicInfoList = new ArrayList<NicInfo>();

	/*
	 * System MIB̎OID̔z
	 */
	private static final String[] SYSTEM_MIB_OID = {
		    "1.3.6.1.2.1.1.1", // sysDescr
			"1.3.6.1.2.1.1.2", // sysObjectID
			"1.3.6.1.2.1.1.3", // sysUpTime
			"1.3.6.1.2.1.1.4", // sysContact
			"1.3.6.1.2.1.1.5", // sysName
			"1.3.6.1.2.1.1.6" // sysLocation
	};

	private static final String[] SYSTEM_MIB_OID_VALUE = {
		    "netjfwatcher", // sysDescr
			"1.2.4.1", // sysObjectID
			"0", // sysUpTime
			"admin@localhost", // sysContact
			"netjfwacher", // sysName
			"sysLocation" // sysLocation
	};

	private static final String IF_NUMBER_OID = "1.3.6.1.2.1.2.1"; // ifNumber

	/*
	 * C^tF[XMIB̎OID̔z
	 */
	private static final String[] INTERFACE_OID_ARRAY = {
			"1.3.6.1.2.1.2.2.1.1", // ifIndex
			"1.3.6.1.2.1.2.2.1.2", // ifDescr
			"1.3.6.1.2.1.2.2.1.3", // ifType
			"1.3.6.1.2.1.2.2.1.4", // ifMtu
			"1.3.6.1.2.1.2.2.1.5", // ifSpeed
			"1.3.6.1.2.1.2.2.1.6", // ifPhysAddress
			"1.3.6.1.2.1.2.2.1.7", // ifAdminStatus
			"1.3.6.1.2.1.2.2.1.8" // ifOperStatus
	};

	private SnmpNetJFWatcher() {

	}

	public void setNetJFWatcher(Table mibInstnaceTable) throws Exception {
	
		String[] systemMibValue = new String[SYSTEM_MIB_OID.length];

		systemMibValue[0] = SYSTEM_MIB_OID_VALUE[0];
		systemMibValue[1] = SYSTEM_MIB_OID_VALUE[1];
		systemMibValue[2] = SYSTEM_MIB_OID_VALUE[2];
		systemMibValue[3] = SYSTEM_MIB_OID_VALUE[3];
		systemMibValue[4] = SYSTEM_MIB_OID_VALUE[4];
		systemMibValue[5] = SYSTEM_MIB_OID_VALUE[5];


		int counter = 0;
		AgentDataImport agentDataImport = new AgentDataImport();
		agentDataImport.setNetJFWatcher0();
		try {
			for (int i = 0; i < SYSTEM_MIB_OID.length; i++) {
				counter++;
				agentDataImport.setNetJFWatcher1(counter, mibInstnaceTable,
						SYSTEM_MIB_OID[i], "0", systemMibValue[i]);

			}

			getNicInfo();
			counter++;
			agentDataImport.setNetJFWatcher1(counter, mibInstnaceTable,
					IF_NUMBER_OID, "0", Integer.toString(ifNumber));

			for (int j = 0; j < nicInfoList.size(); j++) {
				counter++;
				agentDataImport.setNetJFWatcher1(counter, mibInstnaceTable,
						INTERFACE_OID_ARRAY[0], Integer.toString(j + 1), Integer
								.toString(j + 1));
			}
			for (int j = 0; j < nicInfoList.size(); j++) {
				NicInfo nicInfo = nicInfoList.get(j);
				counter++;
				agentDataImport.setNetJFWatcher1(counter, mibInstnaceTable,
						INTERFACE_OID_ARRAY[1], Integer.toString(j + 1), nicInfo.getName() + "(" + nicInfo.getDisplayName() + ")");
			}
			for (int j = 0; j < nicInfoList.size(); j++) {
				counter++;
				agentDataImport.setNetJFWatcher1(counter, mibInstnaceTable,
						INTERFACE_OID_ARRAY[2], Integer.toString(j + 1), "1");
			}
			for (int j = 0; j < nicInfoList.size(); j++) {
				NicInfo nicInfo = nicInfoList.get(j);
				counter++;
				agentDataImport.setNetJFWatcher1(counter, mibInstnaceTable,
						INTERFACE_OID_ARRAY[3], Integer.toString(j + 1), Integer.toString(nicInfo.getMtu()));
			}
			for (int j = 0; j < nicInfoList.size(); j++) {
				counter++;
				agentDataImport.setNetJFWatcher1(counter, mibInstnaceTable,
						INTERFACE_OID_ARRAY[4], Integer.toString(j + 1), "0");
			}
			for (int j = 0; j < nicInfoList.size(); j++) {
				NicInfo nicInfo = nicInfoList.get(j);
				counter++;
				agentDataImport.setNetJFWatcher1(counter, mibInstnaceTable,
						INTERFACE_OID_ARRAY[5], Integer.toString(j + 1), nicInfo.getMacAddress());
			}
			for (int j = 0; j < nicInfoList.size(); j++) {
				NicInfo nicInfo = nicInfoList.get(j);
				counter++;
				String ifStatus = "1";
				if(nicInfo.isUP()) {
					ifStatus = "1";
				} else {
					ifStatus = "2";
				}
				agentDataImport.setNetJFWatcher1(counter, mibInstnaceTable,
						INTERFACE_OID_ARRAY[6], Integer.toString(j + 1), ifStatus);
			}
			for (int j = 0; j < nicInfoList.size(); j++) {
				NicInfo nicInfo = nicInfoList.get(j);
				counter++;
				String ifStatus = "1";
				if(nicInfo.isUP()) {
					ifStatus = "1";
				} else {
					ifStatus = "2";
				}
				agentDataImport.setNetJFWatcher1(counter, mibInstnaceTable,
						INTERFACE_OID_ARRAY[7], Integer.toString(j + 1), ifStatus);
			}
			for (int j = 0; j < nicInfoList.size(); j++) {
				counter++;
				agentDataImport.setNetJFWatcher1(counter, mibInstnaceTable,
						"1.3.6.1.2.1.2.2.1.9", Integer.toString(j + 1), "0");
			}
		} catch (Exception e) {
			throw e;
		}
		agentDataImport.setNetJFWatcher2();
	}

	private void getNicInfo() throws SocketException {
		nicInfoList.clear();
		Enumeration<NetworkInterface> enuNics = NetworkInterface
				.getNetworkInterfaces();

		for (NetworkInterface nic : Collections.list(enuNics)) {
			NicInfo nicInfo = new NicInfo();
			nicInfo.setDisplayName(nic.getDisplayName());
			nicInfo.setName(nic.getName());
			nicInfo.setMtu(nic.getMTU());
			nicInfo.setUP(nic.isUp());

			System.out.println("DisplayName: " + nic.getDisplayName());
			System.out.println("Name: " + nic.getName());
			System.out.println("MTU: " + nic.getMTU());
			System.out.println("isUP: " + nic.isUp());
			if (nic.getHardwareAddress() != null) {
				nicInfo
						.setMacAddress(getMacAddrString(nic
								.getHardwareAddress()));
				System.out.println("Mac Address: "
						+ getMacAddrString(nic.getHardwareAddress()));
				
				ifNumber++;
				nicInfoList.add(nicInfo);
			}

			List<InterfaceAddress> lstAddrs = nic.getInterfaceAddresses();
			for (InterfaceAddress addr : lstAddrs) {

				System.out.println("IP Address: " + addr.getAddress());
				System.out.println("Broadcast Address: " + addr.getBroadcast());
				System.out.println("Subnet mask length: "
						+ addr.getNetworkPrefixLength());

			}

		}

	}


	private String getMacAddrString(byte[] dataArray) {
		String returnString;

		if ((dataArray.length > 0) && !(dataArray.length <= 1)
				&& (dataArray[0] <= 0x7F) && (dataArray[0] >= 0x20)) {
			returnString = new String(dataArray);
		} else {
			if (dataArray.length > 2) {
				returnString = "0x";
			} else {
				returnString = "";
			}

			for (int i = 0; i < dataArray.length; i++) {
				// non-printable code convert
				returnString += hexByte(dataArray[i]);
			}
		}

		return returnString;
	}


	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static SnmpNetJFWatcher getInstance() {
		return SingletonResource.NETJ_INSTANCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final SnmpNetJFWatcher NETJ_INSTANCE = new SnmpNetJFWatcher();
	}
}
