/*
 * Created on 2004/12/10
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent.process;

import java.util.logging.Logger;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpVariablePair;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter32;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;



/**
 * Snmp V3G[WFgƂāA}l[Wɉ郌|[gOID
 * ܂PDU𐶐郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AgentV3Report {
    /* MO */
    private static Logger logger;

    /**
     * |[gOID܂PDU𐶐邽߂̃NXCX^X
     * 𐶐܂B
     *
     */
    public AgentV3Report() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * UnsupportedSecLevels|[gPDU𐶐܂B
     *
     * @param retoriveID NGXgʎq
     * @return reportPduData |[gPDU
     * @throws SnmpBadValueException PDUɎsꍇ
     */
    public SnmpPDU sendUnsupportedSecurityLevelReport(final int retoriveID)
        throws SnmpBadValueException {
        SnmpPDU reportPduData = null;
        logger.warning(
            SnmpPreference.UNSUPPORTED_SECURITY_LEVEL_DESCRIPTION + " : "
            + SnmpPreference.UNSUPPORTED_SECURITY_LEVEL);

        try {
            /* UnsupportedSecLevelsvJEgAbv */
            UsmStatistics.getInstance().addUsmStatsUnsupportedSecLevels();

            /* UnsupportedSecLevels varList */
            SnmpCounter32 statistics =
                new SnmpCounter32(
                    UsmStatistics.getInstance().getUsmStatsUnsupportedSecLevels());
            SnmpObjectIdentifier requestedObjectIdentifier =
                new SnmpObjectIdentifier(
                    SnmpPreference.UNSUPPORTED_SECURITY_LEVEL);
            SnmpVariablePair nextPair =
                new SnmpVariablePair(requestedObjectIdentifier, statistics);

            SnmpSequence varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);

            /*
             * |[gPDU
             */
            reportPduData =
                new SnmpPDU(
                    SnmpBERCodec.SNMP_MSG_REPORT, retoriveID,
                    SnmpPreference.ERROR_STATUS_CORRECT,
                    SnmpPreference.ERROR_INDEX_CORRECT, varList);
        } catch (SnmpBadValueException e) {
            logger.warning(
                "Abort create PDU of UnsupportedSecLevels " + e.getMessage());
            e.printStackTrace();
            throw e;
        }

        return reportPduData;
    }

    /**
     * UnknownUserNames|[gPDU𐶐܂B
     *
     * @param retoriveID NGXgʎq
     * @return reportPduData |[gPDU
     * @throws SnmpBadValueException PDUɎsꍇ
     */
    public SnmpPDU sendUnknownUserNamesReport(final int retoriveID)
        throws SnmpBadValueException {
        SnmpPDU reportPduData = null;
        logger.warning(
            SnmpPreference.UNKNOWN_ENGINE_ID_DESCRIPTION + " : "
            + SnmpPreference.UNKNOWN_ENGINE_ID);

        try {
            /* UnknownUserNamesvJEgAbv */
            UsmStatistics.getInstance().addUsmStatsUnknownUserNames();

            SnmpCounter32 statistics =
                new SnmpCounter32(
                    UsmStatistics.getInstance().getUsmStatsUnknownUserNames());
            SnmpObjectIdentifier requestedObjectIdentifier =
                new SnmpObjectIdentifier(SnmpPreference.UNKNOWN_USER_NAME);
            SnmpVariablePair nextPair =
                new SnmpVariablePair(requestedObjectIdentifier, statistics);

            SnmpSequence varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);

            reportPduData =
                new SnmpPDU(
                    SnmpBERCodec.SNMP_MSG_REPORT, retoriveID,
                    SnmpPreference.ERROR_STATUS_CORRECT,
                    SnmpPreference.ERROR_INDEX_CORRECT, varList);
        } catch (SnmpBadValueException e) {
            logger.warning(
                "Abort create PDU of UnknownUserNames " + e.getMessage());
            e.printStackTrace();
            throw e;
        }

        return reportPduData;
    }

    /**
     * UnknownEngineIDs|[gPDU𐶐܂B
     *
     * @param retoriveID NGXgʎq
     * @return reportPduData |[gPDU
     * @throws SnmpBadValueException PDUɎsꍇ
     */
    public SnmpPDU sendUnknownEngineIDReport(final int retoriveID)
        throws SnmpBadValueException {
        SnmpPDU reportPduData = null;
        logger.warning(
            SnmpPreference.UNKNOWN_ENGINE_ID_DESCRIPTION + " : "
            + SnmpPreference.UNKNOWN_ENGINE_ID);

        try {
            /* UnknownEngineIDsvJEgAbv */
            UsmStatistics.getInstance().addUsmStatsUnknownEngineIDs();

            SnmpCounter32 statistics =
                new SnmpCounter32(
                    UsmStatistics.getInstance().getUsmStatsUnknownEngineIDs());
            SnmpObjectIdentifier requestedObjectIdentifier =
                new SnmpObjectIdentifier(SnmpPreference.UNKNOWN_ENGINE_ID);
            SnmpVariablePair nextPair =
                new SnmpVariablePair(requestedObjectIdentifier, statistics);

            SnmpSequence varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);

            reportPduData =
                new SnmpPDU(
                    SnmpBERCodec.SNMP_MSG_REPORT, retoriveID, 0, 0, varList);
        } catch (SnmpBadValueException e) {
            logger.warning(
                "Abort create PDU of UnknownEngineIDs " + e.getMessage());
            e.printStackTrace();
            throw e;
        }

        return reportPduData;
    }

    /**
     * NotInTimeWindows|[gPDU𐶐܂B
     *
     * @param retoriveID NGXgʎq
     * @return reportPduData |[gPDU
     * @throws SnmpBadValueException PDUɎsꍇ
     */
    public SnmpPDU sendNotInTimeWindowsReport(final int retoriveID)
        throws SnmpBadValueException {
        SnmpPDU reportPduData = null;
        logger.warning(
            SnmpPreference.UNKNOWN_ENGINE_ID_DESCRIPTION + " : "
            + SnmpPreference.UNKNOWN_ENGINE_ID);

        try {
            /* NotInTimeWindowsvJEgAbv */
            UsmStatistics.getInstance().addUsmStatsNotInTimeWindows();

            SnmpCounter32 statistics =
                new SnmpCounter32(
                    UsmStatistics.getInstance().getUsmStatsNotInTimeWindows());
            SnmpObjectIdentifier requestedObjectIdentifier =
                new SnmpObjectIdentifier(SnmpPreference.NOT_IN_TIME_PACKET);
            SnmpVariablePair nextPair =
                new SnmpVariablePair(requestedObjectIdentifier, statistics);

            SnmpSequence varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);

            reportPduData =
                new SnmpPDU(
                    SnmpBERCodec.SNMP_MSG_REPORT, retoriveID, 0, 0, varList);
        } catch (SnmpBadValueException e) {
            logger.warning(
                "Abort create PDU of NotInTimeWindows " + e.getMessage());
            e.printStackTrace();
            throw e;
        }

        return reportPduData;
    }

    /**
     * WrongDigests|[gPDU𐶐܂B
     *
     * @param retoriveID NGXgʎq
     * @return reportPduData |[gPDU
     * @throws SnmpBadValueException PDUɎsꍇ
     */
    public SnmpPDU sendWrongDigestsReport(final int retoriveID)
        throws SnmpBadValueException {
        SnmpPDU reportPduData = null;
        logger.warning(
            SnmpPreference.WRONG_DIGEST_DESCRIPTION + " : "
            + SnmpPreference.WRONG_DIGEST);

        try {
            /* WrongDigestsvJEgAbv */
            UsmStatistics.getInstance().addUsmStatsWrongDigests();

            SnmpCounter32 statistics =
                new SnmpCounter32(
                    UsmStatistics.getInstance().getUsmStatsWrongDigests());
            SnmpObjectIdentifier requestedObjectIdentifier =
                new SnmpObjectIdentifier(SnmpPreference.WRONG_DIGEST);
            SnmpVariablePair nextPair =
                new SnmpVariablePair(requestedObjectIdentifier, statistics);

            SnmpSequence varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);

            reportPduData =
                new SnmpPDU(
                    SnmpBERCodec.SNMP_MSG_REPORT, retoriveID, 0, 0, varList);
        } catch (SnmpBadValueException e) {
            logger.warning(
                "Abort create PDU of WrongDigests " + e.getMessage());
            e.printStackTrace();
            throw e;
        }

        return reportPduData;
    }

    /**
     * DecryptionErrors|[gPDU𐶐܂B
     *
     * @param retoriveID NGXgʎq
     * @return reportPduData |[gPDU
     * @throws SnmpBadValueException PDUɎsꍇ
     */
    public SnmpPDU sendDecryptionErrorReport(final int retoriveID)
        throws SnmpBadValueException {
        SnmpPDU reportPduData = null;
        logger.warning(
            SnmpPreference.DECRYPTION_ERROR_DESCRIPTION + " : "
            + SnmpPreference.DECRYPTION_ERROR);

        try {
            /* DecryptionErrorsvJEgAbv */
            UsmStatistics.getInstance().addUsmStatsDecryptionErrors();

            SnmpCounter32 statistics =
                new SnmpCounter32(
                    UsmStatistics.getInstance().getUsmStatsDecryptionErrors());
            SnmpObjectIdentifier requestedObjectIdentifier =
                new SnmpObjectIdentifier(SnmpPreference.DECRYPTION_ERROR);
            SnmpVariablePair nextPair =
                new SnmpVariablePair(requestedObjectIdentifier, statistics);

            SnmpSequence varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);

            reportPduData =
                new SnmpPDU(
                    SnmpBERCodec.SNMP_MSG_REPORT, retoriveID, 0, 0, varList);
        } catch (SnmpBadValueException e) {
            logger.warning(
                "Abort create PDU of Decryption Errors " + e.getMessage());
            e.printStackTrace();
            throw e;
        }

        return reportPduData;
    }
}
