/*
 * Created on 2003/06/09
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager.model;

import java.io.File;
import java.security.AccessControlException;
import java.util.logging.Logger;

import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;


/**
 * t@CI_CAÔ߂̃\bhNXłB<BR>
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class FileChooser {
    /** CSVt@CI_CAOEBhẼ^Cg */
    public static final String CSVFILE_INPUT = "CSV File Input Select";

    /** oCSVt@CI_CAOEBhẼ^Cg */
    public static final String CSVFILE_OUTPUT = "CSV File Output Select";

    /** XMLt@CI_CAOEBhẼ^Cg */
    public static final String XMLFILE_INPUT = "XML File Input Select";

    /** oXMLt@CI_CAOEBhẼ^Cg */
    public static final String XMLFILE_OUTPUT = "XML File Output Select";

    /** ̓f[^x[Xt@CI_CAOEBhẼ^Cg */
    public static final String TITLE_DATABASA_SELECT = "Database File Select";

    /** VK쐬f[^x[Xt@CI_CAOEBhẼ^Cg */
    public static final String NEW_DATABASA_SELECT = "New Database File Select";

    /**
     * t@CI_CAOEBhEł̃t@CtB^py
     * t@CIpz
     */
    public static final String[][] FILE_CHOOSER =
        {
            { ".csv", "CSVt@C(*.csv)", "*.csv" },
            { ".xml", "XMLt@C(*.xml)", "*.xml" }
        };

    /**
     * t@CtB^pyуt@CIpz(FILE_CHOOSER)
     * łCSVt@Cʒu
     */
    public static final int CSV_FILE = 0;

    /**
     * t@CtB^pyуt@CIpz(FILE_CHOOSER)
     * łXMLt@Cʒu
     */
    public static final int XML_FILE = 1;

    /**
     * t@CtB^pyуt@CIp(FILE_CHOOSER)
     * ł̃t@Cgqʒu
     */
    public static final int FILE_FILTER_EXTENSION = 0;

    /**
     * t@CtB^pyуt@CIp(FILE_CHOOSER)
     * ł̃t@CtB^̈ʒu
     */
    public static final int FILE_FILTER_DESCRIPTION = 1;

    /**
     * t@CtB^pyуt@CIp(FILE_CHOOSER)
     * ł̃t@CÏʒu
     */
    public static final int SELECTED_FILE = 2;
    private static Logger logger;
    private String title;

    /**
     * f[^x[Xt@CI邽߂̃CX^X𐶐܂B<BR>
     *
     */
    public FileChooser() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * Iꂽt@CԂ܂B<BR>
     *
     * @param dialogTitle t@CI_CAOEBhẼ^Cg
     * @param fileExtension t@CI_CAOEBhEł
     * t@CtB^pyуt@CIpz
     * @return selectedFileName Iꂽt@C
     */
    public String getChooserFile(
        final String dialogTitle, final String[] fileExtension) {
        JFileChooser fileChooser = null;
        JLabel fileChooserDialogLabel;
        int fileChooserDialogReturn;
        String selectedFileName = null;

        if (dialogTitle == null) {
            title = TITLE_DATABASA_SELECT;
        } else {
            title = dialogTitle;
        }

        try {
            fileChooser = new JFileChooser(".");
        } catch (AccessControlException e) {
            return selectedFileName;
        }

        fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        fileChooser.setDialogTitle(title);

        if (fileExtension != null) {
            fileChooser.setSelectedFile(new FileSelect(fileExtension));
            fileChooser.setFileFilter(new FileFilterEx(fileExtension));
        }

        fileChooserDialogLabel = new JLabel();
        fileChooserDialogReturn =
            fileChooser.showOpenDialog(fileChooserDialogLabel);

        if (fileChooserDialogReturn != JFileChooser.APPROVE_OPTION) {
            /* _CAO{^[yes]A[ok]ȊȌꍇ */
            return selectedFileName;
        }

        selectedFileName = fileChooser.getSelectedFile().getAbsolutePath();

        return selectedFileName;
    }

    /**
     * _CAOEBhȆIt@Cݒ肷邽߂̃NX
     * łB<BR>
     *
     * @version 1.0
     * @author MatsumotoYoshimasa
     */
    private final class FileSelect extends File {
        /**
          * _CAOEBhȆIt@C̐ݒ𐶐
          * B<BR>
          *
          * @param fileFilter@t@CI_CAOEBhE
          * ł̃t@CtB^pyуt@CIpz
          */
        private FileSelect(final String[] fileFilter) {
            super(fileFilter[SELECTED_FILE]);
        }
    }

    /**
     * _CAOEBhẼfBNgyуt@C̃Xg
     * \p̃t@CtB^܂B<BR>
     *
     * @version 1.0
     * @author MatsumotoYoshimasa
     */
    private final class FileFilterEx extends FileFilter {
        private String extension;
        private String description;

        /**
          * _CAOEBhẼfBNgyуt@C̃Xg
          * \p̃t@CtB^\z܂B<BR>
          *
          * @param fileFilter t@CI_CAOEBhEł
          * t@CtB^pyуt@CIpz
          */
        private FileFilterEx(final String[] fileFilter) {
            extension = fileFilter[FILE_FILTER_EXTENSION];
            description = fileFilter[FILE_FILTER_DESCRIPTION];
        }

        /**
          * w肳ꂽt@C܂̓fBNgpX󂯕t邩
          * ǂԂ@accept() \bhI[o[Ch܂B<BR>
          *
          * @param f w肳ꂽt@C܂̓fBNg̃pX
          * `FbN
          */
        public boolean accept(final File f) {
            if (f.isDirectory()) {
                return true;
            }

            return f.getName().endsWith(extension);
        }

        /**
          * ̃tB^̐Ԃ܂B<BR>
          *
          * @return description ̃tB^̐
          */
        public String getDescription() {
            return description;
        }
    }
}
