/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager.preferences;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.engine.resource.XMLOutputterFormat;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;



/**
 * SNMPvtFXy[W̋ʃ\bh钊ۃNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
abstract public class AbstractSnmpPreferencePage extends PreferencePage
    implements IWorkbenchPreferencePage {
    /* MO */
    private static Logger logger;

    /** m[heLXg\BackGroundFi[ */
    protected Color textBackColor;

    /**
     * PreferencePagepNXŎׂ\bhłB
     *
     * @param parent Composite
     * @return Control
     */
    protected abstract Control createContents(Composite parent);

    /**
    *@wBufferedWriteryDocumentXML Fileɏo͂܂B
    *
    * @param bufWriter BufferedWriter
    * @param dom Document
    */
    public void outputXMLFile(final BufferedWriter bufWriter, final Document dom) {
        logger = Logger.getLogger(this.getClass().getName());

        /*
         * qGgeGg2wAGgԂ̉s
                * w͂ȂiXMLt@CŌXsĂ邽߁j
                */

        // XMLOutputter outputter = new XMLOutputter("  ", true);
        XMLOutputter outputter =
            XMLOutputterFormat.getInstance().getXMLOutputterFormat();

        // XMLOutputter outputter = new XMLOutputter();
        // outputter.setIndent("  ");
        FileWriter writer = null;

        try {
            outputter.output(dom, System.out);
            outputter.output(dom, bufWriter);
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }
}
