/*
 * Created on 2004/12/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.socketclient;

import java.util.logging.Logger;

import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.jvm.EditorGarbageCollection;
import netjfwatcher.webbrowser.menutree.AbstractMenuTreeListener;
import netjfwatcher.webbrowser.menutree.NetMenuTree;
import netjfwatcher.webbrowser.menutree.NetMenuTreeGroup;

import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;


/**
 * lbg[NoRj[TreeXi[NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NetworkClientMenuTreeListener extends AbstractMenuTreeListener {
    /* Activey[W */
    private static IWorkbenchPage activePage;

    /* MO */
    private static Logger logger = null;

    /**
     * e[uViewɃtB[hꗗőIGg͒lƂĐݒ
     * ̃Cxg_@ƂWebɃANZXB
     *
     * @param event SelectionChangedEvent
     */
    public void selectionChanged(SelectionChangedEvent event) {
        logger = Logger.getLogger(this.getClass().getName());

        /*
         * Iꂽ񒊏o
         * Iꂽm[hGroup̏ꍇɂ͉Return
         */
        StructuredSelection ss = (StructuredSelection) event.getSelection();

        if (ss.getFirstElement() instanceof NetMenuTreeGroup) {
            return;
        }

        /* j[TreeIEntryo */
        final NetMenuTree entry = (NetMenuTree) ss.getFirstElement();

        /* R}hR[ho */
        final int code = entry.getCommandCode();

        /* Activey[W擾 */
        activePage =
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

        /*
         * IꂽGg̃m[hURLEditorɃuEU
         * I[v
         * EditorID̓uEŨNX
         */
        BusyIndicator.showWhile(
            PlatformUI.getWorkbench().getDisplay(),
            new Runnable() {
                public void run() {
                    try {
                        String editorID =
                            EditorGarbageCollection.class.getName();

                        switch (code) {
                        case NetworkClientNodeMenuView.GARBAGECOLLECTION_TABLE:
                            editorID = EditorGarbageCollection.class.getName();
                            String title =
                                "GarbageCollection Table"
                                + NetworkClientNodeTreeView
                                .getTitleSuffixEngineAddress();
                            activePage.openEditor(
                                new EditorInputNodeView(title, true), editorID);

                            break;

                        case NetworkClientNodeMenuView.GARBAGECOLLECTION_CHART:
                            break;

                        default:
                            logger.warning("Illegal code " + code);
                        }
                    } catch (PartInitException e) {
                        logger.warning("Menu open error : " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
    }
}
