/*
 * Created on 2004/12/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.socketclient;

import netjfwatcher.engine.calendar.CalendarView;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;


/**
 * lbg[NĎp[XyNeBuNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NetworkClientPerspective implements IPerspectiveFactory {
	public static final String ID = "netjfwatcher.socketclient.NetworkClientPerspective";
    private static final float NODE_TREE_RATIO = 0.15f;
    private static final float NODE_LIST_RATIO = 0.60f;
    private static final float ENGINE_LIST_RATIO = 0.85f;

    /**
     * lbg[NĎp[XyNeBȕCAEgݒ
     * s܂B
     *
     * @param layout IPageLayout
     */
    public void createInitialLayout(IPageLayout layout) {

        layout.setEditorAreaVisible(false);

        String editorArea = layout.getEditorArea();

        /* lbg[NĎj[Am[hTreeZbg */
        IFolderLayout left =
            layout.createFolder(
                "left", IPageLayout.LEFT, NODE_TREE_RATIO, editorArea);
        left.addView(NetworkClientNodeTreeView.class.getName());
        left.addView(NetworkClientNodeMenuView.class.getName());
        left.addView(CalendarView.class.getName());

        /* Perspective EɃGWListzu  */
        IFolderLayout right =
            layout.createFolder(
                "right", IPageLayout.RIGHT, ENGINE_LIST_RATIO, editorArea);

        right.addView(EngineListView.class.getName());
        
        /* Perspective㑤Ƀm[hListƃm[hMap  */
        IFolderLayout top =
            layout.createFolder(
                "top", IPageLayout.TOP, NODE_LIST_RATIO, editorArea);

        top.addView(NetworkClientNodeMapView.class.getName());
        top.addView(NetworkClientNodeListTableView.class.getName());



    }
}
