/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.webbrowser.model;

import java.text.MessageFormat;
import java.util.logging.Logger;

import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;


/**
 * Document̓G[nhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class DocumentParseErrorHandler extends DefaultHandler {
    /* MO */
    private static Logger logger;

    /* G[̃bZ[WtH[}bg
     * {0} :System ID
     * {1} :Line No.
     * {2} :Column No.
     * {3} :Error Message
     */
    private MessageFormat message = new MessageFormat("({0}: {1}, {2}): {3}");

    /**
     * G[bZ[WMO܂B<BR>
     *
     * @param saxpe SAXParseException
     */
    private void printError(final SAXParseException saxpe) {
        String msg =
            message.format(
                new Object[] {
                    saxpe.getSystemId(), new Integer(saxpe.getLineNumber()),
                    new Integer(saxpe.getColumnNumber()), saxpe.getMessage()
                });
        logger = Logger.getLogger(this.getClass().getName());
        logger.warning(msg);
    }

    /**
     * vIG[̏s܂B<BR>
     *
     * @param saxpe SAXParseException
     * @throws SAXParseException SAXp[XŏQꍇ
     */
    public void fatalError(final SAXParseException saxpe)
        throws SAXParseException {
        printError(saxpe);
        throw saxpe;
    }
}
