/*
 * Created on 2007/03/12
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemap.gui;

import java.util.ArrayList;

import netjfwatcher.engine.nodemaneger.map.NodeMapInfo;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeOperation;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.node.EditorNodeOperation;
import netjfwatcher.nodemap.gui.icon.NodeIcon;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/**
 * m[hMap ViewCanvas̃}EXXi[NXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeMapDrawViewMouseListener extends MouseAdapter implements
		MouseMoveListener {
	/* Composite */
	private Composite parent;

	/* GC */
	private GC gc;

	/* m[hIcon񃊃Xg */
	private ArrayList<NodeMapInfo> nodeMapNodeInfoList;

	/* m[hN */
	private NodeMapLinkInformation nodMapLinkInformationList;

	/* LinkJnW */
	private int lineStartX;

	private int lineStartY;

	/* LinkJnm[h */
	private NodeInformation startNode;

	/* Link`tO(popUpj[ŃZbg) */
	private boolean isLineSelected = false;

	/* Link`JntO */
	private boolean isLineStart = false;

	/* m[hMapr[`NXCX^X */
	private NodeMapDrawViewDraw mapDraw;

	/* m[hMapr[PopUpj[NXCX^X */
	private NodeMapDrawViewPopUpMenu popMenu;

	/**
	 * }EXXi[NXCX^X𐶐܂B
	 * 
	 * @param display
	 *            Display
	 * @param parent
	 *            Composite
	 * @param canvas
	 *            Canvas
	 * @param gc
	 *            GC
	 * @param statusLineManager
	 *            Xe[^XC}l[W
	 * @param isSocket
	 *            RCPNCAgƂSocketɂăT[oƒʐMs̃tO
	 */
	public NodeMapDrawViewMouseListener(ScrolledComposite scrollComposite,
			Display display, final Composite parent, Canvas canvas, GC gc,
			SubStatusLineManager statusLineManager, boolean isSocket) {
		this.gc = gc;
		this.parent = parent;
		mapDraw = new NodeMapDrawViewDraw(scrollComposite, canvas, gc);

		if (isSocket) {
			popMenu = new NodeMapDrawViewPopUpMenuSocket(display, canvas,
					mapDraw, this, statusLineManager);
		} else {
			popMenu = new NodeMapDrawViewPopUpMenu(display, canvas, mapDraw,
					this, statusLineManager);
		}
		loadNodeMapInfo();
	}

	private void loadNodeMapInfo() {
		nodeMapNodeInfoList = popMenu.getNodeMapNodeInfoList();
		nodMapLinkInformationList = popMenu.getNodMapLinkInformationList();

	}

	/**
	 * }EXDownCxgXi[łB m[hIcon̈ړ܂́Am[hԃN`Jn܂B
	 * 
	 * @param event
	 *            MouseEvent
	 */
	public void mouseDown(MouseEvent event) {
		// m[h̕Ih~tO
		boolean isFoundSelectedNode = false;
		popMenu.setPopUpMenu(parent);

		for (int i = 0; i < nodeMapNodeInfoList.size(); i++) {
			NodeMapInfo nodeMapInfo = (NodeMapInfo) nodeMapNodeInfoList.get(i);

			if (!isFoundSelectedNode
					&& ((event.x > nodeMapInfo.getX()) && (event.x < (nodeMapInfo
							.getX() + nodeMapInfo.getWidth())))
					&& ((event.y > nodeMapInfo.getY()) && (event.y < (nodeMapInfo
							.getY() + nodeMapInfo.getHeight())))) {
				/*
				 * MouseDownʒum[h
				 */
				if (!isLineSelected) {
					/*
					 * Link`惂[hłȂAm[h ړ[h
					 */
					if (!nodeMapInfo.getNodeInfo().getIpaddress().equals("")) {
						popMenu.setNodeMenu(nodeMapInfo.getNodeInfo(), true);
					} else {
						popMenu.setNodeMenu(nodeMapInfo.getNodeInfo(), false);
					}
					/* m[hMapIconIԃZbg */
					nodeMapInfo.setSelected(true);
					isLineStart = false;
				} else {
					/* Link`惂[h */
					isLineStart = true;
					lineStartX = event.x;
					lineStartY = event.y;
					startNode = nodeMapInfo.getNodeInfo();
				}

				isFoundSelectedNode = true;
			} else {
				/*
				 * MouseDownʒułȂm[h̑I 
				 */
				nodeMapInfo.setSelected(false);
			}

			nodeMapNodeInfoList.set(i, nodeMapInfo);
		}

		nodMapLinkInformationList = popMenu.getNodMapLinkInformationList();

		/* ĕ` */
		mapDraw.redraw(nodeMapNodeInfoList, nodMapLinkInformationList);
	}

	/**
	 * }EXUpCxgXi[łB m[hIcon̈ړ܂́Am[hԃN̊ms܂B
	 * 
	 * @param event
	 *            MouseEvent
	 */
	public void mouseUp(MouseEvent event) {

		if (isLineSelected && isLineStart) {
			/*
			 * m[hԂLink` m[hmouseDownŊɊJn_Zbg ̂ŁAmouseUpʒuLinkI_Ƃ
			 * AAɃm[hԂLink݂ꍇɂ Link폜Ƃ
			 */
			isLineStart = false;
			/* `撆LinkNÂ߂ɕ` */
			mapDraw.redraw(nodeMapNodeInfoList, nodMapLinkInformationList);

			/*
			 * m[hMap`ɂm[hoāA Link`/폜܂́Am[hIconړ `FbNEs
			 */
			for (int i = 0; i < nodeMapNodeInfoList.size(); i++) {
				NodeMapInfo nodeMapInfo = (NodeMapInfo) nodeMapNodeInfoList
						.get(i);

				if (((event.x > nodeMapInfo.getX()) && (event.x < (nodeMapInfo
						.getX() + nodeMapInfo.getWidth())))
						&& ((event.y > nodeMapInfo.getY()) && (event.y < (nodeMapInfo
								.getY() + nodeMapInfo.getHeight())))) {
					/*
					 * mouseUpm[hʒȕꍇLinkL
					 */
					boolean isLineCut = false;

					if (nodMapLinkInformationList == null) {
						return;
					}
					ArrayList node0List = nodMapLinkInformationList
							.getNode0address();
					ArrayList node1List = nodMapLinkInformationList
							.getNode1address();
					/*
					 * Ƀm[hLink݂邩`FbNA݂ ꍇɂLink폜
					 */
					for (int linkNodeCount = 0; linkNodeCount < node0List
							.size(); linkNodeCount++) {
						if (startNode.getIpaddress().equals(
								node0List.get(linkNodeCount))) {
							if (nodeMapInfo.getNodeInfo().getIpaddress()
									.equals(node1List.get(linkNodeCount))) {
								/* Link폜 */
								node0List.remove(linkNodeCount);
								node1List.remove(linkNodeCount);
								isLineCut = true;

								break;
							}
						}
					}
					/*
					 * tŃm[hLink݂Ă `FbN
					 */
					for (int linkNodeCount = 0; linkNodeCount < node1List
							.size(); linkNodeCount++) {
						if (startNode.getIpaddress().equals(
								node1List.get(linkNodeCount))) {
							if (nodeMapInfo.getNodeInfo().getIpaddress()
									.equals(node0List.get(linkNodeCount))) {
								/* Link폜 */
								node1List.remove(linkNodeCount);
								node0List.remove(linkNodeCount);
								isLineCut = true;

								break;
							}
						}
					}

					/*
					 * m[hLink݂ĂȂꍇɂLinkǉ
					 */
					if (!isLineCut) {
						node0List.add(startNode.getIpaddress());
						node1List.add(nodeMapInfo.getNodeInfo().getIpaddress());
					}
					// m[hLinkXV
					nodMapLinkInformationList.setNode0address(node0List);
					nodMapLinkInformationList.setNode1address(node1List);
					// redraw
					mapDraw.redraw(nodeMapNodeInfoList,
							nodMapLinkInformationList);
					break;
				}
			}
		} else {
			/*
			 * m[hLink`łȂm[hړ
			 */
			isLineStart = false;

			for (int i = 0; i < nodeMapNodeInfoList.size(); i++) {
				NodeMapInfo nodeMapInfo = (NodeMapInfo) nodeMapNodeInfoList
						.get(i);

				if (nodeMapInfo.isSelected()) {
					/*
					 * IĂm[hړʒum WZbg
					 */
					int x = nodeMapInfo.getX();
					int y = nodeMapInfo.getY();

					if (x < 0) {
						x = event.x;
					}

					if (y < 0) {
						y = event.y;
					}

					nodeMapInfo.setX(x);
					nodeMapInfo.setY(y);

					NodeInformation nodeInfo = nodeMapInfo.getNodeInfo();
					String nodeX = Integer.toString(x);
					String nodeY = Integer.toString(y);
					nodeInfo.setNodeX(nodeX);
					nodeInfo.setNodeY(nodeY);
					nodeMapInfo.setNodeInfo(nodeInfo);
					nodeMapNodeInfoList.set(i, nodeMapInfo);

					/* ĕ` */
					mapDraw.redraw(nodeMapNodeInfoList,
							nodMapLinkInformationList);

					/* Im[h */
					nodeMapInfo.setSelected(false);
					nodeMapNodeInfoList.set(i, nodeMapInfo);
				}
			}
		}

		if (NodeIcon.getInstance().isValid()) {
			NodeMapInfo addNodeMapInfo = NodeIcon.getInstance()
					.getNodeMapinfo();
			String nodeX = Integer.toString(event.x);
			String nodeY = Integer.toString(event.y);
			addNodeMapInfo.setX(event.x);
			addNodeMapInfo.setY(event.y);

			NodeInformation nodeInfo = addNodeMapInfo.getNodeInfo();
			nodeInfo.setNodeX(nodeX);
			nodeInfo.setNodeY(nodeY);
			addNodeMapInfo.setNodeInfo(nodeInfo);

			// nodeMapNodeInfoList.add(addNodeMapInfo);
			openNodeConfigEditor(nodeInfo);
			NodeIcon.getInstance().setValid(false);
			NodeIcon.getInstance().setSetViewList(false);

		}

	}

	/**
	 * }EXړXi[łB [hɂm[hIcon̈ړyуm[hԃN̕`s܂B
	 * 
	 * @param event
	 *            MouseEvent
	 */
	public void mouseMove(MouseEvent event) {

		/*
		 * m[hړ܂Link`
		 */
		if (isLineSelected && isLineStart) {
			/*
			 * m[hLink`
			 */
			mapDraw.redraw(nodeMapNodeInfoList, nodMapLinkInformationList);
			gc.drawLine(lineStartX, lineStartY, event.x, event.y);
		} else {
			/*
			 * m[hIɂm[hړ
			 */
			isLineStart = false;

			for (int i = 0; i < nodeMapNodeInfoList.size(); i++) {
				/*
				 * Im[hmouseJ[\ʒuɍW Zbg
				 */
				NodeMapInfo nodeMapInfo = (NodeMapInfo) nodeMapNodeInfoList
						.get(i);

				if (nodeMapInfo.isSelected()) {
					String nodeX = Integer.toString(event.x);
					String nodeY = Integer.toString(event.y);
					nodeMapInfo.setX(event.x);
					nodeMapInfo.setY(event.y);

					NodeInformation nodeInfo = nodeMapInfo.getNodeInfo();
					nodeInfo.setNodeX(nodeX);
					nodeInfo.setNodeY(nodeY);
					nodeMapInfo.setNodeInfo(nodeInfo);
					nodeMapNodeInfoList.set(i, nodeMapInfo);

					/* ĕ` */
					mapDraw.redraw(nodeMapNodeInfoList,
							nodMapLinkInformationList);
				}
			}
		}

		if (NodeIcon.getInstance().isValid()) {
			NodeMapInfo addNodeMapInfo = NodeIcon.getInstance()
					.getNodeMapinfo();
			String nodeX = Integer.toString(event.x);
			String nodeY = Integer.toString(event.y);
			addNodeMapInfo.setX(event.x);
			addNodeMapInfo.setY(event.y);

			// mapDraw.drawNode(addNodeMapInfo);
			if (!NodeIcon.getInstance().isSetViewList()) {
				boolean isSet = false;
				for (int j = 0; j < nodeMapNodeInfoList.size(); j++) {
					NodeMapInfo checkNodeMapInfo = (NodeMapInfo) nodeMapNodeInfoList
							.get(j);
					if (checkNodeMapInfo.getNodeInfo().getIpaddress()
							.equals("")) {
						nodeMapNodeInfoList.set(j, addNodeMapInfo);
						NodeIcon.getInstance().setSetViewList(true);
						isSet = true;
					}
				}
				if(!isSet) {
					nodeMapNodeInfoList.add(addNodeMapInfo);
					NodeIcon.getInstance().setSetViewList(true);
				}
			}
			mapDraw.redraw(nodeMapNodeInfoList, nodMapLinkInformationList);
		}
	}

	/**
	 * m[hMapr[ĕ`悵܂B
	 * 
	 */
	public void redraw() {

		/* ĕ` */
		mapDraw.redraw(nodeMapNodeInfoList, nodMapLinkInformationList);
	}

	private void openNodeConfigEditor(NodeInformation nodeInfo) {


		IWorkbenchPage activePage = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage();

		if (nodeInfo == null) {
			nodeInfo = new NodeInformation();
			nodeInfo.setIpaddress(null);
		}

		try {
			/*
			 * EditorɃuEUI[v
			 */
			if (NodeMapMenuNodeOperation.editorNodeConfigOperationView != null) {
				activePage.closeEditor(NodeMapMenuNodeOperation.editorNodeConfigOperationView, false);
				NodeMapMenuNodeOperation.editorNodeConfigOperationView = null;
			}

			NodeMapMenuNodeOperation.editorNodeConfigOperationView = activePage.openEditor(
					new EditorInputNodeView(EditorNodeOperation.TITLE_SUFFIX,
							nodeInfo, false), EditorNodeOperation.class
							.getName());
		} catch (PartInitException e) {

			e.printStackTrace();
		}
	}

	/**
	 * m[hMap View PopUpj[NXCX^XԂ܂B
	 * 
	 * @return popMenu m[hMap View PopUpj[NXCX^X
	 */
	public NodeMapDrawViewPopUpMenu getPopMenu() {
		return popMenu;
	}

	/**
	 * m[hԃNCIԂԂ܂B
	 * 
	 * @return isLineSelected m[hԃNCI
	 */
	public boolean isLineSelected() {
		return isLineSelected;
	}

	/**
	 * m[hԃNCJntOZbg܂B
	 * 
	 * @param isLineSelected
	 *            m[hԃNCJntO
	 */
	public void setLineSelected(boolean isLineSelected) {
		this.isLineSelected = isLineSelected;
	}

	/**
	 * m[hԃNCJntOԂ܂B
	 * 
	 * @return isLineStart m[hԃNCJntO
	 */
	public boolean isLineStart() {
		return isLineStart;
	}

	/**
	 * m[hԃNCJntOZbg܂B
	 * 
	 * @param isLineStart
	 *            m[hԃNCJntO
	 */
	public void setLineStart(boolean isLineStart) {
		this.isLineStart = isLineStart;
	}
}
