/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.common.view;

import netjfwatcher.common.view.CalendarTable;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class CalendarComposite {
    private Text yearText;
    private Text endYearText;
    private Text monthText;
    private Text endMonthText;
    private Text dateText;
    private Text endDateText;
    private Combo dayOfMonthCombo;
    private Combo dayOfWeekCombo;
    private Text displayText;
    private CalendarTable calendarTable;
    private Table table;

    public Composite createCalendarView(Composite baseComposite) {
        GridLayout gridLayout = new GridLayout(4, false);
        Composite composite = new Composite(baseComposite, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        Composite ctlComp = new Composite(baseComposite, 524288);
        ctlComp.setLayout((Layout)new GridLayout(2, true));
        GridData compData = new GridData();
        compData.horizontalAlignment = 4;
        ctlComp.setLayoutData((Object)compData);
        this.displayText = new Text(ctlComp, 2052);
        GridData textData = new GridData(768);
        this.displayText.setLayoutData((Object)textData);
        Composite buttonComp = new Composite(ctlComp, 524288);
        buttonComp.setLayout((Layout)new GridLayout(3, true));
        GridData buttonData = new GridData(4);
        buttonData.horizontalAlignment = 3;
        buttonComp.setLayoutData((Object)buttonData);
        Button buttonPrev = new Button(buttonComp, 8);
        buttonPrev.setText("<<");
        buttonPrev.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CalendarComposite.this.displayText.setText(CalendarComposite.this.calendarTable.setPrevMonth());
            }
        });
        Button buttonThisMonth = new Button(buttonComp, 8);
        buttonThisMonth.setText("\u25a1");
        buttonThisMonth.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CalendarComposite.this.displayText.setText(CalendarComposite.this.calendarTable.setThisMonth());
            }
        });
        Button buttonNext = new Button(buttonComp, 8);
        buttonNext.setText(">>");
        buttonNext.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CalendarComposite.this.displayText.setText(CalendarComposite.this.calendarTable.setNextMonth());
            }
        });
        this.calendarTable = new CalendarTable(baseComposite, 66304);
        this.displayText.setText(this.calendarTable.setThisMonth());
        Label label = new Label(baseComposite, 0);
        label.setText(" Today : " + this.calendarTable.getTodaysYYMMDD());
        this.table = this.calendarTable.getTable();
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                int index = CalendarComposite.this.table.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                CalendarComposite.this.table.setSelection(new int[0]);
                TableItem item = CalendarComposite.this.table.getItem(index);
                Point point = new Point(event.x, event.y);
                int i = 0;
                while (i < CalendarComposite.this.table.getColumnCount()) {
                    if (item.getBounds(i).contains(point) && item.getText(i) != null && !item.getText(i).equals("")) {
                        if (CalendarComposite.this.yearText != null) {
                            CalendarComposite.this.yearText.setText(CalendarComposite.this.calendarTable.getSelectYear());
                        }
                        if (CalendarComposite.this.endYearText != null) {
                            CalendarComposite.this.endYearText.setText(CalendarComposite.this.calendarTable.getSelectYear());
                        }
                        if (CalendarComposite.this.monthText != null) {
                            CalendarComposite.this.monthText.setText(CalendarComposite.this.calendarTable.getSelectMonth());
                        }
                        if (CalendarComposite.this.endMonthText != null) {
                            CalendarComposite.this.endMonthText.setText(CalendarComposite.this.calendarTable.getSelectMonth());
                        }
                        if (CalendarComposite.this.dateText != null) {
                            CalendarComposite.this.dateText.setText(item.getText(i));
                        }
                        if (CalendarComposite.this.endDateText != null) {
                            CalendarComposite.this.endDateText.setText(item.getText(i));
                        }
                        if (CalendarComposite.this.dayOfMonthCombo != null) {
                            CalendarComposite.this.dayOfMonthCombo.select(Integer.parseInt(item.getText(i)) - 1);
                        }
                        if (CalendarComposite.this.dayOfWeekCombo != null) {
                            CalendarComposite.this.dayOfWeekCombo.select(i);
                        }
                    }
                    ++i;
                }
            }
        });
        return baseComposite;
    }

    public void setDateText(Text dateText) {
        this.dateText = dateText;
    }

    public void setMonthText(Text monthText) {
        this.monthText = monthText;
    }

    public void setYearText(Text yearText) {
        this.yearText = yearText;
    }

    public void setEndDateText(Text date2Text) {
        this.endDateText = date2Text;
    }

    public void setEndMonthText(Text month2Text) {
        this.endMonthText = month2Text;
    }

    public void setEndYearText(Text year2Text) {
        this.endYearText = year2Text;
    }

    public CalendarTable getCalendarTable() {
        return this.calendarTable;
    }

    public void setDayOfMonthCombo(Combo dayOfMonthCombo) {
        this.dayOfMonthCombo = dayOfMonthCombo;
    }

    public void setDayOfWeekCombo(Combo dayOfWeekCombo) {
        this.dayOfWeekCombo = dayOfWeekCombo;
    }
}

