/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableBase;
import netjfwatcher.database.access.model.DBTableManagement;
import netjfwatcher.database.access.model.StatisticsInfo;
import netjfwatcher.engine.snmpmanager.process.MibValue;
import netjfwatcher.engine.socket.info.InterfaceData;
import netjfwatcher.engine.socket.info.StatisticsMibIfDescriptor;
import netjfwatcher.engine.socket.info.StatisticsMibInfo;
import netjfwatcher.engine.socket.info.StatisticsMibProperty;
import netjfwatcher.engine.socket.info.StatisticsMibSetStatus;

public final class DBTableStatisticsMIBControl
extends DBTableBase {
    public static final String SNMP_STATIS_CONFIG_TABLE_NAME = "_statis";
    public static final String SNMP_STATIS_MIB_DATA_TABLE = "_statisData";
    public static final String SNMP_STATIS_MIB_INSTANCE_TABLE = "_instance";
    public static final String STATIS_OID = "statis_oid";
    public static final String INSTANCE_TOTAL = "instance_total";
    public static final String PERIOD = "period";
    public static final String THRESHOLD = "threshold";
    public static final String THRESHOLD_TYPE = "thresholdtype";
    public static final String INSTANCE_NAME = "instance_name";
    public static final String CURDATE = "curdate";
    private static Logger logger = null;
    private final DateFormat simpleDateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private DBTableStatisticsMIBControl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public static DBTableStatisticsMIBControl getInstance() {
        return SingletonResource.RESOURCE;
    }

    public synchronized void createStatisticsMibConfigTable(String targetIpAddress) throws DatabaseConnectionException, SQLException {
        String ipaddress = "IP" + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            AbstractDataAccessObject dataaccess = DatabaseAccessControlKind.getInstance().getDataAccessObject();
            this.deleteTable(databaseAccess, String.valueOf(ipaddress) + SNMP_STATIS_CONFIG_TABLE_NAME);
            databaseAccess.executeUpdate("CREATE TABLE " + ipaddress + SNMP_STATIS_CONFIG_TABLE_NAME + dataaccess.getItemSnmpStatisticsTableSQL());
            DBTableManagement tableManagement = new DBTableManagement();
            tableManagement.put(targetIpAddress, String.valueOf(ipaddress) + SNMP_STATIS_CONFIG_TABLE_NAME, "no");
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void createStatisticsMibDataTable(String targetIpAddress) throws DatabaseConnectionException, SQLException {
        String ipaddress = "IP" + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            this.deleteTable(databaseAccess, String.valueOf(ipaddress) + SNMP_STATIS_MIB_DATA_TABLE);
        }
        catch (SQLException e) {
            logger.info(String.valueOf(DatabaseAccessControlKind.getInstance().getDatabaseName()) + " : " + e.getMessage());
        }
        try {
            AbstractDataAccessObject dataaccess = DatabaseAccessControlKind.getInstance().getDataAccessObject();
            String statisItem = null;
            if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Postgresql")) {
                this.dropSequence(databaseAccess, "DROP SEQUENCE " + ipaddress + "_sta_id_seq");
                databaseAccess.executeUpdate("CREATE SEQUENCE " + ipaddress + "_sta_id_seq");
                statisItem = " (id INTEGER DEFAULT NEXTVAL('" + ipaddress + "_sta_id_seq'" + "), " + STATIS_OID + "  VARCHAR(255)," + CURDATE + " " + "TIMESTAMP" + ")";
            } else {
                String autoIncrement = dataaccess.getAutoIncrement();
                statisItem = " (" + autoIncrement + ", " + STATIS_OID + "  VARCHAR(255)," + CURDATE + " " + "TIMESTAMP" + ")";
            }
            databaseAccess.executeUpdate("CREATE TABLE " + ipaddress + SNMP_STATIS_MIB_DATA_TABLE + statisItem);
            DBTableManagement tableManagement = new DBTableManagement();
            tableManagement.put(targetIpAddress, String.valueOf(ipaddress) + SNMP_STATIS_MIB_DATA_TABLE, "yes");
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void createMibInstanceTable(String targetIpAddress) throws DatabaseConnectionException, SQLException {
        String ipaddress = "IP" + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            this.deleteTable(databaseAccess, String.valueOf(ipaddress) + SNMP_STATIS_MIB_INSTANCE_TABLE);
        }
        catch (SQLException e) {
            logger.info(String.valueOf(DatabaseAccessControlKind.getInstance().getDatabaseName()) + " : " + e.getMessage());
        }
        try {
            String statisItem = " (statis_oid  VARCHAR(255), instance_name VARCHAR(255))";
            databaseAccess.executeUpdate("CREATE TABLE " + ipaddress + SNMP_STATIS_MIB_INSTANCE_TABLE + statisItem);
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
                databaseAccess = null;
            }
        }
    }

    public synchronized void addStatisticsMibDataColumn(String targetIpAddress, String columnName) throws DatabaseConnectionException, SQLException {
        String ipaddress = "IP" + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            this.addColumn(databaseAccess, String.valueOf(ipaddress) + SNMP_STATIS_MIB_DATA_TABLE, columnName);
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
                databaseAccess = null;
            }
        }
    }

    private void addColumn(DatabaseAccess databaseAccess, String addTableName, String columnName) throws DatabaseConnectionException, SQLException {
        String databaseKind = DatabaseAccessControlKind.getInstance().getDatabaseName();
        if (databaseKind.equals("MySQL")) {
            databaseAccess.executeUpdate("ALTER TABLE " + addTableName + " ADD (" + columnName + " " + "DOUBLE" + ");");
        } else if (databaseKind.equals("Postgresql")) {
            databaseAccess.executeUpdate("ALTER TABLE " + addTableName + " ADD COLUMN " + columnName + " " + "double precision" + ";");
        } else if (databaseKind.equals("HSQLDB")) {
            databaseAccess.executeUpdate("ALTER TABLE " + addTableName + " ADD COLUMN " + columnName + " " + "REAL" + ";");
        } else if (databaseKind.equals("Apache Derby") || databaseKind.equals("Embedded Derby")) {
            databaseAccess.executeUpdate("ALTER TABLE " + addTableName + " ADD COLUMN " + columnName + " " + "double precision");
        } else {
            databaseAccess.executeUpdate("ALTER TABLE " + addTableName + " ADD COLUMN " + columnName + " " + "BIGINT" + ";");
        }
    }

    public synchronized void putInstanceTable(String targetIpAddress, String oid, String instanceName) throws DatabaseConnectionException, SQLException {
        String ipaddress = "IP" + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            databaseAccess.executeUpdate("insert into " + ipaddress + SNMP_STATIS_MIB_INSTANCE_TABLE + "(" + STATIS_OID + "," + INSTANCE_NAME + ")" + " VALUES( " + "'" + oid + "'," + "'" + instanceName + "')");
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
                databaseAccess = null;
            }
        }
    }

    public synchronized void put(String snmptablename, String oid, ArrayList statisItemList) throws DatabaseConnectionException, SQLException {
        StringBuffer item = new StringBuffer();
        StringBuffer value = new StringBuffer();
        String sql = "";
        Date date = Calendar.getInstance().getTime();
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            try {
                int j = 0;
                while (j < statisItemList.size()) {
                    item.append(String.valueOf(((MibValue)statisItemList.get(j)).getMibName().replace('.', '_')) + ",");
                    if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Apache Derby") || DatabaseAccessControlKind.getInstance().getDatabaseName().equals("Embedded Derby")) {
                        String mibValue = ((MibValue)statisItemList.get(j)).getMibValue();
                        if (mibValue.equals("NaN") || mibValue.equals("NAN")) {
                            mibValue = "0";
                        }
                        value.append(" " + mibValue + ",");
                    } else {
                        value.append("'" + ((MibValue)statisItemList.get(j)).getMibValue() + "',");
                    }
                    ++j;
                }
                sql = "insert into " + snmptablename + SNMP_STATIS_MIB_DATA_TABLE + " ( " + STATIS_OID + ", " + item + " " + CURDATE + " )" + " VALUES( '" + oid + "', " + value + " '" + this.simpleDateformat.format(date) + "'" + ")";
                databaseAccess.executeUpdate(sql);
            }
            catch (SQLException ex) {
                logger.warning(String.valueOf(ex.getMessage()) + " SQL=" + sql);
                logger.warning("Table=" + snmptablename + SNMP_STATIS_MIB_DATA_TABLE + " oid=" + oid);
                throw ex;
            }
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
                databaseAccess = null;
            }
        }
    }

    public synchronized void putStatisticsTable(String targetIpAddress, String oid, String period, String threshHold, String type, int instanceNo) throws DatabaseConnectionException, SQLException {
        Date date = Calendar.getInstance().getTime();
        String ipaddress = "IP" + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');
        String sql = "insert into " + ipaddress + SNMP_STATIS_CONFIG_TABLE_NAME + "( " + STATIS_OID + ", " + INSTANCE_TOTAL + ", " + PERIOD + ", " + THRESHOLD + ", " + THRESHOLD_TYPE + ", " + CURDATE + " )" + " VALUES( " + "'" + oid + "'," + "'" + instanceNo + "'," + "'" + period + "'," + "'" + threshHold + "'," + "'" + type + "'," + "'" + this.simpleDateformat.format(date) + "') ";
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            try {
                databaseAccess.executeUpdate(sql);
            }
            catch (DatabaseConnectionException e) {
                logger.warning(String.valueOf(e.getMessage()) + " : IP=" + targetIpAddress + " OID=" + oid + " Period=" + period + " Threshold=" + threshHold + " Type=" + type + " Instance=" + instanceNo);
                throw e;
            }
            catch (SQLException e) {
                logger.warning(String.valueOf(e.getMessage()) + " : IP=" + targetIpAddress + " OID=" + oid + " Period=" + period + " Threshold=" + threshHold + " Type=" + type + " Instance=" + instanceNo);
                throw e;
            }
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
                databaseAccess = null;
            }
        }
    }

    public synchronized void updateStatisticsTable(String targetIpAddress, String oid, String period, String threshHold, String type) throws DatabaseConnectionException, SQLException {
        String ipaddress = "IP" + targetIpAddress.replace('.', '_');
        ipaddress = ipaddress.replace('-', '_');
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            try {
                String sql = "UPDATE " + ipaddress + SNMP_STATIS_CONFIG_TABLE_NAME + " set" + " " + PERIOD + "= " + "'" + period + "'," + " " + THRESHOLD + "= " + "'" + threshHold + "'," + " " + THRESHOLD_TYPE + "= " + "'" + type + "'" + " where " + STATIS_OID + "=" + "'" + oid + "'";
                databaseAccess.executeUpdate(sql);
            }
            catch (DatabaseConnectionException e) {
                logger.warning(String.valueOf(e.getMessage()) + " : IP=" + targetIpAddress + " OID=" + oid + " Period=" + period + " Threshold=" + threshHold + " Type=" + type);
                throw e;
            }
            catch (SQLException ex) {
                logger.warning(String.valueOf(ex.getMessage()) + " : IP=" + targetIpAddress + " OID=" + oid + " Period=" + period + " Threshold=" + threshHold + " Type=" + type);
                throw ex;
            }
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
                databaseAccess = null;
            }
        }
    }

    public synchronized ArrayList get(String snmptablename, String oid, ArrayList statisItemList) {
        ArrayList<StatisticsInfo> dataList = new ArrayList<StatisticsInfo>();
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        String[] item = new String[statisItemList.size()];
        int j = 0;
        while (j < statisItemList.size()) {
            item[j] = ((MibValue)statisItemList.get(j)).getMibName().replace('.', '_');
            ++j;
        }
        try {
            try {
                String exesql = "select * from " + snmptablename + SNMP_STATIS_MIB_DATA_TABLE + " where " + STATIS_OID + "=" + "'" + oid + "'" + " order by " + CURDATE + " desc";
                conn = dataaccess.getConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(exesql);
                if (rs.next()) {
                    int i = 0;
                    while (i < item.length) {
                        StatisticsInfo info = new StatisticsInfo();
                        info.setInstance(rs.getObject(item[i]).toString());
                        info.setDate((Date)rs.getObject(CURDATE));
                        dataList.add(info);
                        ++i;
                    }
                }
            }
            catch (Exception ex) {
                logger.warning(String.valueOf(ex.getMessage()) + " : Table=" + snmptablename + " OID=" + oid);
                ex.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
            }
            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            dataaccess = null;
            throw throwable;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            stmt = null;
        }
        if (conn != null && dataaccess != null) {
            dataaccess.releaseConnection(conn);
            conn = null;
        }
        if (dataaccess != null) {
            DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
        }
        dataaccess = null;
        return dataList;
    }

    public synchronized ArrayList findInstance(String ipaddress, String oid, String instance, String startTime, String endTime) throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        ArrayList<StatisticsMibInfo> statisticsInfoList = new ArrayList<StatisticsMibInfo>();
        try {
            String convIPAddress = "IP" + ipaddress.replace('.', '_');
            convIPAddress = convIPAddress.replace('-', '_');
            String convInstance = instance.replace('.', '_');
            String convDotOid = oid.replace('_', '.');
            String sql = startTime != null && endTime != null ? "SELECT " + convInstance + "," + CURDATE + " from " + convIPAddress + SNMP_STATIS_MIB_DATA_TABLE + " where " + CURDATE + " between " + "'" + startTime + "'" + " and " + "'" + endTime + "'" + " and " + STATIS_OID + "=" + "'" + convDotOid + "'" + " order by " + CURDATE + " desc" : "SELECT " + convInstance + "," + CURDATE + " from " + convIPAddress + SNMP_STATIS_MIB_DATA_TABLE + " where " + STATIS_OID + "=" + "'" + convDotOid + "'" + " order by " + CURDATE + " desc";
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                StatisticsMibInfo statisticsMibInfo = new StatisticsMibInfo();
                statisticsMibInfo.setStatisMibValue(rs.getObject(convInstance).toString());
                statisticsMibInfo.setDate((Date)rs.getObject(CURDATE));
                statisticsInfoList.add(statisticsMibInfo);
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            dataaccess = null;
            throw throwable;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            stmt = null;
        }
        if (conn != null && dataaccess != null) {
            dataaccess.releaseConnection(conn);
            conn = null;
            DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
        }
        dataaccess = null;
        return statisticsInfoList;
    }

    public synchronized ArrayList getList(String ipaddress) throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<StatisticsMibSetStatus> controlDataList = new ArrayList<StatisticsMibSetStatus>();
        String convipaddress = "IP" + ipaddress.replace('.', '_');
        convipaddress = convipaddress.replace('-', '_');
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            String sql = "SELECT * from " + convipaddress + SNMP_STATIS_CONFIG_TABLE_NAME;
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                StatisticsMibSetStatus statisticsset = new StatisticsMibSetStatus();
                statisticsset.setReadOid(rs.getObject(STATIS_OID).toString());
                statisticsset.setReadPeriod(rs.getObject(PERIOD).toString());
                statisticsset.setReadThreshold(rs.getObject(THRESHOLD).toString());
                statisticsset.setReadThresholdType(rs.getObject(THRESHOLD_TYPE).toString());
                statisticsset.setReadCurDate(rs.getObject(CURDATE).toString());
                controlDataList.add(statisticsset);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            dataaccess = null;
        }
        return controlDataList;
    }

    public synchronized StatisticsMibProperty getDataCount(String ipaddress, String oid, String instance) throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        StatisticsMibProperty statisticsProp = new StatisticsMibProperty();
        try {
            String convIPAddress = "IP" + ipaddress.replace('.', '_');
            convIPAddress = convIPAddress.replace('-', '_');
            String convInstance = instance.replace('.', '_');
            String convDotOid = oid.replace('_', '.');
            String sql = "select count(*) from " + convIPAddress + SNMP_STATIS_MIB_DATA_TABLE + " where " + STATIS_OID + "=" + "'" + convDotOid + "'";
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            rs.next();
            int count = -1;
            count = rs.getInt(1);
            statisticsProp.setTotalDataCount(count);
            sql = "select min(curdate), max(curdate) from " + convIPAddress + SNMP_STATIS_MIB_DATA_TABLE + " where " + STATIS_OID + "=" + "'" + convDotOid + "'";
            rs = stmt.executeQuery(sql);
            rs.next();
            statisticsProp.setStartDate((Date)rs.getObject(1));
            statisticsProp.setEndDate((Date)rs.getObject(2));
            sql = "select min(" + convInstance + "), " + "max" + "(" + convInstance + ") from " + convIPAddress + SNMP_STATIS_MIB_DATA_TABLE + " where " + STATIS_OID + "=" + "'" + convDotOid + "'";
            rs = stmt.executeQuery(sql);
            rs.next();
            double minValue = -1.0;
            if (rs.getObject(1) != null) {
                minValue = Double.parseDouble(rs.getObject(1).toString());
            }
            double maxValue = -1.0;
            if (rs.getObject(2) != null) {
                maxValue = Double.parseDouble(rs.getObject(2).toString());
            }
            statisticsProp.setMinData(Double.toString(minValue));
            statisticsProp.setMaxData(Double.toString(maxValue));
        }
        catch (Throwable throwable) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            dataaccess = null;
            throw throwable;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            stmt = null;
        }
        if (conn != null && dataaccess != null) {
            dataaccess.releaseConnection(conn);
            conn = null;
            DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
        }
        dataaccess = null;
        return statisticsProp;
    }

    public synchronized ArrayList findIfDescriptor(String ipaddress) throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        ArrayList<StatisticsMibIfDescriptor> statisticsMibIfDescList = new ArrayList<StatisticsMibIfDescriptor>();
        ArrayList<String> oidList = new ArrayList<String>();
        String convipaddress = "IP" + ipaddress.replace('.', '_');
        convipaddress = convipaddress.replace('-', '_');
        try {
            String sql = "SELECT * from " + convipaddress + SNMP_STATIS_CONFIG_TABLE_NAME;
            System.out.println(sql);
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                oidList.add(rs.getObject(STATIS_OID).toString().replace('.', '_'));
            }
            sql = "SELECT * from " + convipaddress + "_if";
            HashMap<String, String> ifDescMap = new HashMap<String, String>();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                ifDescMap.put(rs.getObject("ifIndex").toString(), rs.getObject("ifDesc").toString());
            }
            int i = 0;
            while (i < oidList.size()) {
                sql = "SELECT * from " + convipaddress + SNMP_STATIS_MIB_INSTANCE_TABLE + " where " + STATIS_OID + "=" + "'" + ((String)oidList.get(i)).replace('_', '.') + "'";
                System.out.println(sql);
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    String instanceName = rs.getObject(INSTANCE_NAME).toString();
                    String[] instanceSplit = instanceName.split("[.]", 2);
                    String ifDesc = (String)ifDescMap.get(instanceSplit[1]);
                    StatisticsMibIfDescriptor statisticsMibIfDesc = new StatisticsMibIfDescriptor();
                    statisticsMibIfDesc.setOid("Oid=" + ((String)oidList.get(i)).replace('_', '.'));
                    statisticsMibIfDesc.setInstance(rs.getObject(INSTANCE_NAME).toString());
                    int check0 = ((String)oidList.get(i)).replace('_', '.').indexOf("1.3.6.1.2.1.2.2.1");
                    if (check0 >= 0) {
                        statisticsMibIfDesc.setIfDescriptor("ifDesc=" + ifDesc);
                    } else {
                        statisticsMibIfDesc.setIfDescriptor("");
                    }
                    statisticsMibIfDescList.add(statisticsMibIfDesc);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            dataaccess = null;
            throw throwable;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            stmt = null;
        }
        if (conn != null && dataaccess != null) {
            dataaccess.releaseConnection(conn);
            conn = null;
            DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
        }
        dataaccess = null;
        return statisticsMibIfDescList;
    }

    public synchronized StatisticsMibProperty findStatisticsInstanceMap(String ipaddress) throws DatabaseConnectionException, SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        StatisticsMibProperty mibProperty = new StatisticsMibProperty();
        ArrayList<StatisticsMibIfDescriptor> statisticsMibIfDescList = new ArrayList<StatisticsMibIfDescriptor>();
        HashMap<String, ArrayList> statisticsMibInstanceMap = new HashMap<String, ArrayList>();
        ArrayList<String> oidList = new ArrayList<String>();
        String convipaddress = "IP" + ipaddress.replace('.', '_');
        convipaddress = convipaddress.replace('-', '_');
        try {
            String sql = "SELECT * from " + convipaddress + SNMP_STATIS_CONFIG_TABLE_NAME;
            System.out.println(sql);
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                oidList.add(rs.getObject(STATIS_OID).toString().replace('.', '_'));
            }
            sql = "SELECT * from " + convipaddress + "_if";
            System.out.println(sql);
            HashMap<String, String> ifDescMap = new HashMap<String, String>();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                ifDescMap.put(rs.getObject("ifIndex").toString(), rs.getObject("ifDesc").toString());
                System.out.println("ifDesc : " + rs.getObject("ifDesc").toString());
                System.out.println("ifIndex : " + rs.getObject("ifIndex").toString());
            }
            int i = 0;
            while (i < oidList.size()) {
                sql = "SELECT * from " + convipaddress + SNMP_STATIS_MIB_INSTANCE_TABLE + " where " + STATIS_OID + "=" + "'" + ((String)oidList.get(i)).replace('_', '.') + "'";
                System.out.println(sql);
                rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    ArrayList ifList;
                    String instanceName = rs.getObject(INSTANCE_NAME).toString();
                    String[] instanceSplit = instanceName.split("[.]", 2);
                    String ifDesc = (String)ifDescMap.get(instanceSplit[1]);
                    StatisticsMibIfDescriptor statisticsMibIfDesc = new StatisticsMibIfDescriptor();
                    statisticsMibIfDesc.setOid("Oid=" + ((String)oidList.get(i)).replace('_', '.'));
                    statisticsMibIfDesc.setInstance(rs.getObject(INSTANCE_NAME).toString());
                    int check0 = ((String)oidList.get(i)).replace('_', '.').indexOf("1.3.6.1.2.1.2.2.1");
                    if (check0 >= 0) {
                        statisticsMibIfDesc.setIfDescriptor("ifDesc=" + ifDesc);
                    } else {
                        statisticsMibIfDesc.setIfDescriptor("");
                    }
                    statisticsMibIfDescList.add(statisticsMibIfDesc);
                    String checkOID = ((String)oidList.get(i)).replace('_', '.');
                    if (statisticsMibInstanceMap.containsKey(checkOID)) {
                        ifList = (ArrayList)statisticsMibInstanceMap.get(checkOID);
                        ifList.add(statisticsMibIfDesc);
                        statisticsMibInstanceMap.put(checkOID, ifList);
                        continue;
                    }
                    ifList = new ArrayList();
                    ifList.add(statisticsMibIfDesc);
                    statisticsMibInstanceMap.put(checkOID, ifList);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            dataaccess = null;
            throw throwable;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            stmt = null;
        }
        if (conn != null && dataaccess != null) {
            dataaccess.releaseConnection(conn);
            conn = null;
            DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
        }
        dataaccess = null;
        mibProperty.setMibIfDescriptorList(statisticsMibIfDescList);
        mibProperty.setStatisticsMibInstanceMap(statisticsMibInstanceMap);
        return mibProperty;
    }

    public synchronized ArrayList getInterfaceDataList(String ipaddress, String oid, String mode) throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        ArrayList<InterfaceData> ifObjectList = new ArrayList<InterfaceData>();
        ArrayList<String> instanceNameList = new ArrayList<String>();
        try {
            String convIPAddress = "IP" + ipaddress.replace('.', '_');
            convIPAddress = convIPAddress.replace('-', '_');
            String sql = "SELECT instance_name from " + convIPAddress + SNMP_STATIS_MIB_INSTANCE_TABLE + " where " + STATIS_OID + "=" + "'" + oid + "'";
            String instanceName = "";
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                instanceNameList.add(((String)rs.getObject(INSTANCE_NAME)).replace('.', '_'));
                instanceName = String.valueOf(instanceName) + ((String)rs.getObject(INSTANCE_NAME)).replace('.', '_') + ",";
            }
            sql = "SELECT " + instanceName + " " + CURDATE + " from " + convIPAddress + SNMP_STATIS_MIB_DATA_TABLE + " where " + STATIS_OID + "=" + "'" + oid + "'" + " order by " + CURDATE + " desc";
            rs = stmt.executeQuery(sql);
            int datacnt = 0;
            InterfaceData interfaceinfo = null;
            while (rs.next()) {
                int i = 0;
                while (instanceNameList.size() > i) {
                    interfaceinfo = new InterfaceData();
                    interfaceinfo.setInstanceName((String)instanceNameList.get(i));
                    interfaceinfo.setInstanceValue(rs.getObject((String)instanceNameList.get(i)).toString());
                    interfaceinfo.setDate((Date)rs.getObject(CURDATE));
                    ifObjectList.add(interfaceinfo);
                    ++i;
                }
                if (!mode.equals("integral") && datacnt < 1) {
                    ++datacnt;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
            }
            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            throw throwable;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            stmt = null;
        }
        if (conn != null && dataaccess != null) {
            dataaccess.releaseConnection(conn);
            conn = null;
        }
        if (dataaccess != null) {
            DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
        }
        return ifObjectList;
    }

    /* synthetic */ DBTableStatisticsMIBControl(DBTableStatisticsMIBControl dBTableStatisticsMIBControl) {
        this();
    }

    private static class SingletonResource {
        static final DBTableStatisticsMIBControl RESOURCE = new DBTableStatisticsMIBControl(null);

        private SingletonResource() {
        }
    }
}

