/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.command.control;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;
import netjfwatcher.authentication.AuthenticationManager;
import netjfwatcher.engine.command.control.ICommand;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.AuthenticationInfo;

public abstract class TemplateCommandImpl
implements ICommand {
    private static Logger logger;

    public TemplateCommandImpl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void execute(CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        if (!this.checkAuth(com, ois, oos)) {
            return;
        }
        this.doInvoke(com, ois, oos);
    }

    public abstract void doInvoke(CommandInfo var1, ObjectInputStream var2, ObjectOutputStream var3);

    public boolean checkAuth(CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        if (!AuthenticationManager.getInstance().checkIP(com.getIpaddress())) {
            AuthenticationInfo authInfo = com.getAuthInfo();
            if (authInfo == null) {
                com.setCode("AUTH");
                this.sendResponse(com, ois, oos);
                return false;
            }
            if (!AuthenticationManager.getInstance().checkUserName(com.getIpaddress(), authInfo.getUserName(), authInfo.getPassword())) {
                com.setCode("AUTH");
                this.sendResponse(com, ois, oos);
                return false;
            }
        }
        return true;
    }

    public void sendResponse(Object resObj, ObjectInputStream ois, ObjectOutputStream oos) {
        try {
            oos.writeObject(resObj);
            oos.flush();
            CommandInfo resCom = (CommandInfo)ois.readObject();
            if (!resCom.getCode().equals("ACK")) {
                logger.warning("No Ack : " + resCom.getCode());
            }
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }
}

