/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.action;

import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.database.access.model.DBTableMapLink;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.model.action.NodeListExport;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.ConnectionNodeMapLink;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.jdom.Document;
import org.osgi.framework.Bundle;

public abstract class ActionBuilderNodeList {
    private static Logger logger;
    private IEditorPart editorNodeConfigView;
    private IAction showNodeListTableAction = new ActionShowNodeListTable();
    private IAction importNodeListAction = new ActionImportNodeListFile();
    private IAction importNodeListActionSocket = new ActionImportNodeListFileSocket();
    private IAction exportNodeListAction = new ActionExportNodeListFile();
    private IAction exportNodeListActionSocket = new ActionExportNodeListFileSocket();
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    public ActionBuilderNodeList() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public IAction getActionImportNodeListFile() {
        return this.importNodeListAction;
    }

    public IAction getActionImportNodeListFileSocket() {
        return this.importNodeListActionSocket;
    }

    public IAction getActionExportNodeListFile() {
        return this.exportNodeListAction;
    }

    public IAction getActionExportNodeListFileSocket() {
        return this.exportNodeListActionSocket;
    }

    public IAction getActionShowNodeListTable() {
        return this.showNodeListTableAction;
    }

    protected void refreshAlarmTable() {
    }

    /*
     * Exception decompiling
     */
    private void registerNode(boolean isSocket) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void exportNodeInfo(boolean isSocket) {
        Shell shell = new Shell();
        FileDialog openDialog = new FileDialog(shell, 8192);
        String xmlFile = openDialog.open();
        System.out.println("openFile : " + xmlFile);
        logger.info("XML file name : " + xmlFile);
        shell.dispose();
        if (xmlFile == null) {
            return;
        }
        ArrayList nodeList = this.getNodeList(isSocket);
        NodeMapLinkInformation linkInfo = this.getNodeLinkList(isSocket);
        NodeListExport export = new NodeListExport();
        Document doc = export.updateDocument(nodeList, linkInfo);
        export.outputXMLFile(xmlFile, doc);
    }

    private ArrayList getNodeList(boolean isSocket) {
        ArrayList nodeList;
        block8: {
            nodeList = null;
            Shell shell = null;
            try {
                try {
                    if (!isSocket) {
                        DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister.getInstance();
                        nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);
                        break block8;
                    }
                    String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
                    ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(engineAddress);
                    nodeList = connectNodeInfo.getNodeInformationList(null, null);
                }
                catch (SQLException e1) {
                    shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e1.getMessage());
                    logger.warning("Node List import error " + e1.getMessage());
                    e1.printStackTrace();
                }
                catch (Exception e1) {
                    shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e1.getMessage());
                    logger.warning("Node List import error " + e1.getMessage());
                    e1.printStackTrace();
                }
            }
            finally {
                if (shell != null) {
                    shell.dispose();
                }
            }
        }
        return nodeList;
    }

    private NodeMapLinkInformation getNodeLinkList(boolean isSocket) {
        NodeMapLinkInformation nodMapLinkinfo;
        block8: {
            nodMapLinkinfo = null;
            Shell shell = null;
            try {
                try {
                    if (!isSocket) {
                        DBTableMapLink nodeMapLinkDBTable = new DBTableMapLink();
                        nodMapLinkinfo = nodeMapLinkDBTable.findAll();
                        break block8;
                    }
                    String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
                    ConnectionNodeMapLink connectNodeInfo = new ConnectionNodeMapLink(engineAddress);
                    nodMapLinkinfo = connectNodeInfo.getNodeMapInformation();
                }
                catch (SQLException e1) {
                    logger.warning("Node List import error " + e1.getMessage());
                    shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e1.getMessage());
                    shell.dispose();
                    e1.printStackTrace();
                }
                catch (Exception e1) {
                    logger.warning("Node List import error " + e1.getMessage());
                    shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e1.getMessage());
                    shell.dispose();
                    e1.printStackTrace();
                }
            }
            finally {
                if (shell != null) {
                    shell.dispose();
                }
            }
        }
        return nodMapLinkinfo;
    }

    private abstract class AbstractNodeListAction
    extends Action {
        private AbstractNodeListAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    protected class ActionShowNodeListTable
    extends AbstractNodeListAction {
        protected ActionShowNodeListTable() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeList.this.bundle.getEntry("icons/reload.gif"));
        }

        public String getText() {
            return "Node list table show";
        }

        public String getToolTipText() {
            return "Node list\u30c6\u30fc\u30d6\u30eb\u3092\u8868\u793a\u3057\u307e\u3059";
        }

        protected void doTask() {
            ActionBuilderNodeList.this.refreshAlarmTable();
        }
    }

    protected class ActionImportNodeListFile
    extends AbstractNodeListAction {
        protected ActionImportNodeListFile() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeList.this.bundle.getEntry("icons/import_wiz.gif"));
        }

        public String getText() {
            return "Import Node List";
        }

        public String getToolTipText() {
            return "Import Node List";
        }

        protected void doTask() {
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    ActionBuilderNodeList.this.registerNode(false);
                }
            });
        }
    }

    protected class ActionImportNodeListFileSocket
    extends ActionImportNodeListFile {
        protected ActionImportNodeListFileSocket() {
        }

        protected void doTask() {
            ActionBuilderNodeList.this.registerNode(true);
        }
    }

    protected class ActionExportNodeListFile
    extends AbstractNodeListAction {
        protected ActionExportNodeListFile() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeList.this.bundle.getEntry("icons/export_wiz.gif"));
        }

        public String getText() {
            return "Export Node list file";
        }

        public String getToolTipText() {
            return "\u30ce\u30fc\u30c9\u76e3\u8996\u60c5\u5831\u3092\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u3057\u307e\u3059";
        }

        protected void doTask() {
            ActionBuilderNodeList.this.exportNodeInfo(false);
        }
    }

    protected class ActionExportNodeListFileSocket
    extends ActionExportNodeListFile {
        protected ActionExportNodeListFileSocket() {
        }

        protected void doTask() {
            ActionBuilderNodeList.this.exportNodeInfo(true);
        }
    }
}

