/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.nodemaneger.list;

import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.common.view.TableListViewColor;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList;
import netjfwatcher.engine.model.action.ActionBuilderChart;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.engine.model.action.ActionBuilderNetworkCamera;
import netjfwatcher.engine.model.action.ActionBuilderNodeList;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation;
import netjfwatcher.engine.model.action.ActionBuilderSnmp;
import netjfwatcher.engine.model.action.EngineStatus;
import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.engine.nodemaneger.list.NodeListTableViewContentProvider;
import netjfwatcher.engine.nodemaneger.list.NodeListTableViewLabelProvider;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.TableColumnControlTableListener;
import netjfwatcher.engine.view.editorpart.ping.NodePingMenu;
import netjfwatcher.engine.view.editorpart.snmp.NodeSnmpStatisticsMenu;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class NodeListTableView
extends AbstractTableView {
    protected static final int COUNT_TEXT_WIDTH = 100;
    protected static boolean isCol0Direction = false;
    protected static boolean isCol1Direction = true;
    protected static boolean isCol2Direction = true;
    protected static boolean isCol3Direction = true;
    protected static boolean isCol4Direction = true;
    protected static boolean isCol5Direction = true;
    protected static boolean isCol6Direction = true;
    private static Logger logger = null;
    protected static int[] imageColumn = new int[]{1, 6};
    protected static Text nodeCountText;
    protected static Button refreshButton;
    private static final float COLUMN0NO = 0.03f;
    private static final float COLUMN1NAME = 0.1f;
    private static final float COLUMN2GROUP = 0.1f;
    private static final float COLUMN3ADDRESS = 0.1f;
    private static final float COLUMN4REGDATE = 0.1f;
    private static final float COLUMN5CHECKDATE = 0.1f;
    private static final float COLUMN6STATUS = 0.4f;
    protected Display display;
    protected Table table;
    protected Color textBackColor;
    protected TableViewer viewer;
    protected TableColumn col0;
    protected TableColumn col1;
    protected TableColumn col2;
    protected TableColumn col3;
    protected TableColumn col4;
    protected TableColumn col5;
    protected TableColumn col6;
    protected HashMap<String, NodeInformation> nodeInfoIPAddressMap = new HashMap();
    protected final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
    protected NodeSnmpStatisticsMenu nodeSnmpStatisticsMenu = new NodeSnmpStatisticsMenu();
    protected NodePingMenu nodePingMenu = new NodePingMenu();
    protected NodeListAction nodeListAction = new NodeListAction();
    protected ActionBuilderAlarmList alarmAction = new ActionBuilderAlarmList();
    protected ActionBuilderChart nodeChart = new ActionBuilderChart();
    protected ActionBuilderSnmp snmpAction = new ActionBuilderSnmp();
    protected ActionBuilderNodeOperation actionBuilderNodeOperation = new ActionBuilderNodeOperation();
    protected ActionBuilderNetworkCamera networkCameraAction = new ActionBuilderNetworkCamera();
    protected ActionBuilderEditorsPartClose actionBuilderEditorPart = new ActionBuilderEditorsPartClose();
    protected SubStatusLineManager statusLineManager;
    protected String selectIPAddress;
    protected Image errorImage;
    protected Image warningImage;
    protected Image infoImage;
    protected String errorImageFile = "icons/alarm_level_.gif";
    protected String warningImageFile = "icons/alarm_level_warning.gif";
    protected String infoImageFile = "icons/alarm_level_info.gif";
    protected static Color whiteColor;
    protected HashMap<String, Image> nodeIconImageMap = new HashMap();

    static {
        whiteColor = new Color(null, 255, 255, 255);
    }

    public NodeListTableView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.textBackColor = whiteColor;
    }

    public void setFocus() {
        if (EngineStatus.getInstance().isEngine()) {
            this.setNodeListView(true);
        }
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        this.createTable(parent);
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new NodeListTableViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new NodeListTableViewLabelProvider());
        this.createImage();
        this.createContextMenu();
        this.setToolBarActions();
        this.setNodeListView(false);
        this.setStatusLine();
        this.table.addSelectionListener((SelectionListener)new TableColumnControlTableListener(this.table, 6));
    }

    protected void createImage() {
        URL url = null;
        try {
            url = this.bundle.getEntry(this.errorImageFile);
            if (url == null) {
                logger.severe("Not found icon file : " + this.errorImageFile);
            } else {
                this.errorImage = new Image((Device)this.display, url.openStream());
            }
            url = this.bundle.getEntry(this.warningImageFile);
            if (url == null) {
                logger.severe("Not found icon file : " + this.errorImageFile);
            } else {
                this.warningImage = new Image((Device)this.display, url.openStream());
            }
            url = this.bundle.getEntry(this.infoImageFile);
            if (url == null) {
                logger.severe("Not found icon file : " + this.errorImageFile);
            } else {
                this.infoImage = new Image((Device)this.display, url.openStream());
            }
        }
        catch (IOException e) {
            logger.warning("Abort create image " + e.getMessage() + " for " + this.errorImageFile);
            e.printStackTrace();
        }
    }

    protected int computeCol0Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.03f);
    }

    protected int computeCol1Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    protected int computeCol2Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    protected int computeCol3Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    protected int computeCol4Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    protected int computeCol5Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    protected int computeCol6Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.4f);
    }

    protected void createTable(Composite parent) {
        this.statusLineManager = (SubStatusLineManager)this.getViewSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
        int snmpPort = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo().getSnmpPort();
        this.statusLineManager.setMessage("Snmp Port=" + snmpPort);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        Composite operationContainer = new Composite(parent, 0);
        operationContainer.setLayout((Layout)new RowLayout(256));
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        operationContainer.setLayoutData((Object)data);
        Label nodeCountLabel = new Label(operationContainer, 0);
        nodeCountLabel.setText("Node Count");
        nodeCountText = new Text(operationContainer, 133128);
        nodeCountText.setLayoutData((Object)new RowData(100, -1));
        nodeCountText.setEditable(false);
        nodeCountText.setEnabled(false);
        nodeCountText.setBackground(this.textBackColor);
        refreshButton = new Button(operationContainer, 0);
        refreshButton.setText("Refresh");
        GridData data2 = new GridData();
        data2.horizontalAlignment = 4;
        data2.verticalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = true;
        this.table = new Table(parent, 68354);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)data2);
        this.col0 = new TableColumn(this.table, 0x1000000);
        this.col0.setText(NodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[0]);
        this.col0.setWidth(this.computeCol0Width());
        this.col1 = new TableColumn(this.table, 0x1000000);
        this.col1.setText(NodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[1]);
        this.col1.setWidth(this.computeCol1Width());
        this.col2 = new TableColumn(this.table, 0x1000000);
        this.col2.setText(NodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[2]);
        this.col2.setWidth(this.computeCol2Width());
        this.col3 = new TableColumn(this.table, 0x1000000);
        this.col3.setText(NodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[3]);
        this.col3.setWidth(this.computeCol3Width());
        this.col4 = new TableColumn(this.table, 0x1000000);
        this.col4.setText(NodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[4]);
        this.col4.setWidth(this.computeCol4Width());
        this.col5 = new TableColumn(this.table, 0x1000000);
        this.col5.setText(NodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[5]);
        this.col5.setWidth(this.computeCol5Width());
        this.col6 = new TableColumn(this.table, 0x1000000);
        this.col6.setText(NodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS[6]);
        this.col6.setWidth(this.computeCol6Width());
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent event) {
            }

            public void controlResized(ControlEvent event) {
                NodeListTableView.this.setResizedTableColumnWidth();
            }
        });
        this.col0.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol0Direction = NodeListTableView.this.sortIntegerTable(NodeListTableView.this.table, 0, isCol0Direction, imageColumn);
            }
        });
        this.col1.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol1Direction = NodeListTableView.this.sortTable(NodeListTableView.this.table, 1, isCol1Direction, imageColumn);
            }
        });
        this.col2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol2Direction = NodeListTableView.this.sortTable(NodeListTableView.this.table, 2, isCol2Direction, imageColumn);
            }
        });
        this.col3.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol3Direction = NodeListTableView.this.sortTable(NodeListTableView.this.table, 3, isCol3Direction, imageColumn);
            }
        });
        this.col4.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol4Direction = NodeListTableView.this.sortTable(NodeListTableView.this.table, 4, isCol4Direction, imageColumn);
            }
        });
        this.col5.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol5Direction = NodeListTableView.this.sortTable(NodeListTableView.this.table, 5, isCol5Direction, imageColumn);
            }
        });
        this.col6.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                isCol6Direction = NodeListTableView.this.sortTable(NodeListTableView.this.table, 6, isCol6Direction, imageColumn);
            }
        });
        refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                refreshButton.setEnabled(false);
                NodeListTableView.this.setNodeListView(true);
                refreshButton.setEnabled(true);
                NodeListTableView.this.setStatusLine();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    protected TableItem setTableItem(Table paraTable, TableItem item, String[] strs) {
        Color obj0 = item.getForeground();
        Color obj1 = item.getBackground();
        Color obj = item.getForeground(6);
        Image image1 = item.getImage(1);
        Image image2 = item.getImage(6);
        item.dispose();
        item = new TableItem(paraTable, 0);
        item.setText(strs);
        item.setData((Object)strs);
        item.setForeground(obj0);
        item.setBackground(obj1);
        item.setForeground(6, obj);
        item.setImage(1, image1);
        item.setImage(6, image2);
        return item;
    }

    private void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NodeListTableView.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add(this.nodeListAction.getActionShowNodeListTable());
        manager.add(this.nodeListAction.getActionImportNodeListFile());
        manager.add(this.nodeListAction.getActionExportNodeListFile());
        manager.add(this.actionBuilderNodeOperation.getActionNodeOperation());
        if (this.table.getSelectionIndex() >= 0 && this.table.getSelection() != null) {
            TableItem[] item = this.table.getSelection();
            String[] nodeInfo = (String[])item[0].getData();
            this.selectIPAddress = nodeInfo[3];
            NodeInformation targetNodeInfo = this.nodeInfoIPAddressMap.get(this.selectIPAddress);
            ((ActionBuilderNodeOperation.ActionNodeOperation)this.actionBuilderNodeOperation.getActionNodeOperation()).setNodeInfo(targetNodeInfo);
            ((ActionBuilderNodeOperation.ActionShowNodeView)this.actionBuilderNodeOperation.getActionShowNodeView()).setNodeInfo(targetNodeInfo);
            manager.add(this.actionBuilderNodeOperation.getActionShowNodeView());
            ((ActionBuilderSnmp.ActionShowNodeSnmpView)this.snmpAction.getActionSnmpInfo()).setNodeInfo(targetNodeInfo);
            manager.add(this.snmpAction.getActionSnmpInfo());
            ((ActionBuilderAlarmList.ActionOpenEditorPartPersonalNodeAlarm)this.alarmAction.getActionOpenEditorPartPersonalNodeAlarm()).setNodeInfo(targetNodeInfo);
            manager.add(this.alarmAction.getActionOpenEditorPartPersonalNodeAlarm());
            ((ActionBuilderAlarmList.ActionExportAlarmInfo)this.alarmAction.getActionExportAlarm()).setIpAddress(this.selectIPAddress);
            manager.add(this.alarmAction.getActionExportAlarm());
            this.nodePingMenu.createPingMenu(manager, targetNodeInfo, false);
            this.nodeSnmpStatisticsMenu.createSnmpStatisticsMenu(manager, targetNodeInfo, false);
            ((ActionBuilderSnmp.ActionSnmpStatisticsSet)this.snmpAction.getActionSnmpStatisticsSet()).setNodeInfo(targetNodeInfo);
            manager.add(this.snmpAction.getActionSnmpStatisticsSet());
            if (targetNodeInfo.getNodeKind().equals("Printer")) {
                ((ActionBuilderSnmp.ActionSnmpPrint)this.snmpAction.getActionPrintSnmp()).setNodeInfo(targetNodeInfo);
                manager.add(this.snmpAction.getActionPrintSnmp());
            }
            if (targetNodeInfo.getNodeKind().equals("Camera")) {
                ((ActionBuilderNetworkCamera.ActionNetworkCamera)this.networkCameraAction.getActionNetworkCamera()).setNodeInfo(targetNodeInfo);
                manager.add(this.networkCameraAction.getActionNetworkCamera());
            }
        }
        manager.add(this.alarmAction.getActionShowAllNodeAlarmListTable());
        manager.add(this.snmpAction.getActionSnmpStatistics());
    }

    private void setToolBarActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(this.nodeListAction.getActionShowNodeListTable());
        toolBarManager.add(this.nodeListAction.getActionImportNodeListFile());
        toolBarManager.add(this.nodeListAction.getActionExportNodeListFile());
        toolBarManager.add(this.alarmAction.getActionShowAllNodeAlarmListTable());
        ((ActionBuilderAlarmList.ActionExportAlarmInfo)this.alarmAction.getActionExportAlarm()).setIpAddress("all");
        toolBarManager.add(this.alarmAction.getActionExportAlarm());
        toolBarManager.add(this.actionBuilderEditorPart.actionCloseAllEditors());
    }

    protected void setNodeListView(boolean isNodeList) {
        this.table.removeAll();
        this.viewer.refresh();
        this.nodeInfoIPAddressMap.clear();
        ArrayList nodeList = null;
        if (isNodeList) {
            nodeList = this.getNodeList();
        }
        if (nodeList == null) {
            nodeCountText.setText("0");
            return;
        }
        nodeCountText.setText(Integer.toString(nodeList.size()));
        int i = 0;
        while (i < nodeList.size()) {
            NodeInformation nodeInfo = (NodeInformation)nodeList.get(i);
            this.nodeInfoIPAddressMap.put(nodeInfo.getIpaddress(), nodeInfo);
            String[] tableCellArray = new String[NodeListTableViewLabelProvider.NODE_LIST_TABLE_COLUMNS.length];
            tableCellArray[0] = Integer.toString(i + 1);
            tableCellArray[1] = nodeInfo.getNodename();
            tableCellArray[2] = nodeInfo.getGroup();
            tableCellArray[3] = nodeInfo.getIpaddress();
            tableCellArray[4] = nodeInfo.getRegisterDate();
            tableCellArray[5] = nodeInfo.getLastCheck() == null || nodeInfo.getLastCheck().equals("") ? "" : nodeInfo.getLastCheck();
            tableCellArray[6] = nodeInfo.getAlarmDate() != null && !nodeInfo.getAlarmDate().equals("") ? String.valueOf(nodeInfo.getAlarmDate()) + " : " + nodeInfo.getAlarmMessage() : "";
            TableItem item = new TableItem(this.table, 0);
            item.setText(tableCellArray);
            item.setData((Object)tableCellArray);
            Image nodeIconImage = this.createNodeIconImage(nodeInfo.getNodeKind());
            item.setImage(1, nodeIconImage);
            if (nodeInfo.getAlarmLevel() != null) {
                if (nodeInfo.getAlarmLevel().equals("ERROR")) {
                    item.setForeground(TableListViewColor.getInstance().getAlarmErrorLevelColor());
                    item.setImage(6, this.errorImage);
                } else if (nodeInfo.getAlarmLevel().equals("WARNING")) {
                    item.setImage(6, this.warningImage);
                } else if (nodeInfo.getAlarmLevel().equals("INFO")) {
                    item.setImage(6, this.infoImage);
                }
            }
            if (i % 2 == 0) {
                item.setBackground(TableListViewColor.getInstance().getNodeListOddBackgroundColor());
                item.setForeground(TableListViewColor.getInstance().getNodeListOddForgroundColor());
            } else {
                item.setBackground(TableListViewColor.getInstance().getNodeListEvenBackgroundColor());
                item.setForeground(TableListViewColor.getInstance().getNodeListEvenForgroundColor());
            }
            item.setForeground(6, TableListViewColor.getInstance().getNodeListStatusForgroundColor());
            ++i;
        }
    }

    protected Image createNodeIconImage(String nodeKind) {
        String node16IconFileName = MediaResource.getInstance().getNodeIcon16FileName(nodeKind);
        Image nodeIconImage = null;
        if (!this.nodeIconImageMap.containsKey(node16IconFileName)) {
            URL url = null;
            url = this.bundle.getEntry(node16IconFileName);
            if (url == null) {
                logger.severe("Npt found icon file : " + node16IconFileName);
            } else {
                try {
                    nodeIconImage = new Image((Device)this.display, url.openStream());
                    this.nodeIconImageMap.put(node16IconFileName, nodeIconImage);
                }
                catch (IOException e) {
                    logger.warning("Abort create image " + e.getMessage() + " for " + node16IconFileName);
                    e.printStackTrace();
                }
            }
        } else {
            nodeIconImage = this.nodeIconImageMap.get(node16IconFileName);
        }
        return nodeIconImage;
    }

    public ArrayList getNodeList() {
        DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister.getInstance();
        ArrayList nodeList = null;
        try {
            try {
                nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);
            }
            catch (SQLException e1) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e1.getMessage());
                logger.warning("Node List import error " + e1.getMessage());
                shell.dispose();
                ArrayList arrayList = nodeList;
                nodeRegisterDBTable = null;
                return arrayList;
            }
            catch (Exception e1) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e1.getMessage());
                logger.warning("Node List import error " + e1.getMessage());
                shell.dispose();
                ArrayList arrayList = nodeList;
                nodeRegisterDBTable = null;
                return arrayList;
            }
        }
        finally {
            nodeRegisterDBTable = null;
        }
        return nodeList;
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getViewSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
        this.statusLineManager.setMessage("Node List View Node count=" + this.nodeInfoIPAddressMap.size());
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.errorImage != null && !this.errorImage.isDisposed()) {
            this.errorImage.dispose();
        }
        if (this.warningImage != null && !this.warningImage.isDisposed()) {
            this.warningImage.dispose();
        }
        if (this.infoImage != null && !this.infoImage.isDisposed()) {
            this.infoImage.dispose();
        }
        HashMap<String, Image> list = this.nodeIconImageMap;
        Iterator it = null;
        for (String key : list.keySet()) {
            Image nodeIconImage = (Image)list.get(key);
            if (nodeIconImage == null) continue;
            nodeIconImage.dispose();
        }
        if (this.table != null) {
            this.table.dispose();
        }
    }

    protected void setResizedTableColumnWidth() {
        if (this.getSite().getPage().isPartVisible(this.getSite().getPart()) && this.getSite().getShell() != null) {
            this.getSite().getShell().getSize();
        }
    }

    protected final class NodeListAction
    extends ActionBuilderNodeList {
        protected NodeListAction() {
        }

        protected void refreshAlarmTable() {
            NodeListTableView.this.setNodeListView(true);
        }
    }
}

