/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.preferance;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.logging.Logger;
import netjfwatcher.engine.view.canvas.CanvasViewConfigFileParse;
import netjfwatcher.engine.view.canvas.CanvasViewInfo;
import netjfwatcher.snmpmanager.preferences.AbstractSnmpPreferencePage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.jdom.Document;

public class CanvasPreferencePage
extends AbstractSnmpPreferencePage {
    private static final int DEFAULT_CHART_WIDTH = 1400;
    private static final int DEFAULT_CHART_HEIGHT = 800;
    private static final int DEFAULT_CHART_X_SCALL = 1000;
    private static final int DEFAULT_CHART_Y_SCALL = 450;
    private static final int DEFAULT_NODE_MAP_WIDTH = 1900;
    private static final int DEFAULT_NODE_MAP_HEIGHT = 1700;
    private static final int TEXT_WIDTH = 200;
    private static final int HORIZONTAL_SPAN3 = 3;
    private Text chartWidthText;
    private Text chartHeightText;
    private Text chartXScallText;
    private Text chartYScallText;
    private Text nodeMapWidthText;
    private Text nodeMapHeightText;
    private int chart_width;
    private int chart_height;
    private int chart_x_scall;
    private int chart_y_scall;
    private int node_map_width;
    private int node_map_height;
    private static Logger logger;

    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    protected Control createContents(Composite parent) {
        this.textBackColor = Display.getCurrent().getSystemColor(1);
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridData gridData = null;
        Composite composite0 = new Composite(parent, 0);
        GridLayout gridLayoutV3AgentProp = new GridLayout(3, false);
        composite0.setLayout((Layout)gridLayoutV3AgentProp);
        composite0.setLayoutData((Object)new GridData(256));
        Label label = new Label(composite0, 0);
        label.setText("Chart View Width");
        label.setLayoutData((Object)new GridData());
        this.chartWidthText = new Text(composite0, 2048);
        this.chartWidthText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.chartWidthText.setBackground(this.textBackColor);
        this.chartWidthText.setLayoutData((Object)gridData);
        label = new Label(composite0, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite0, 0);
        label.setText("Chart View Height");
        label.setLayoutData((Object)new GridData());
        this.chartHeightText = new Text(composite0, 2048);
        this.chartHeightText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.chartHeightText.setBackground(this.textBackColor);
        this.chartHeightText.setLayoutData((Object)gridData);
        label = new Label(composite0, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite0, 0);
        label.setText("Chart X Scall");
        label.setLayoutData((Object)new GridData());
        this.chartXScallText = new Text(composite0, 2048);
        this.chartXScallText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.chartXScallText.setBackground(this.textBackColor);
        this.chartXScallText.setLayoutData((Object)gridData);
        label = new Label(composite0, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite0, 0);
        label.setText("Chart Y Scall");
        label.setLayoutData((Object)new GridData());
        this.chartYScallText = new Text(composite0, 2048);
        this.chartYScallText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.chartYScallText.setBackground(this.textBackColor);
        this.chartYScallText.setLayoutData((Object)gridData);
        label = new Label(composite0, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite0, 0);
        label.setText("Node Map View Width");
        label.setLayoutData((Object)new GridData());
        this.nodeMapWidthText = new Text(composite0, 2048);
        this.nodeMapWidthText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.nodeMapWidthText.setBackground(this.textBackColor);
        this.nodeMapWidthText.setLayoutData((Object)gridData);
        label = new Label(composite0, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite0, 0);
        label.setText("Node Map View Height");
        label.setLayoutData((Object)new GridData());
        this.nodeMapHeightText = new Text(composite0, 2048);
        this.nodeMapHeightText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.nodeMapHeightText.setBackground(this.textBackColor);
        this.nodeMapHeightText.setLayoutData((Object)gridData);
        label = new Label(composite0, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        Composite entryTable = new Composite(parent, 0);
        entryTable.setLayoutData((Object)new GridData(768));
        this.setText();
        return entryTable;
    }

    private void setText() {
        this.chart_width = CanvasViewConfigFileParse.getInstance().getChartWidth();
        this.chart_height = CanvasViewConfigFileParse.getInstance().getChartHeight();
        this.chart_x_scall = CanvasViewConfigFileParse.getInstance().getChartXScall();
        this.chart_y_scall = CanvasViewConfigFileParse.getInstance().getChartYScall();
        this.node_map_width = CanvasViewConfigFileParse.getInstance().getNodeMapWidth();
        this.node_map_height = CanvasViewConfigFileParse.getInstance().getNodeMapHeight();
        this.chartWidthText.setText(Integer.toString(this.chart_width));
        this.chartHeightText.setText(Integer.toString(this.chart_height));
        this.chartXScallText.setText(Integer.toString(this.chart_x_scall));
        this.chartYScallText.setText(Integer.toString(this.chart_y_scall));
        this.nodeMapWidthText.setText(Integer.toString(this.node_map_width));
        this.nodeMapHeightText.setText(Integer.toString(this.node_map_height));
    }

    protected void performDefaults() {
        this.chartWidthText.setText(Integer.toString(1400));
        this.chartHeightText.setText(Integer.toString(800));
        this.chartXScallText.setText(Integer.toString(1000));
        this.chartYScallText.setText(Integer.toString(450));
        this.nodeMapWidthText.setText(Integer.toString(1900));
        this.nodeMapHeightText.setText(Integer.toString(1700));
    }

    public boolean performOk() {
        CanvasViewInfo canvasViewInfo = new CanvasViewInfo();
        int value = this.checkText(this.chartWidthText);
        if (value <= 0) {
            return false;
        }
        canvasViewInfo.setChartWidth(value);
        value = this.checkText(this.chartHeightText);
        if (value <= 0) {
            return false;
        }
        canvasViewInfo.setChartHeight(value);
        value = this.checkText(this.chartXScallText);
        if (value <= 0) {
            return false;
        }
        canvasViewInfo.setChartXScall(value);
        value = this.checkText(this.chartYScallText);
        if (value <= 0) {
            return false;
        }
        canvasViewInfo.setChartYScall(value);
        value = this.checkText(this.nodeMapWidthText);
        if (value <= 0) {
            return false;
        }
        canvasViewInfo.setNodeMapWidth(value);
        value = this.checkText(this.nodeMapHeightText);
        if (value <= 0) {
            return false;
        }
        canvasViewInfo.setNodeMapHeight(value);
        this.saveCanvasInfo(canvasViewInfo);
        return super.performOk();
    }

    private int checkText(Text checkText) {
        int value = 0;
        try {
            value = Integer.parseInt(checkText.getText());
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Illegal data = " + checkText.getText() + "."));
            checkText.setFocus();
        }
        return value;
    }

    private void saveCanvasInfo(CanvasViewInfo canvasViewInfo) {
        Document dom = null;
        BufferedWriter bufWriter = null;
        dom = this.updateCanvasViewResource(canvasViewInfo);
        if (dom == null) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"Abort save Canvas View Info.");
            shell.dispose();
            return;
        }
        bufWriter = CanvasViewConfigFileParse.getInstance().getResourceFileWriter();
        this.outputXMLFile(bufWriter, dom);
        if (bufWriter != null) {
            try {
                bufWriter.close();
            }
            catch (IOException e) {
                logger.warning("Abort close BufferedWriter for Alarm Trap resource : " + e.getMessage());
                e.printStackTrace();
            }
        }
        CanvasViewConfigFileParse.getInstance().parseCanvasViewConfigFileParse();
    }

    private Document updateCanvasViewResource(CanvasViewInfo canvasViewInfo) {
        Document dom = CanvasViewConfigFileParse.getInstance().updateDocument(canvasViewInfo);
        return dom;
    }
}

