/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.socket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Logger;
import netjfwatcher.engine.socket.AbstractConnectionEngine;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.TaskScheduleInfo;

public class ConnectionTaskScheduleControl
extends AbstractConnectionEngine {
    private static Logger logger = null;

    public ConnectionTaskScheduleControl(String engineAddress) {
        super(engineAddress);
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void setTaskSchedule(Date taskStartDate, Date taskEndDate) throws EngineConnectException, IOException {
        CommandInfo commandInfo = new CommandInfo();
        commandInfo.setCode("TaskSchedule Control");
        TaskScheduleInfo taskInfo = new TaskScheduleInfo();
        taskInfo.setTaskStartDate(taskStartDate);
        taskInfo.setTaskEndDate(taskEndDate);
        commandInfo.setTaskScheduleInfo(taskInfo);
        this.communicationToEngine(commandInfo);
    }

    public ArrayList getTaskSchedule() throws EngineConnectException, IOException {
        ArrayList<TaskScheduleInfo> taskScheduleList = new ArrayList<TaskScheduleInfo>();
        HashMap responseTaskScheduleMapList = null;
        CommandInfo commandInfo = new CommandInfo();
        commandInfo.setCode("TaskSchedule Get");
        responseTaskScheduleMapList = (HashMap)this.communicationToEngine(commandInfo);
        for (String keyId : responseTaskScheduleMapList.keySet()) {
            TaskScheduleInfo info = (TaskScheduleInfo)responseTaskScheduleMapList.get(keyId);
            taskScheduleList.add(info);
            logger.info("Task ID : " + info.getId());
            logger.info("Task Start Date : " + info.getTaskStartDate());
            logger.info("Task End Date : " + info.getTaskEndDate());
        }
        return taskScheduleList;
    }

    public void cancelTaskSchedule(String taskId) throws EngineConnectException, IOException {
        CommandInfo commandInfo = new CommandInfo();
        commandInfo.setCode("TaskSchedule Cancel");
        TaskScheduleInfo taskInfo = new TaskScheduleInfo();
        taskInfo.setTaskID(taskId);
        commandInfo.setTaskScheduleInfo(taskInfo);
        this.communicationToEngine(commandInfo);
    }
}

