/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.node;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.engine.nodecontrol.NodeAdd;
import netjfwatcher.engine.nodecontrol.NodeDelete;
import netjfwatcher.engine.nodecontrol.NodeEdit;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionNodeControl;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.node.EditorNodeOperationCheckNode;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditorNodeOperation
extends AbstractEditorNodeView {
    public static final String TITLE_SUFFIX = "Node Add/Edit/Delete";
    private static final int[] SCROLL_COMPOSITE_SIZE = new int[]{800, 800};
    public static final int TEXT_WIDTH1 = 150;
    public static final int URL_TEXT_WIDTH = 400;
    public static final int AGENT_LIST_WIDTH = 200;
    public static final int AGENT_LIST_VERTICALSPAN = 7;
    private static final int AGENT_ADDRESS_LIST_ITEM_HEIGHT = 8;
    private static final int HORIZONTAL_SPAN3 = 3;
    private static final int VERTICAL_SPAN4 = 4;
    private static Logger logger;
    private static final int LIMIT_DATA = 60;
    private static final int PING_THRESHOLD_LIMIT_DATA = 20;
    private static final int NO_LIMIT_DATA = 0;
    private NodeInformation targetNodeInfo;
    private ArrayList nodeInfoList;
    private HashMap checkAddressList = new HashMap();
    private List agentAddressList;
    private Text nodeNameText;
    private Text nodeIPAddressText;
    private Text nodeGroupText;
    private Combo nodeKindCombo;
    private Text pingPeriodText;
    private Text pingThresholdText;
    private Combo snmpVersionCombo;
    private Combo snmpLevelCombo;
    private Text snmpPeriodText;
    private Text snmpROCommunityText;
    private Text snmpRWCommunityText;
    private Text httpUrlText;
    private Text httpPortText;
    private Text httpPeriodText;
    private Text httpTimeoutText;
    private Text pop3PeriodText;
    private Text pop3PortText;
    private Text pop3TimeoutText;
    private Text pop3UserText;
    private Text pop3PasswordText;
    private Text smtpPeriodText;
    private Text smtpPortText;
    private Text smtpTimeoutText;
    private Text smtpTestAddressText;
    private Text smtpCheckPop3HostText;
    private Text smtpCheckPop3PortText;
    private Text smtpCheckPop3UserText;
    private Text smtpCheckPop3PasswordText;
    private Text smtpCheckPop3TimeoutText;
    private Button loadAgentAddressListButton;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private EditorNodeOperationCheckNode checkNode = new EditorNodeOperationCheckNode();

    public EditorNodeOperation() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public void createPartControl(Composite parent) {
        EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView)this.getEditorInput();
        this.targetNodeInfo = nodeViewEditorInput.getNodeInfo();
        this.isSocket = nodeViewEditorInput.isSocket();
        if (this.targetNodeInfo == null) {
            logger.warning("NodeInfo null");
        }
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite composite0 = new Composite((Composite)scrollComposite, 0);
        composite0.setLayout((Layout)gridLayout0);
        composite0.setLayoutData((Object)new GridData(272));
        GridLayout gridLayout = new GridLayout(4, true);
        Composite composite1 = new Composite(composite0, 0);
        composite1.setLayout((Layout)gridLayout);
        composite1.setLayoutData((Object)new GridData(272));
        GridLayout gridLayout2 = new GridLayout(5, false);
        Composite composite2 = new Composite(composite0, 0);
        composite2.setLayoutData((Object)new GridData(272));
        composite2.setLayout((Layout)gridLayout2);
        gridData = new GridData();
        Label label = new Label(composite1, 0);
        label.setText("Agent address list");
        label.setLayoutData((Object)new GridData());
        label = new Label(composite1, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.agentAddressList = new List(composite1, 2564);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        data.verticalSpan = 7;
        data.widthHint = 200;
        data.heightHint = this.agentAddressList.getItemHeight() * 8;
        this.agentAddressList.select(0);
        this.agentAddressList.setLayoutData((Object)data);
        this.setButtonLayout(data, composite1);
        label = new Label(composite2, 0);
        label.setText("Node Name");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.nodeNameText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.nodeNameText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Ping");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pingPeriodText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.pingPeriodText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Node IPAddress");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.nodeIPAddressText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.nodeIPAddressText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Threshold(ms)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pingThresholdText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.pingThresholdText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Group");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.nodeGroupText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.nodeGroupText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Snmp");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Version");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpVersionCombo = new Combo(composite2, 12);
        this.snmpVersionCombo.add("V1");
        this.snmpVersionCombo.add("V2");
        this.snmpVersionCombo.add("V3");
        this.snmpVersionCombo.select(0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.snmpVersionCombo.setLayoutData((Object)gridData);
        this.setNodeKind(composite2);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.nodeKindCombo.setLayoutData((Object)gridData);
        this.nodeKindCombo.setVisibleItemCount(15);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 4;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Level");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpLevelCombo = new Combo(composite2, 12);
        this.snmpLevelCombo.add("No SNMP");
        this.snmpLevelCombo.add("SNMP Configration");
        this.snmpLevelCombo.add("SNMP ifOctets");
        this.snmpLevelCombo.add("SNMP laLoad");
        this.snmpLevelCombo.add("SNMP disk");
        this.snmpLevelCombo.select(0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.snmpLevelCombo.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpPeriodText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.snmpPeriodText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("RO Community");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpROCommunityText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.snmpROCommunityText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("RW Community");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.snmpRWCommunityText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.snmpRWCommunityText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Http");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.httpPeriodText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.httpPeriodText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("URL");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.httpUrlText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 400;
        this.httpUrlText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Port");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.httpPortText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.httpPortText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Timeout(msec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.httpTimeoutText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.httpTimeoutText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Pop3");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pop3PeriodText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.pop3PeriodText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("User");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pop3UserText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.pop3UserText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Password");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pop3PasswordText = new Text(composite2, 0x400800);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.pop3PasswordText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Port");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pop3PortText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.pop3PortText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Timeout(msec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.pop3TimeoutText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.pop3TimeoutText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("SMTP");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Period(sec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpPeriodText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.smtpPeriodText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Port");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpPortText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.smtpPortText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Timeout(msec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpTimeoutText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.smtpTimeoutText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Address (xxx@xxx)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpTestAddressText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.smtpTestAddressText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Smtp check Pop3 Host");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpCheckPop3HostText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.smtpCheckPop3HostText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Smtp check Pop3 User");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpCheckPop3UserText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.smtpCheckPop3UserText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Smtp check Pop3 Password");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpCheckPop3PasswordText = new Text(composite2, 0x400800);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.smtpCheckPop3PasswordText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Smtp check Pop3 Port");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpCheckPop3PortText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.smtpCheckPop3PortText.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Smtp check Pop3 Timeout(msec)");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.smtpCheckPop3TimeoutText = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.smtpCheckPop3TimeoutText.setLayoutData((Object)gridData);
        scrollComposite.setContent((Control)composite0);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.setTextDefaultNodeInfo();
        this.setAgentNodeList();
        if (this.targetNodeInfo != null && this.targetNodeInfo.getIpaddress() != null) {
            int i = 0;
            while (i < this.nodeInfoList.size()) {
                NodeInformation nodeInfo = (NodeInformation)this.nodeInfoList.get(i);
                if (this.targetNodeInfo.getIpaddress().equals(nodeInfo.getIpaddress())) {
                    this.agentAddressList.select(i);
                    nodeInfo = this.checkNode.checkNodeInfo(nodeInfo);
                    this.setTextNodeInfo(nodeInfo);
                } else if (this.targetNodeInfo != null && this.targetNodeInfo.getNodeKind() != null) {
                    nodeInfo = this.checkNode.checkNodeInfo(this.targetNodeInfo);
                    this.setTextNodeInfo(nodeInfo);
                }
                ++i;
            }
        }
        this.setButtonListener();
    }

    private void setButtonLayout(GridData data, Composite composite1) {
        this.loadAgentAddressListButton = new Button(composite1, 0);
        this.loadAgentAddressListButton.setText("Agent address list load");
        data = new GridData();
        data.horizontalSpan = 3;
        this.loadAgentAddressListButton.setLayoutData((Object)data);
        this.addButton = new Button(composite1, 0);
        this.addButton.setText("Node Add");
        data = new GridData();
        data.horizontalSpan = 3;
        this.addButton.setLayoutData((Object)data);
        this.editButton = new Button(composite1, 0);
        this.editButton.setText("Node Edit");
        data = new GridData();
        data.horizontalSpan = 3;
        this.editButton.setLayoutData((Object)data);
        this.deleteButton = new Button(composite1, 0);
        this.deleteButton.setText("Node Delete");
        data = new GridData();
        data.horizontalSpan = 3;
        this.deleteButton.setLayoutData((Object)data);
    }

    private void setButtonListener() {
        this.loadAgentAddressListButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorNodeOperation.this.loadAgentAddressListButton.setEnabled(false);
                EditorNodeOperation.this.addButton.setEnabled(false);
                EditorNodeOperation.this.editButton.setEnabled(false);
                EditorNodeOperation.this.deleteButton.setEnabled(false);
                try {
                    EditorNodeOperation.this.setAgentNodeList();
                }
                finally {
                    EditorNodeOperation.this.addButton.setEnabled(true);
                    EditorNodeOperation.this.editButton.setEnabled(true);
                    EditorNodeOperation.this.deleteButton.setEnabled(true);
                    EditorNodeOperation.this.loadAgentAddressListButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.agentAddressList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = EditorNodeOperation.this.agentAddressList.getSelectionIndex();
                if (index < 0) {
                    return;
                }
                NodeInformation nodeInfo = (NodeInformation)EditorNodeOperation.this.nodeInfoList.get(index);
                nodeInfo = EditorNodeOperation.this.checkNode.checkNodeInfo(nodeInfo);
                EditorNodeOperation.this.setTextNodeInfo(nodeInfo);
            }
        });
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorNodeOperation.this.addButton.setEnabled(false);
                EditorNodeOperation.this.editButton.setEnabled(false);
                EditorNodeOperation.this.deleteButton.setEnabled(false);
                EditorNodeOperation.this.loadAgentAddressListButton.setEnabled(false);
                EditorNodeOperation.this.addNode();
                EditorNodeOperation.this.addButton.setEnabled(true);
                EditorNodeOperation.this.editButton.setEnabled(true);
                EditorNodeOperation.this.deleteButton.setEnabled(true);
                EditorNodeOperation.this.loadAgentAddressListButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorNodeOperation.this.addButton.setEnabled(false);
                EditorNodeOperation.this.editButton.setEnabled(false);
                EditorNodeOperation.this.deleteButton.setEnabled(false);
                EditorNodeOperation.this.loadAgentAddressListButton.setEnabled(false);
                EditorNodeOperation.this.editNode();
                EditorNodeOperation.this.addButton.setEnabled(true);
                EditorNodeOperation.this.editButton.setEnabled(true);
                EditorNodeOperation.this.deleteButton.setEnabled(true);
                EditorNodeOperation.this.loadAgentAddressListButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EditorNodeOperation.this.addButton.setEnabled(false);
                EditorNodeOperation.this.editButton.setEnabled(false);
                EditorNodeOperation.this.deleteButton.setEnabled(false);
                EditorNodeOperation.this.loadAgentAddressListButton.setEnabled(false);
                EditorNodeOperation.this.deleteNode();
                EditorNodeOperation.this.addButton.setEnabled(true);
                EditorNodeOperation.this.editButton.setEnabled(true);
                EditorNodeOperation.this.deleteButton.setEnabled(true);
                EditorNodeOperation.this.loadAgentAddressListButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void setNodeKind(Composite composite2) {
        Label label = new Label(composite2, 0);
        label.setText("Node Kind");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.nodeKindCombo = new Combo(composite2, 12);
        HashMap nodeIconMap = MediaResource.getInstance().getIconDataList();
        for (String key : nodeIconMap.keySet()) {
            this.nodeKindCombo.add(key);
        }
        this.nodeKindCombo.select(0);
    }

    private void setTextDefaultNodeInfo() {
        this.nodeKindCombo.select(0);
        this.snmpVersionCombo.select(0);
        this.snmpLevelCombo.select(0);
        this.nodeGroupText.setText("Default Group");
        this.pingPeriodText.setText("0");
        this.pingThresholdText.setText("4000");
        this.snmpPeriodText.setText("0");
        this.snmpROCommunityText.setText("public");
        this.snmpRWCommunityText.setText("private");
        this.httpUrlText.setText("http://");
        this.httpPortText.setText("80");
        this.httpPeriodText.setText("0");
        this.httpTimeoutText.setText("180000");
        this.pop3PeriodText.setText("0");
        this.pop3PortText.setText("110");
        this.pop3TimeoutText.setText("120000");
        this.smtpPeriodText.setText("0");
        this.smtpPortText.setText("25");
        this.smtpTimeoutText.setText("120000");
        this.smtpCheckPop3PortText.setText("110");
        this.smtpCheckPop3TimeoutText.setText("120000");
    }

    private void addNode() {
        NodeInformation addNodeInfo;
        String addIPAddress = this.nodeIPAddressText.getText();
        try {
            InetAddress host = InetAddress.getByName(addIPAddress);
            addIPAddress = host.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"Error", (String)("UnknownHostException IP Address = " + addIPAddress));
            this.nodeIPAddressText.setFocus();
            return;
        }
        this.setAgentNodeList();
        if (addIPAddress == null || addIPAddress.equals("")) {
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"Error", (String)"Illegal IP Address");
            this.nodeIPAddressText.setFocus();
            return;
        }
        if (this.checkAddressList.containsKey(addIPAddress)) {
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"Error", (String)("Already IP Address = " + addIPAddress));
            this.nodeIPAddressText.setFocus();
            return;
        }
        int snmpVersion = this.snmpVersionCombo.getSelectionIndex();
        if (snmpVersion == 2 && SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(addIPAddress) == null) {
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"Error", (String)("Not found SNMP V3 Agent Address = " + addIPAddress));
            return;
        }
        int httpPeriod = 0;
        try {
            httpPeriod = Integer.parseInt(this.httpPeriodText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"Illegal Http period", (String)("Illegal Http period " + this.httpPeriodText.getText()));
            logger.warning("Illegal Http period " + this.httpPeriodText.getText());
            this.httpPeriodText.setFocus();
            return;
        }
        if (httpPeriod > 0) {
            try {
                URL accessURL = new URL(this.httpUrlText.getText());
                if (accessURL.getHost() == null || accessURL.getHost().equals("") || accessURL.getProtocol() == null || accessURL.getProtocol().equals("")) {
                    MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"Illegal URL", (String)("Illegal URL   host=" + accessURL.getHost() + "  protocol=" + accessURL.getProtocol()));
                    logger.warning("Illegal URL    host=" + accessURL.getHost() + "  protocol=" + accessURL.getProtocol());
                    this.httpUrlText.setFocus();
                    return;
                }
            }
            catch (MalformedURLException e1) {
                MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"Illegal URL", (String)(String.valueOf(e1.getMessage()) + " " + this.httpUrlText.getText()));
                logger.warning("Illegal URL " + e1.getMessage() + " " + this.httpUrlText.getText());
                this.httpUrlText.setFocus();
                return;
            }
        }
        if ((addNodeInfo = this.createNodeInfo()) == null) {
            return;
        }
        if (!this.isSocket) {
            NodeAdd nodeAddInstance = NodeAdd.getInstance();
            nodeAddInstance.addNode(addNodeInfo, true);
        } else {
            String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            ConnectionNodeControl threadstop = new ConnectionNodeControl(engineAddress);
            try {
                String responseCode = threadstop.requestThread(addIPAddress, "Thread Start", addNodeInfo);
                responseCode.equals("ACK");
            }
            catch (EngineConnectException e1) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e1.getMessage() + " Engine=" + engineAddress));
                shell.dispose();
                return;
            }
            catch (IOException e1) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e1.getMessage() + " Engine=" + engineAddress));
                shell.dispose();
                return;
            }
        }
        this.setAgentNodeList();
        this.setTextDefaultNodeInfo();
    }

    private void editNode() {
        String addIPAddress = this.nodeIPAddressText.getText();
        if (addIPAddress == null || addIPAddress.equals("")) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"Illegal IP Address");
            shell.dispose();
            return;
        }
        if (!this.checkAddressList.containsKey(addIPAddress)) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)("Not found IP Address = " + addIPAddress));
            shell.dispose();
            return;
        }
        NodeInformation addNodeInfo = this.createNodeInfo();
        if (addNodeInfo == null) {
            return;
        }
        NodeInformation checkNodeInfo = this.getNodeInfo(addIPAddress);
        if (checkNodeInfo != null) {
            addNodeInfo.setNodeX(checkNodeInfo.getNodeX());
            addNodeInfo.setNodeY(checkNodeInfo.getNodeY());
        }
        if (!this.isSocket) {
            NodeEdit editNodeInstance = NodeEdit.getInstance();
            try {
                editNodeInstance.editNodeInfo(addNodeInfo);
            }
            catch (DatabaseConnectionException e1) {
                MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"Abort edit Node", (String)e1.getMessage());
                logger.warning("Abort edit Node " + e1.getMessage());
                return;
            }
            catch (SQLException e1) {
                MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"Abort edit Node", (String)e1.getMessage());
                logger.warning("Abort edit Node " + e1.getMessage());
                return;
            }
        }
        String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
        ConnectionNodeControl threadstop = new ConnectionNodeControl(engineAddress);
        try {
            threadstop.requestThread(addIPAddress, "Thread Restart", addNodeInfo);
        }
        catch (EngineConnectException e1) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e1.getMessage() + " Engine=" + engineAddress));
            shell.dispose();
            return;
        }
        catch (IOException e1) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e1.getMessage() + " Engine=" + engineAddress));
            shell.dispose();
            return;
        }
        this.setAgentNodeList();
    }

    private void deleteNode() {
        String addIPAddress = this.nodeIPAddressText.getText();
        if (addIPAddress == null || addIPAddress.equals("")) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"Illegal IP Address");
            this.deleteButton.setEnabled(true);
            shell.dispose();
            return;
        }
        if (!this.checkAddressList.containsKey(addIPAddress)) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)("Not found IP Address = " + addIPAddress));
            this.deleteButton.setEnabled(true);
            shell.dispose();
            return;
        }
        if (!this.isSocket) {
            NodeDelete del = NodeDelete.getInstance();
            del.removeThreadList(addIPAddress);
        } else {
            String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            ConnectionNodeControl threadstop = new ConnectionNodeControl(engineAddress);
            try {
                threadstop.requestThread(addIPAddress, "Thread Stop", null);
            }
            catch (EngineConnectException e1) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e1.getMessage() + " Engine=" + engineAddress));
                this.deleteButton.setEnabled(true);
                shell.dispose();
                return;
            }
            catch (IOException e1) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("Engine connect error " + e1.getMessage() + " Engine=" + engineAddress));
                this.deleteButton.setEnabled(true);
                shell.dispose();
                return;
            }
        }
        this.setAgentNodeList();
    }

    private void setAgentNodeList() {
        this.agentAddressList.removeAll();
        if (this.nodeInfoList != null) {
            this.nodeInfoList.clear();
        }
        this.checkAddressList.clear();
        this.nodeInfoList = this.getNodeList();
        if (this.nodeInfoList == null) {
            return;
        }
        int i = 0;
        while (i < this.nodeInfoList.size()) {
            NodeInformation nodeInfo = (NodeInformation)this.nodeInfoList.get(i);
            this.agentAddressList.add(String.valueOf(nodeInfo.getNodename()) + " : " + nodeInfo.getIpaddress());
            this.checkAddressList.put(nodeInfo.getIpaddress(), nodeInfo);
            ++i;
        }
    }

    private NodeInformation createNodeInfo() {
        NodeInformation workNodeInfo = new NodeInformation();
        if (!this.showErrorDialog(this.pingPeriodText, 60)) {
            return null;
        }
        workNodeInfo.setPingPeriod(this.pingPeriodText.getText());
        if (!this.showErrorDialog(this.pingThresholdText, 20)) {
            return null;
        }
        workNodeInfo.setPingThreshold(this.pingThresholdText.getText());
        if (!this.showErrorDialog(this.snmpPeriodText, 60)) {
            return null;
        }
        workNodeInfo.setSnmpPeriod(this.snmpPeriodText.getText());
        if (!this.showErrorDialog(this.httpPeriodText, 60)) {
            return null;
        }
        workNodeInfo.setHttpPeriod(this.httpPeriodText.getText());
        if (!this.showErrorDialog(this.httpTimeoutText, 60)) {
            return null;
        }
        workNodeInfo.setHttpTimeout(this.httpTimeoutText.getText());
        if (!this.showErrorDialog(this.pop3PeriodText, 60)) {
            return null;
        }
        workNodeInfo.setPopPeriod(this.pop3PeriodText.getText());
        if (!this.showErrorDialog(this.pop3PortText, 0)) {
            return null;
        }
        workNodeInfo.setPopPort(this.pop3PortText.getText());
        if (!this.showErrorDialog(this.pop3TimeoutText, 60)) {
            return null;
        }
        workNodeInfo.setPopTimeout(this.pop3TimeoutText.getText());
        if (!this.showErrorDialog(this.smtpPeriodText, 60)) {
            return null;
        }
        workNodeInfo.setSmtpPeriod(this.smtpPeriodText.getText());
        if (!this.showErrorDialog(this.smtpPortText, 0)) {
            return null;
        }
        workNodeInfo.setSmtpPort(this.smtpPortText.getText());
        if (!this.showErrorDialog(this.smtpTimeoutText, 60)) {
            return null;
        }
        workNodeInfo.setSmtpTimeout(this.smtpTimeoutText.getText());
        if (!this.showErrorDialog(this.smtpCheckPop3PortText, 0)) {
            return null;
        }
        workNodeInfo.setSmtpCheckPort(this.smtpCheckPop3PortText.getText());
        if (!this.showErrorDialog(this.smtpCheckPop3TimeoutText, 60)) {
            return null;
        }
        workNodeInfo.setSmtpCheckTimeout(this.smtpCheckPop3TimeoutText.getText());
        workNodeInfo.setPopUser(this.pop3UserText.getText());
        workNodeInfo.setPopPassword(this.pop3PasswordText.getText());
        workNodeInfo.setSmtpSendAddress(this.smtpTestAddressText.getText());
        workNodeInfo.setSmtpCheckHost(this.smtpCheckPop3HostText.getText());
        workNodeInfo.setSmtpCheckUser(this.smtpCheckPop3UserText.getText());
        workNodeInfo.setSmtpCheckPassword(this.smtpCheckPop3PasswordText.getText());
        workNodeInfo.setHttpUrl(this.httpUrlText.getText());
        if (!this.showErrorDialog(this.httpPortText, 0)) {
            return null;
        }
        workNodeInfo.setHttpPort(this.httpPortText.getText());
        String nodeName = null;
        try {
            InetAddress host = InetAddress.getByName(this.nodeIPAddressText.getText());
            String addIPAddress = host.getHostAddress();
            workNodeInfo.setIpaddress(addIPAddress);
            nodeName = host.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"UnknownHostException");
            shell.dispose();
            this.nodeIPAddressText.setFocus();
            return null;
        }
        if (this.nodeNameText.getText().equals("")) {
            workNodeInfo.setNodename(nodeName);
        } else {
            workNodeInfo.setNodename(this.nodeNameText.getText());
        }
        String engineAddress = "localhost";
        try {
            engineAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.warning(e.getMessage());
        }
        workNodeInfo.setEngineAddress(engineAddress);
        workNodeInfo.setGroup(this.nodeGroupText.getText());
        workNodeInfo.setNodeKind(this.nodeKindCombo.getText());
        workNodeInfo.setRoCommunity(this.snmpROCommunityText.getText());
        workNodeInfo.setRwCommunity(this.snmpRWCommunityText.getText());
        int snmpVersion = this.snmpVersionCombo.getSelectionIndex();
        switch (snmpVersion) {
            case 0: {
                workNodeInfo.setSnmpVersion("SNMPV1");
                break;
            }
            case 1: {
                workNodeInfo.setSnmpVersion("SNMPV2C");
                break;
            }
            case 2: {
                workNodeInfo.setSnmpVersion("SNMPV3");
                break;
            }
            default: {
                logger.warning("Illegal SNMP Version " + snmpVersion);
                workNodeInfo.setSnmpVersion("SNMPV1");
            }
        }
        String snmpLevel = this.snmpLevelCombo.getText();
        if (snmpLevel.equals("No SNMP")) {
            workNodeInfo.setSnmpLevel("0");
        } else if (snmpLevel.equals("SNMP Configration")) {
            workNodeInfo.setSnmpLevel("1");
        } else if (snmpLevel.equals("SNMP ifOctets")) {
            workNodeInfo.setSnmpLevel("2");
        } else if (snmpLevel.equals("SNMP laLoad")) {
            workNodeInfo.setSnmpLevel("3");
        } else if (snmpLevel.equals("SNMP disk")) {
            workNodeInfo.setSnmpLevel("4");
        } else {
            workNodeInfo.setSnmpLevel("0");
        }
        if (this.targetNodeInfo.getNodeX() != null && !this.targetNodeInfo.getNodeX().equals("")) {
            workNodeInfo.setNodeX(this.targetNodeInfo.getNodeX());
        }
        if (this.targetNodeInfo.getNodeY() != null && !this.targetNodeInfo.getNodeY().equals("")) {
            workNodeInfo.setNodeY(this.targetNodeInfo.getNodeY());
        }
        return workNodeInfo;
    }

    private boolean showErrorDialog(Text checkText, int limitData) {
        int checkData;
        block5: {
            try {
                checkData = Integer.parseInt(checkText.getText());
                if (limitData != 0 && checkData != 0) break block5;
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Input error");
                checkText.setFocus();
                shell.dispose();
                return false;
            }
        }
        if (limitData > checkData) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)("Input error. Please " + checkData + " >= " + limitData));
            checkText.setFocus();
            shell.dispose();
            return false;
        }
        return true;
    }

    private void setTextNodeInfo(NodeInformation refreshNodeInfo) {
        this.nodeNameText.setText(refreshNodeInfo.getNodename());
        this.nodeIPAddressText.setText(refreshNodeInfo.getIpaddress());
        this.nodeGroupText.setText(refreshNodeInfo.getGroup());
        if (refreshNodeInfo.getNodeKind() != null) {
            this.nodeKindCombo.setText(refreshNodeInfo.getNodeKind());
        }
        if (refreshNodeInfo.getPingPeriod() != null) {
            this.pingPeriodText.setText(refreshNodeInfo.getPingPeriod());
        }
        if (refreshNodeInfo.getPingThreshold() != null) {
            this.pingThresholdText.setText(refreshNodeInfo.getPingThreshold());
        }
        if (refreshNodeInfo.getSnmpVersion() != null) {
            if (refreshNodeInfo.getSnmpVersion().equals("SNMPV1")) {
                this.snmpVersionCombo.select(0);
            } else if (refreshNodeInfo.getSnmpVersion().equals("SNMPV2C")) {
                this.snmpVersionCombo.select(1);
            } else if (refreshNodeInfo.getSnmpVersion().equals("SNMPV3")) {
                this.snmpVersionCombo.select(2);
            }
        }
        if (refreshNodeInfo.getSnmpLevel() != null) {
            if (refreshNodeInfo.getSnmpLevel().equals("0")) {
                this.snmpLevelCombo.select(0);
            } else if (refreshNodeInfo.getSnmpLevel().equals("1")) {
                this.snmpLevelCombo.select(1);
            } else if (refreshNodeInfo.getSnmpLevel().equals("2")) {
                this.snmpLevelCombo.select(2);
            } else if (refreshNodeInfo.getSnmpLevel().equals("3")) {
                this.snmpLevelCombo.select(3);
            } else if (refreshNodeInfo.getSnmpLevel().equals("4")) {
                this.snmpLevelCombo.select(4);
            }
        }
        if (refreshNodeInfo.getSnmpPeriod() != null) {
            this.snmpPeriodText.setText(refreshNodeInfo.getSnmpPeriod());
        }
        if (refreshNodeInfo.getRoCommunity() != null) {
            this.snmpROCommunityText.setText(refreshNodeInfo.getRoCommunity());
        }
        if (refreshNodeInfo.getRwCommunity() != null) {
            this.snmpRWCommunityText.setText(refreshNodeInfo.getRwCommunity());
        }
        if (refreshNodeInfo.getHttpUrl() != null) {
            this.httpUrlText.setText(refreshNodeInfo.getHttpUrl());
        }
        if (refreshNodeInfo.getHttpPort() != null) {
            this.httpPortText.setText(refreshNodeInfo.getHttpPort());
        }
        if (refreshNodeInfo.getHttpPeriod() != null) {
            this.httpPeriodText.setText(refreshNodeInfo.getHttpPeriod());
        }
        if (refreshNodeInfo.getHttpTimeout() != null) {
            this.httpTimeoutText.setText(refreshNodeInfo.getHttpTimeout());
        }
        if (refreshNodeInfo.getPopPeriod() != null) {
            this.pop3PeriodText.setText(refreshNodeInfo.getPopPeriod());
        }
        if (refreshNodeInfo.getPopUser() != null) {
            this.pop3UserText.setText(refreshNodeInfo.getPopUser());
        }
        if (refreshNodeInfo.getPopPassword() != null) {
            this.pop3PasswordText.setText(refreshNodeInfo.getPopPassword());
        }
        if (refreshNodeInfo.getPopPort() != null) {
            this.pop3PortText.setText(refreshNodeInfo.getPopPort());
        }
        if (refreshNodeInfo.getPopTimeout() != null) {
            this.pop3TimeoutText.setText(refreshNodeInfo.getPopTimeout());
        }
        if (refreshNodeInfo.getSmtpPeriod() != null) {
            this.smtpPeriodText.setText(refreshNodeInfo.getSmtpPeriod());
        }
        if (refreshNodeInfo.getSmtpPort() != null) {
            this.smtpPortText.setText(refreshNodeInfo.getSmtpPort());
        }
        if (refreshNodeInfo.getSmtpTimeout() != null) {
            this.smtpTimeoutText.setText(refreshNodeInfo.getSmtpTimeout());
        }
        if (refreshNodeInfo.getSmtpSendAddress() != null) {
            this.smtpTestAddressText.setText(refreshNodeInfo.getSmtpSendAddress());
        }
        if (refreshNodeInfo.getSmtpCheckHost() != null) {
            this.smtpCheckPop3HostText.setText(refreshNodeInfo.getSmtpCheckHost());
        }
        if (refreshNodeInfo.getSmtpCheckUser() != null) {
            this.smtpCheckPop3UserText.setText(refreshNodeInfo.getSmtpCheckUser());
        }
        if (refreshNodeInfo.getSmtpCheckPassword() != null) {
            this.smtpCheckPop3PasswordText.setText(refreshNodeInfo.getSmtpCheckPassword());
        }
        if (refreshNodeInfo.getSmtpCheckPort() != null) {
            this.smtpCheckPop3PortText.setText(refreshNodeInfo.getSmtpCheckPort());
        }
        if (refreshNodeInfo.getSmtpCheckTimeout() != null) {
            this.smtpCheckPop3TimeoutText.setText(refreshNodeInfo.getSmtpCheckTimeout());
        }
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }

    public void setFocus() {
    }

    private ArrayList getNodeList() {
        ArrayList nodeList = null;
        try {
            if (!this.isSocket) {
                DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister.getInstance();
                nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);
            } else {
                String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
                ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(engineAddress);
                nodeList = connectNodeInfo.getNodeInformationList(null, null);
            }
        }
        catch (SQLException e1) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e1.getMessage());
            logger.warning("Node List import error " + e1.getMessage());
            e1.printStackTrace();
            shell.dispose();
        }
        catch (Exception e1) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e1.getMessage());
            logger.warning("Node List import error " + e1.getMessage());
            e1.printStackTrace();
            shell.dispose();
        }
        return nodeList;
    }

    private NodeInformation getNodeInfo(String ipAddress) {
        NodeInformation nodeInfo = null;
        try {
            if (!this.isSocket) {
                DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister.getInstance();
                ArrayList nodeList = nodeRegisterDBTable.findTarget(ipAddress);
                if (nodeList.size() > 0) {
                    nodeInfo = (NodeInformation)nodeList.get(0);
                }
            } else {
                String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
                ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(engineAddress);
                nodeInfo = connectNodeInfo.getNodeInformation(ipAddress);
            }
        }
        catch (SQLException e1) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e1.getMessage());
            logger.warning("Node List import error " + e1.getMessage());
            e1.printStackTrace();
            shell.dispose();
        }
        catch (Exception e1) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)e1.getMessage());
            logger.warning("Node List import error " + e1.getMessage());
            e1.printStackTrace();
            shell.dispose();
        }
        return nodeInfo;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

