/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.messageformat;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;

public class SnmpReportPDU
extends SnmpSequence {
    public static final int PDU_REQUEST_ID_POS = 0;
    public static final int PDU_ERROR_STATUS_POS = 1;
    public static final int PDU_ERROR_INDEX_POS = 2;
    public static final int PDU_VARLIST_POS = 3;

    public SnmpReportPDU(int requestID, int errorStatus, int errorIndex, SnmpSequence varList) throws SnmpBadValueException {
        this.tag = (byte)-88;
        List<AbstractSnmpObject> contents = Collections.synchronizedList(new ArrayList());
        contents.add(0, new SnmpInteger(requestID));
        contents.add(1, new SnmpInteger(errorStatus));
        contents.add(2, new SnmpInteger(errorIndex));
        contents.add(3, varList);
        this.setValue(contents);
    }

    public SnmpReportPDU(byte[] enc) throws SnmpBadValueException {
        this.tag = (byte)-88;
        this.extractFromBEREncoding(enc);
    }

    public SnmpSequence getVarBindList() {
        List contents = (List)this.getValue();
        return (SnmpSequence)contents.get(3);
    }

    public int getRequestID() {
        List contents = (List)this.getValue();
        return ((BigInteger)((SnmpInteger)contents.get(0)).getValue()).intValue();
    }

    public int getErrorStatus() {
        List contents = (List)this.getValue();
        return ((BigInteger)((SnmpInteger)contents.get(1)).getValue()).intValue();
    }

    public int getErrorIndex() {
        List contents = (List)this.getValue();
        return ((BigInteger)((SnmpInteger)contents.get(2)).getValue()).intValue();
    }
}

