/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.integer;

import java.math.BigInteger;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;

public class SnmpCounter32
extends SnmpInteger {
    private static final BigInteger MAX_VALUE = new BigInteger("4294967295");

    public SnmpCounter32() {
        this(0L);
        this.tag = (byte)65;
        this.tagDescription = "COUNTER32";
    }

    public SnmpCounter32(long newValue) {
        this.integerValue = new BigInteger(Long.toString(newValue));
        this.integerValue = this.integerValue.mod(MAX_VALUE);
        this.tag = (byte)65;
        this.tagDescription = "COUNTER32";
    }

    public SnmpCounter32(byte[] enc) throws SnmpBadValueException {
        this.extractValueFromBEREncoding(enc);
        this.integerValue = this.integerValue.mod(MAX_VALUE);
        this.tag = (byte)65;
        this.tagDescription = "COUNTER32";
    }

    public void setValue(Object newValue) throws SnmpBadValueException {
        if (newValue instanceof BigInteger) {
            this.integerValue = (BigInteger)newValue;
            this.integerValue = this.integerValue.mod(MAX_VALUE);
        } else if (newValue instanceof Integer) {
            this.integerValue = new BigInteger(newValue.toString());
            this.integerValue = this.integerValue.mod(MAX_VALUE);
        } else if (newValue instanceof String) {
            try {
                this.integerValue = new BigInteger((String)newValue);
                this.integerValue = this.integerValue.mod(MAX_VALUE);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SnmpBadValueException(" Counter32: bad object supplied to set value ");
            }
        } else {
            throw new SnmpBadValueException(" Counter32: bad object supplied to set value ");
        }
    }
}

