/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.integer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;

public class SnmpInteger
extends AbstractSnmpObject {
    protected BigInteger integerValue;

    public SnmpInteger() {
        this(0L);
        this.tag = (byte)2;
        this.tagDescription = "INTEGER";
    }

    public SnmpInteger(long newValue) {
        this.integerValue = new BigInteger(Long.toString(newValue));
        this.tag = (byte)2;
        this.tagDescription = "INTEGER";
    }

    public SnmpInteger(byte[] enc) throws SnmpBadValueException {
        this.extractValueFromBEREncoding(enc);
        this.tag = (byte)2;
        this.tagDescription = "INTEGER";
    }

    public Object getValue() {
        return this.integerValue;
    }

    public void setValue(Object newValue) throws SnmpBadValueException {
        if (newValue instanceof BigInteger) {
            this.integerValue = (BigInteger)newValue;
        } else if (newValue instanceof Integer) {
            this.integerValue = new BigInteger(((Integer)newValue).toString());
        } else if (newValue instanceof String) {
            try {
                this.integerValue = new BigInteger((String)newValue);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SnmpBadValueException(" Integer: bad object supplied to set value ");
            }
        } else {
            throw new SnmpBadValueException(" Integer: bad object supplied to set value ");
        }
    }

    public byte[] getBEREncoding() {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        byte[] outBytesArray = null;
        try {
            byte[] data = this.integerValue.toByteArray();
            byte[] len = this.encodeLength(data.length);
            outBytes.write(this.tag);
            outBytes.write(len, 0, len.length);
            outBytes.write(data, 0, data.length);
            outBytesArray = outBytes.toByteArray();
        }
        finally {
            try {
                outBytes.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return outBytesArray;
    }

    public void extractValueFromBEREncoding(byte[] enc) throws SnmpBadValueException {
        try {
            this.integerValue = new BigInteger(enc);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SnmpBadValueException(" Integer: bad BER encoding supplied to set value ");
        }
    }

    public String toString() {
        return this.integerValue.toString();
    }
}

