/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent.model;

import java.util.HashMap;
import java.util.List;
import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.snmp.mibtree.AgentMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmpagent.AgentDataEditorView;
import netjfwatcher.snmpagent.AgentInstanceControlOperationView;
import netjfwatcher.snmpagent.AgentTrapSendView;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class AgentTableListener
extends SelectionAdapter {
    private Table table;
    private String selectNo;
    private String selectOidDescription;
    private String selectOid;
    private String selectValue;
    private String selectType;
    private String selectAccess;

    public AgentTableListener(Table table) {
        this.table = table;
    }

    public void widgetSelected(SelectionEvent event) {
        int index = this.table.getSelectionIndex();
        if (index == -1) {
            return;
        }
        this.table.setSelection(new int[0]);
        TableItem item = this.table.getItem(index);
        this.selectNo = item.getText(0);
        this.selectOidDescription = item.getText(1);
        this.selectOid = item.getText(2);
        this.selectValue = item.getText(3);
        this.selectType = item.getText(4);
        this.selectAccess = item.getText(5);
        this.setEditorView();
        AgentInstanceControlOperationView view = NetJFWatcherApplication.getAgentInstanceControlOperationView();
        if (view != null) {
            view.getDescriptionText().setText(this.selectOidDescription);
            view.getOidText().setText(this.selectOid);
            view.getValueText().setText(this.selectValue);
            view.getTypeText().setText(this.selectType);
            view.getAccessText().setText(this.selectAccess);
        }
        this.setTrapSendView();
    }

    private void setEditorView() {
        AgentDataEditorView editorView = NetJFWatcherApplication.getAgentDataEditorView();
        if (editorView != null) {
            editorView.getNoText().setText(this.selectNo);
            editorView.getOidDescriptionText().setText(this.selectOidDescription);
            editorView.getOidText().setText(this.selectOid);
            editorView.getTypeText().setText(this.selectType);
            editorView.getAccessText().setText(this.selectAccess);
            if (this.selectType.equals("TimeTicks")) {
                MibInfo miboid;
                AgentMibTree mibtable = AgentMibTree.getInstance();
                HashMap oidMap = mibtable.getOidHashMap();
                if (oidMap.containsKey(this.selectOid) && (miboid = (MibInfo)oidMap.get(this.selectOid)) != null) {
                    AbstractSnmpObject timeTicksObject = ((MibInfo)oidMap.get(this.selectOid)).getAgentMibValue();
                    editorView.getValueText().setText(timeTicksObject.getValue().toString());
                }
            } else {
                editorView.getValueText().setText(this.selectValue);
            }
        }
    }

    private void setTrapSendView() {
        AgentTrapSendView trapView = NetJFWatcherApplication.getAgentTrapSendView();
        trapView.getAdditionalVariableOIDText().setText(this.selectOid);
        trapView.getAdditionalVariableOIDDiscriprionText().setText(this.selectOidDescription);
        trapView.getValueAdditionalVariableText().setText(this.selectValue);
        trapView.getSnmpTrapOIDValueComboBox().remove(0);
        trapView.getSnmpTrapOIDValueComboBox().add(String.valueOf(this.selectOidDescription) + "(" + this.selectOid + ")", 0);
        trapView.getSnmpTrapOIDValueComboBox().select(0);
        List snmpTrapOidValueOidList = trapView.getSnmpTrapOidValueList();
        snmpTrapOidValueOidList.remove(0);
        snmpTrapOidValueOidList.add(0, this.selectOid);
        trapView.setSnmpTrapOidValueList(snmpTrapOidValueOidList);
        if (this.selectType.equals("INTEGER")) {
            trapView.getSnmpValueTypeCombo().setText("INTEGER");
        } else if (this.selectType.equals("Counter32")) {
            trapView.getSnmpValueTypeCombo().setText("COUNTER32");
        } else if (this.selectType.equals("Counter64")) {
            trapView.getSnmpValueTypeCombo().setText("COUNTER64");
        } else if (this.selectType.equals("Gauge32")) {
            trapView.getSnmpValueTypeCombo().setText("GAUGE32");
        } else if (this.selectType.equals("OctetString")) {
            trapView.getSnmpValueTypeCombo().setText("OCTETSTRING");
        } else if (this.selectType.equals("IpAddress")) {
            trapView.getSnmpValueTypeCombo().setText("IPADDRESS");
        } else if (this.selectType.equals("ObjectID")) {
            trapView.getSnmpValueTypeCombo().setText("OBJECTIDENTIFIER");
        } else if (this.selectType.equals("TimeTicks")) {
            trapView.getSnmpValueTypeCombo().setText("TIMETICKS");
        } else if (this.selectType.equals("Uinteger32")) {
            trapView.getSnmpValueTypeCombo().setText("INTEGER32");
        } else if (this.selectType.equals("Bits")) {
            trapView.getSnmpValueTypeCombo().setText("BITSTRING");
        } else if (this.selectType.equals("Opaque")) {
            trapView.getSnmpValueTypeCombo().setText("OPAQUE");
        } else if (this.selectType.equals("DisplayString")) {
            trapView.getSnmpValueTypeCombo().setText("OCTETSTRING");
        }
    }
}

