/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent.process;

import java.util.logging.Logger;
import netjfwatcher.engine.model.action.EngineStatus;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpMappingTableController;
import netjfwatcher.snmp.messageformat.SnmpTrap2PDU;
import netjfwatcher.snmp.messageformat.SnmpTrapPDU;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.messageformat.SnmpVariablePair;
import netjfwatcher.snmp.snmpobject.integer.SnmpTimeTicks;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpIPAddress;
import netjfwatcher.snmpagent.process.ThreadAgent;

public final class AgentTrapPDU {
    private static Logger logger;

    private AgentTrapPDU() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public SnmpTrapPDU createV1TrapPDU(String agentIPAddressString, String enterpriseOIDString, int genericTrap, int specificTrap, String additionalVariableOID, String valueString, String valueTypeString, boolean isSetAgentTime) throws SnmpBadValueException {
        SnmpIPAddress agentAddress;
        SnmpObjectIdentifier enterpriseOID;
        SnmpTrapPDU pdu = null;
        try {
            enterpriseOID = new SnmpObjectIdentifier(enterpriseOIDString);
        }
        catch (SnmpBadValueException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            throw e1;
        }
        try {
            agentAddress = new SnmpIPAddress(agentIPAddressString);
        }
        catch (SnmpBadValueException e2) {
            logger.warning(e2.getMessage());
            e2.printStackTrace();
            throw e2;
        }
        long agentStartTime = isSetAgentTime ? (System.currentTimeMillis() - ThreadAgent.getInstance().getStartSnmpAgentEngineTime()) / 10L : (System.currentTimeMillis() - EngineStatus.getInstance().getStartEngineTime()) / 10L;
        SnmpTimeTicks timeStamp = new SnmpTimeTicks(agentStartTime);
        SnmpVarBindList varBindList = new SnmpVarBindList();
        if (!additionalVariableOID.equals("")) {
            try {
                SnmpObjectIdentifier itemID = new SnmpObjectIdentifier(additionalVariableOID);
                AbstractSnmpObject itemValue = SnmpMappingTableController.getInstance().getSnmpObjectInstance(valueTypeString);
                itemValue.setValue(valueString);
                varBindList.addSNMPObject(new SnmpVariablePair(itemID, itemValue));
            }
            catch (SnmpBadValueException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
        try {
            pdu = new SnmpTrapPDU(enterpriseOID, agentAddress, genericTrap, specificTrap, timeStamp, varBindList);
        }
        catch (SnmpBadValueException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        return pdu;
    }

    public SnmpTrap2PDU createV2Trap2PDU(String snmpTrapOidValue, String additionalVariableOID, String valueString, String valueTypeString) throws SnmpBadValueException {
        long agentStartTime = (System.currentTimeMillis() - ThreadAgent.getInstance().getStartSnmpAgentEngineTime()) / 10L;
        SnmpObjectIdentifier varBindOid = new SnmpObjectIdentifier(additionalVariableOID);
        AbstractSnmpObject itemValue = SnmpMappingTableController.getInstance().getSnmpObjectInstance(valueTypeString);
        itemValue.setValue(valueString);
        SnmpVariablePair variablePair = new SnmpVariablePair(varBindOid, itemValue);
        SnmpTrap2PDU pdu = null;
        pdu = new SnmpTrap2PDU(agentStartTime, snmpTrapOidValue, variablePair);
        return pdu;
    }

    public SnmpTrap2PDU createV3Trap2PDU(String snmpTrapOidValue, String additionalVariableOID, String valueString, String valueTypeString) throws SnmpBadValueException {
        long agentStartTime = (System.currentTimeMillis() - ThreadAgent.getInstance().getStartSnmpAgentEngineTime()) / 10L;
        SnmpObjectIdentifier varBindOid = new SnmpObjectIdentifier(additionalVariableOID);
        AbstractSnmpObject itemValue = SnmpMappingTableController.getInstance().getSnmpObjectInstance(valueTypeString);
        itemValue.setValue(valueString);
        SnmpVariablePair variablePair = new SnmpVariablePair(varBindOid, itemValue);
        SnmpTrap2PDU pdu = new SnmpTrap2PDU(agentStartTime, snmpTrapOidValue, variablePair);
        return pdu;
    }

    public static AgentTrapPDU getInstance() {
        return SingletonResource.TRAP_PDU_INSTANCE;
    }

    /* synthetic */ AgentTrapPDU(AgentTrapPDU agentTrapPDU) {
        this();
    }

    private static class SingletonResource {
        static final AgentTrapPDU TRAP_PDU_INSTANCE = new AgentTrapPDU(null);

        private SingletonResource() {
        }
    }
}

