/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager.preferences;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.snmpmanager.preferences.AbstractSnmpPreferencePage;
import netjfwatcher.snmpmanager.trap.EnterpriseOIDConfig;
import netjfwatcher.snmpmanager.trap.EnterpriseOIDInfo;
import netjfwatcher.snmpmanager.trap.TrapForwardResourceFileParse;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.jdom.Document;

public class SnmpTrapForwardPreferencePage
extends AbstractSnmpPreferencePage {
    private static final int TEXT_WIDTH = 200;
    private static final int AGENT_LIST_VERTICAL_SPAN = 11;
    private static final int AGENT_LIST_HEIGHT_HINT = 5;
    private static final int WIDE_TEXT_WIDTH = 250;
    private static final int COMBO_VISIBLE_ITEM_COUNT = 15;
    private static final int HORIZONTAL_SPAN2 = 2;
    private static final int HORIZONTAL_SPAN3 = 3;
    private static final int LIS_WIDTH = 200;
    private Button trapForwardButton;
    private Text destinationAddressText;
    private List enterprisesOIDList = null;
    private Combo enterpriseOidCombo;
    private Text removeOIDText;
    private Button addOIDButton;
    private Button removeOIDButton;
    private Map enterpriseOidInfoMap;
    private ArrayList<String> workEnterpriseOidList;
    private HashMap<String, EnterpriseOIDInfo> filetrEnterpriseOidMap;
    private static Logger logger;

    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.workEnterpriseOidList = new ArrayList();
        this.filetrEnterpriseOidMap = new HashMap();
        this.enterpriseOidInfoMap = EnterpriseOIDConfig.getInstance().getEnterpriseOidHashMap();
    }

    protected Control createContents(Composite parent) {
        this.textBackColor = Display.getCurrent().getSystemColor(1);
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridData gridData = null;
        Composite compositeEnterpriseOid = new Composite(parent, 0);
        GridLayout gridLayoutV3AgentProp = new GridLayout(3, false);
        compositeEnterpriseOid.setLayout((Layout)gridLayoutV3AgentProp);
        compositeEnterpriseOid.setLayoutData((Object)new GridData(256));
        this.trapForwardButton = new Button(compositeEnterpriseOid, 32);
        this.trapForwardButton.setText("Trap Forward");
        Label label = new Label(compositeEnterpriseOid, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(compositeEnterpriseOid, 0);
        label.setText("Destination Address");
        label.setLayoutData((Object)new GridData());
        this.destinationAddressText = new Text(compositeEnterpriseOid, 2048);
        this.destinationAddressText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.destinationAddressText.setBackground(this.textBackColor);
        this.destinationAddressText.setLayoutData((Object)gridData);
        label = new Label(compositeEnterpriseOid, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(compositeEnterpriseOid, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(compositeEnterpriseOid, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(compositeEnterpriseOid, 0);
        label.setText("Effective Enterprises OID");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.enterprisesOIDList = new List(compositeEnterpriseOid, 2052);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.verticalSpan = 11;
        data.widthHint = 200;
        data.heightHint = this.enterprisesOIDList.getItemHeight() * 5;
        this.enterprisesOIDList.setLayoutData((Object)data);
        label = new Label(compositeEnterpriseOid, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 10;
        label.setLayoutData((Object)gridData);
        this.enterpriseOidCombo = new Combo(compositeEnterpriseOid, 4);
        for (String keyOid : this.enterpriseOidInfoMap.keySet()) {
            EnterpriseOIDInfo info = (EnterpriseOIDInfo)this.enterpriseOidInfoMap.get(keyOid);
            this.enterpriseOidCombo.add(String.valueOf(keyOid) + "     (" + info.getCompany() + ")");
            this.workEnterpriseOidList.add(keyOid);
        }
        this.enterpriseOidCombo.select(0);
        gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        gridData.widthHint = 250;
        this.enterpriseOidCombo.setLayoutData((Object)gridData);
        this.enterpriseOidCombo.setVisibleItemCount(15);
        this.addOIDButton = new Button(compositeEnterpriseOid, 0);
        this.addOIDButton.setText("Add Effective Enterprises OID");
        gridData = new GridData(32);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.addOIDButton.setLayoutData((Object)gridData);
        this.removeOIDText = new Text(compositeEnterpriseOid, 2048);
        this.removeOIDText.setText("");
        gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        gridData.widthHint = 250;
        this.removeOIDText.setLayoutData((Object)gridData);
        this.removeOIDButton = new Button(compositeEnterpriseOid, 0);
        this.removeOIDButton.setText("Remove Effective Enterprises OID");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.removeOIDButton.setLayoutData((Object)gridData);
        Composite entryTable = new Composite(parent, 0);
        entryTable.setLayoutData((Object)new GridData(768));
        this.setSelectionListener();
        this.setText();
        return entryTable;
    }

    private void setText() {
        String forwardFlag = TrapForwardResourceFileParse.getInstance().getForwardFlag();
        if (forwardFlag.equals("true")) {
            this.trapForwardButton.setSelection(true);
        } else {
            this.trapForwardButton.setSelection(false);
        }
        String forwardAddress = TrapForwardResourceFileParse.getInstance().getForwardAddress();
        this.destinationAddressText.setText(forwardAddress);
        this.enterprisesOIDList.removeAll();
        this.filetrEnterpriseOidMap.clear();
        ArrayList<String> enterpriseOidList = TrapForwardResourceFileParse.getInstance().getEnterpriseOidList();
        int i = 0;
        while (i < enterpriseOidList.size()) {
            String oid = enterpriseOidList.get(i);
            if (!this.filetrEnterpriseOidMap.containsKey(oid)) {
                this.enterprisesOIDList.add(oid);
                EnterpriseOIDInfo info = (EnterpriseOIDInfo)this.enterpriseOidInfoMap.get(oid);
                this.filetrEnterpriseOidMap.put(oid, info);
            }
            ++i;
        }
        if (this.trapForwardButton.getSelection()) {
            this.destinationAddressText.setEnabled(true);
            this.enterprisesOIDList.setEnabled(true);
            this.addOIDButton.setEnabled(true);
            this.removeOIDButton.setEnabled(true);
        } else {
            this.destinationAddressText.setEnabled(false);
            this.enterprisesOIDList.setEnabled(false);
            this.addOIDButton.setEnabled(false);
            this.removeOIDButton.setEnabled(false);
        }
    }

    private void setSelectionListener() {
        this.addOIDButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                int index = SnmpTrapForwardPreferencePage.this.enterpriseOidCombo.getSelectionIndex();
                String selectEnterpriseOid = (String)SnmpTrapForwardPreferencePage.this.workEnterpriseOidList.get(index);
                if (!SnmpTrapForwardPreferencePage.this.filetrEnterpriseOidMap.containsKey(selectEnterpriseOid)) {
                    SnmpTrapForwardPreferencePage.this.enterprisesOIDList.add(selectEnterpriseOid);
                    EnterpriseOIDInfo info = (EnterpriseOIDInfo)SnmpTrapForwardPreferencePage.this.enterpriseOidInfoMap.get(selectEnterpriseOid);
                    SnmpTrapForwardPreferencePage.this.filetrEnterpriseOidMap.put(selectEnterpriseOid, info);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.removeOIDButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (SnmpTrapForwardPreferencePage.this.removeOIDText.getText().equals("")) {
                    return;
                }
                if (SnmpTrapForwardPreferencePage.this.filetrEnterpriseOidMap.containsKey(SnmpTrapForwardPreferencePage.this.removeOIDText.getText())) {
                    SnmpTrapForwardPreferencePage.this.enterprisesOIDList.remove(SnmpTrapForwardPreferencePage.this.removeOIDText.getText());
                    SnmpTrapForwardPreferencePage.this.filetrEnterpriseOidMap.remove(SnmpTrapForwardPreferencePage.this.removeOIDText.getText());
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.enterprisesOIDList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                int index = SnmpTrapForwardPreferencePage.this.enterprisesOIDList.getSelectionIndex();
                if (index < 0) {
                    return;
                }
                String selectEnterpriseOid = SnmpTrapForwardPreferencePage.this.enterprisesOIDList.getItem(index);
                SnmpTrapForwardPreferencePage.this.removeOIDText.setText(selectEnterpriseOid);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.trapForwardButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (SnmpTrapForwardPreferencePage.this.trapForwardButton.getSelection()) {
                    SnmpTrapForwardPreferencePage.this.destinationAddressText.setEnabled(true);
                    SnmpTrapForwardPreferencePage.this.enterprisesOIDList.setEnabled(true);
                    SnmpTrapForwardPreferencePage.this.addOIDButton.setEnabled(true);
                    SnmpTrapForwardPreferencePage.this.removeOIDButton.setEnabled(true);
                } else {
                    SnmpTrapForwardPreferencePage.this.destinationAddressText.setEnabled(false);
                    SnmpTrapForwardPreferencePage.this.enterprisesOIDList.setEnabled(false);
                    SnmpTrapForwardPreferencePage.this.addOIDButton.setEnabled(false);
                    SnmpTrapForwardPreferencePage.this.removeOIDButton.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    protected void performDefaults() {
        this.setText();
    }

    public boolean performOk() {
        ArrayList<String> setOidList = new ArrayList<String>();
        Iterator<String> it = null;
        for (String ednterpriseOIDdKey : this.filetrEnterpriseOidMap.keySet()) {
            setOidList.add(ednterpriseOIDdKey);
        }
        String forwardFlag = "true";
        if (!this.trapForwardButton.getSelection()) {
            forwardFlag = "false";
        }
        String forwardAddress = "";
        if (forwardFlag.equals("true")) {
            forwardAddress = this.destinationAddressText.getText();
            String localHostAddress = "";
            try {
                InetAddress host = InetAddress.getByName(forwardAddress);
                forwardAddress = host.getHostAddress();
                localHostAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("UnknownHostException IP Address = " + forwardAddress));
                this.destinationAddressText.setFocus();
                return false;
            }
            if (forwardAddress == null || forwardAddress.equals("") || forwardAddress.equals("127.0.0.1") || forwardAddress.equals(localHostAddress)) {
                MessageDialog.openError((Shell)this.getShell().getShell(), (String)"Error", (String)"Illegal IP Address");
                this.destinationAddressText.setFocus();
                return false;
            }
        }
        this.saveTrapForwardInfo(forwardFlag, forwardAddress, setOidList);
        return super.performOk();
    }

    private void saveTrapForwardInfo(String forwardFlag, String forwardAddress, ArrayList oidList) {
        Document dom = null;
        BufferedWriter bufWriter = null;
        dom = this.updateTrapForwardResource(forwardFlag, forwardAddress, oidList);
        if (dom == null) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"Abort save Trap forward config");
            shell.dispose();
            return;
        }
        bufWriter = TrapForwardResourceFileParse.getInstance().getResourceFileWriter();
        this.outputXMLFile(bufWriter, dom);
        if (bufWriter != null) {
            try {
                bufWriter.close();
            }
            catch (IOException e) {
                logger.warning("Abort close BufferedWriter for Trap forward resource : " + e.getMessage());
                e.printStackTrace();
            }
        }
        TrapForwardResourceFileParse.getInstance().setTrapForwardInfo();
    }

    private Document updateTrapForwardResource(String forwardFlag, String forwardAddress, ArrayList oidList) {
        Document dom = TrapForwardResourceFileParse.getInstance().updateDocument(forwardFlag, forwardAddress, oidList);
        return dom;
    }
}

