/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager.trap;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.snmp.messageformat.SnmpTrap2PDU;
import netjfwatcher.snmp.messageformat.SnmpTrapPDU;
import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmpmanager.SnmpManagerQueue;
import netjfwatcher.snmpmanager.trap.EnterpriseOIDConfig;
import netjfwatcher.snmpmanager.trap.EnterpriseOIDInfo;
import netjfwatcher.snmpmanager.trap.ITrapListener;
import netjfwatcher.snmpmanager.trap.TrapForward;
import netjfwatcher.snmpmanager.trap.TrapReceiveMessageQueue;

public final class TrapListenerImpl
extends DataStringDisplay
implements ITrapListener {
    private static Logger logger;
    private static final int TRAP2_PDU_ID_POS = 0;
    private static final int TRAP2_PDU_ERROR_INDEX_POS = 1;
    private static final int TRAP2_PDU_ERROR_STATUS_POS = 2;
    private static final int TRAP2_PDU_VARBIND_LIST_POS = 3;
    private String[] trapData = new String[7];
    private String[] trap2Data = new String[7];
    private SnmpV3ManagerConfigInfo snmpV3ConfInfo;
    private int trapConter;
    private String trapV2AgentAddress;
    private String trapV2GenericTrap;
    private String trapV2SysUpTime;
    private String trapV2VarListOIDDiscription;
    private String trapV2EnterpriseOIDString;
    private ManagerMibTree mibtree = ManagerMibTree.getInstance();
    private final DateFormat dateformat = new SimpleDateFormat("HH:mm:ss");

    private TrapListenerImpl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void processTrap(String community, SnmpTrapPDU trapPDU, String sourceAddress) {
        EnterpriseOIDInfo enterpriseOidInfo;
        ++this.trapConter;
        byte snmpCommandCode = trapPDU.getPDUType();
        logger.info("Trap PDU-Type : " + this.getCommandDescription(snmpCommandCode));
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Trap PDU-Type : " + this.hexByte(snmpCommandCode) + "(" + this.getCommandDescription(snmpCommandCode) + ")");
        Date date = Calendar.getInstance().getTime();
        logger.info("Receive Trap date : " + this.dateformat.format(date) + " : Data length : " + trapPDU.getBEREncoding().length + "Byte");
        logger.info(this.hexBytetoString(trapPDU.getBEREncoding(), trapPDU.getBEREncoding().length));
        String receiveOidDiscription = "";
        SnmpSequence varBindSequence = trapPDU.getVarBindList();
        int i = 0;
        while (i < varBindSequence.size()) {
            SnmpSequence varBindValueSequence = (SnmpSequence)varBindSequence.getSNMPObjectAt(i);
            SnmpObjectIdentifier varBindOID = (SnmpObjectIdentifier)varBindValueSequence.getSNMPObjectAt(0);
            int oidwork = varBindOID.toString().lastIndexOf(".");
            String leaf = varBindOID.toString().substring(oidwork);
            String searchoid = varBindOID.toString().substring(0, oidwork);
            if (this.mibtree.getOidHashMap().containsKey(searchoid)) {
                MibInfo miboid = (MibInfo)this.mibtree.getOidHashMap().get(searchoid);
                receiveOidDiscription = String.valueOf(miboid.getDescrip()) + leaf;
            } else {
                logger.warning("Unknown OID : " + searchoid);
            }
            ++i;
        }
        String trapV1AgentAddress = "";
        if (trapPDU.getAgentAddress() != null) {
            trapV1AgentAddress = trapPDU.getAgentAddress().toString();
        }
        String trapV1EnterpriseOID = "";
        if (trapPDU.getEnterpriseOID() != null) {
            trapV1EnterpriseOID = trapPDU.getEnterpriseOID().toString();
        }
        this.trapData[0] = Integer.toString(this.trapConter);
        this.trapData[1] = "SNMPV1";
        Map enterpriseOidMap = EnterpriseOIDConfig.getInstance().getEnterpriseOidHashMap();
        String enterpriseOid = TrapForward.getInstance().extractEnterpriseOid(trapV1EnterpriseOID);
        this.trapData[2] = enterpriseOid == null ? trapV1EnterpriseOID : ((enterpriseOidInfo = (EnterpriseOIDInfo)enterpriseOidMap.get(enterpriseOid)) != null ? String.valueOf(trapV1EnterpriseOID) + " (" + enterpriseOidInfo.getCompany() + ")" : trapV1EnterpriseOID);
        this.trapData[3] = String.valueOf(trapV1AgentAddress) + " (Source=" + sourceAddress + ")";
        this.trapData[4] = this.checkGenericTrapCode(trapV1AgentAddress, trapPDU.getGenericTrap(), receiveOidDiscription);
        this.trapData[5] = Integer.toString(trapPDU.getSpecificTrap());
        this.trapData[6] = trapPDU.getTimestamp().toString();
        this.showTable(this.trapData);
        String message = String.valueOf(this.trapData[1]) + " Eenterprise OID:" + this.trapData[2] + " Agent address:" + this.trapData[3] + " Generic trap:" + this.trapData[4] + " Specific trap:" + this.trapData[5] + " Timestamp:" + this.trapData[6] + " (Source Adr.=" + sourceAddress + ")";
        AlarmMessageMake alarm = AlarmMessageMake.getInstance();
        alarm.setTrapReceive(trapV1AgentAddress, message);
        logger.info("Trap receive Source Address=" + sourceAddress + " : " + message);
        date = Calendar.getInstance().getTime();
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Trap receive date : " + this.dateformat.format(date));
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("SNMP Version   = " + this.trapData[1]);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Source Address = " + sourceAddress);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Enterprise OID = " + this.trapData[2]);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Agent address  = " + this.trapData[3]);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Generic trap   = " + this.trapData[4]);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Specific trap  = " + this.trapData[5]);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Timestamp      = " + this.trapData[6]);
        if (TrapForward.getInstance().filterTrapForward(enterpriseOid)) {
            TrapForward.getInstance().forwardTrap(community, trapPDU, 0, sourceAddress);
        }
    }

    public void processTrapV2(SnmpTrap2PDU trap2PDU, String snmpVersion, String sourceAddress) {
        ++this.trapConter;
        SnmpObjectIdentifier enterpriseOID = null;
        byte snmpCommandCode = trap2PDU.getPDUType();
        logger.info("Trap Source Address : " + sourceAddress);
        logger.info("Trap PDU-Type : " + this.getCommandDescription(snmpCommandCode));
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Trap PDU-Type : " + this.hexByte(snmpCommandCode) + "(" + this.getCommandDescription(snmpCommandCode) + ")");
        SnmpInteger trapID = (SnmpInteger)trap2PDU.getSNMPObjectAt(0);
        SnmpInteger errorIndex = (SnmpInteger)trap2PDU.getSNMPObjectAt(1);
        SnmpInteger errorStatus = (SnmpInteger)trap2PDU.getSNMPObjectAt(2);
        logger.info("Trap receive ID : " + trapID.toString());
        logger.info("Trap receive error Index : " + errorIndex.toString());
        logger.info("Trap receive error Status : " + errorStatus.toString());
        this.trapV2AgentAddress = "";
        if (trap2PDU.getAgentAddress() != null) {
            this.trapV2AgentAddress = trap2PDU.getAgentAddress().toString();
        }
        SnmpSequence varBindSequence = null;
        varBindSequence = (SnmpSequence)trap2PDU.getSNMPObjectAt(3);
        this.trapV2GenericTrap = "";
        this.trapV2SysUpTime = "";
        this.trapV2VarListOIDDiscription = "";
        this.trapV2EnterpriseOIDString = "";
        SnmpSequence varBindValueSequence = null;
        SnmpObjectIdentifier varBindOID = null;
        AbstractSnmpObject varBindValue = null;
        int varBindSeqCount = 0;
        while (varBindSeqCount < varBindSequence.size()) {
            varBindValueSequence = (SnmpSequence)varBindSequence.getSNMPObjectAt(varBindSeqCount);
            varBindOID = (SnmpObjectIdentifier)varBindValueSequence.getSNMPObjectAt(0);
            varBindValue = varBindValueSequence.getSNMPObjectAt(1);
            if (varBindSeqCount == 0) {
                if (varBindOID.toString().equals("1.3.6.1.2.1.1.3.0")) {
                    this.trapV2SysUpTime = varBindValue.toString();
                    logger.info("sysUpTime OID : " + varBindOID.toString());
                    logger.info("sysUpTime Value : " + varBindValue.toString());
                } else {
                    logger.warning("No sysUptime OID, Trap varBindValue Sequence No.0 varBindOID = " + varBindOID.toString());
                }
            }
            if (varBindSeqCount == 1) {
                enterpriseOID = varBindOID;
                this.checkSnmpTrapOID(enterpriseOID, varBindValue);
            }
            if (varBindSeqCount >= 2) {
                int oidwork = varBindOID.toString().lastIndexOf(".");
                String leaf = varBindOID.toString().substring(oidwork);
                String searchoid = varBindOID.toString().substring(0, oidwork);
                if (this.mibtree.getOidHashMap().containsKey(searchoid)) {
                    MibInfo varListOIDInfo = (MibInfo)this.mibtree.getOidHashMap().get(searchoid);
                    this.trapV2VarListOIDDiscription = String.valueOf(varListOIDInfo.getDescrip()) + leaf + " (" + varBindOID.toString() + ")" + " value = " + varBindValue;
                } else {
                    this.trapV2VarListOIDDiscription = "varBind OID = " + varBindOID.toString() + " value = " + varBindValue;
                    logger.warning("Unknown varBind OID : " + searchoid);
                }
            }
            logger.info("Receive varBind No." + varBindSeqCount + " OID = " + varBindOID.toString());
            logger.info("Receive varBind No." + varBindSeqCount + " Value = " + varBindValue.toString());
            ++varBindSeqCount;
        }
        this.setShowTrap2(snmpVersion, sourceAddress);
    }

    private void checkSnmpTrapOID(SnmpObjectIdentifier varBindOID, AbstractSnmpObject varBindValue) {
        if (varBindOID.toString().equals("1.3.6.1.6.3.1.1.4.1.0")) {
            this.trapV2GenericTrap = varBindValue.toString();
            logger.info("SNMP Trap OID = " + varBindOID.toString());
            logger.info("SNMP Trap OID value= " + varBindValue.toString());
            String snmpTrapOidValueDescription = "";
            if (varBindValue.toString().equals("1.3.6.1.6.3.1.1.5.1")) {
                snmpTrapOidValueDescription = "coldStart(" + varBindValue.toString() + ")";
            } else if (varBindValue.toString().equals("1.3.6.1.6.3.1.1.5.2")) {
                snmpTrapOidValueDescription = "warmStart(" + varBindValue.toString() + ")";
            } else if (varBindValue.toString().equals("1.3.6.1.6.3.1.1.5.3")) {
                snmpTrapOidValueDescription = "linkDown(" + varBindValue.toString() + ")";
            } else if (varBindValue.toString().equals("1.3.6.1.6.3.1.1.5.4")) {
                snmpTrapOidValueDescription = "linkUp(" + varBindValue.toString() + ")";
            } else if (varBindValue.toString().equals("1.3.6.1.6.3.1.1.5.5")) {
                snmpTrapOidValueDescription = "authenticationFailure(" + varBindValue.toString() + ")";
            } else if (varBindValue.toString().equals("1.3.6.1.6.3.1.1.5.6")) {
                snmpTrapOidValueDescription = "egpNeighborLoss(" + varBindValue.toString() + ")";
            } else if (varBindValue.toString().equals("1.3.6.1.6.3.1.1.5.7")) {
                snmpTrapOidValueDescription = "enterpriseSpecific(" + varBindValue.toString() + ")";
            } else {
                int oidwork = varBindValue.toString().lastIndexOf(".");
                String leaf = varBindValue.toString().substring(oidwork);
                String searchoid = varBindValue.toString().substring(0, oidwork);
                if (this.mibtree.getOidHashMap().containsKey(searchoid)) {
                    MibInfo varListOIDInfo = (MibInfo)this.mibtree.getOidHashMap().get(searchoid);
                    snmpTrapOidValueDescription = String.valueOf(varListOIDInfo.getDescrip()) + leaf + "(" + varBindValue.toString() + ")";
                } else {
                    snmpTrapOidValueDescription = varBindValue.toString();
                    logger.warning("Unknown OID : " + searchoid);
                }
            }
            this.trapV2EnterpriseOIDString = "snmpTrapOID.0 (" + varBindOID.toString() + ") value = " + snmpTrapOidValueDescription;
        } else {
            this.trapV2EnterpriseOIDString = "Not snmpTrapOID : " + varBindOID.toString();
            logger.warning("Trap varBindValueSequence No.1 varBindOID = " + varBindOID.toString());
        }
    }

    private void setShowTrap2(String snmpVersion, String sourceAddress) {
        EnterpriseOIDInfo enterpriseOidInfo;
        this.trap2Data[0] = Integer.toString(this.trapConter);
        this.trap2Data[1] = snmpVersion;
        Map enterpriseOidMap = EnterpriseOIDConfig.getInstance().getEnterpriseOidHashMap();
        String enterpriseOid = TrapForward.getInstance().extractEnterpriseOid(this.trapV2EnterpriseOIDString);
        this.trap2Data[2] = enterpriseOid == null ? this.trapV2EnterpriseOIDString : ((enterpriseOidInfo = (EnterpriseOIDInfo)enterpriseOidMap.get(enterpriseOid)) != null ? String.valueOf(this.trapV2EnterpriseOIDString) + " (" + enterpriseOidInfo.getCompany() + ")" : this.trapV2EnterpriseOIDString);
        this.trap2Data[3] = this.trapV2AgentAddress != null && !this.trapV2AgentAddress.equals("") ? this.trapV2AgentAddress : sourceAddress;
        this.trap2Data[4] = this.checkGenericTrapOID(this.trapV2AgentAddress, this.trapV2GenericTrap, this.trapV2VarListOIDDiscription);
        this.trap2Data[5] = "";
        this.trap2Data[6] = this.trapV2SysUpTime;
        this.showTable(this.trap2Data);
        String message = String.valueOf(this.trap2Data[1]) + " Enterprise OID:" + this.trap2Data[2] + " Agent address:" + this.trap2Data[3] + " Generic trap:" + this.trap2Data[4] + " Specific trap:" + this.trap2Data[5] + " Timestamp:" + this.trap2Data[6];
        AlarmMessageMake alarm = AlarmMessageMake.getInstance();
        if (this.trapV2AgentAddress != null && !this.trapV2AgentAddress.equals("")) {
            alarm.setTrapReceive(this.trapV2AgentAddress, message);
        } else {
            alarm.setTrapReceive(sourceAddress, message);
        }
        logger.info("Trap receive : " + message);
        Date date = Calendar.getInstance().getTime();
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Trap receive date : " + this.dateformat.format(date));
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("SNMP Version   = " + this.trap2Data[1]);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Source Address = " + sourceAddress);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Enterprise OID = " + this.trap2Data[2]);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Agent address  = " + this.trap2Data[3]);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Generic trap   = " + this.trap2Data[4]);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Specific trap  = " + this.trap2Data[5]);
        SnmpManagerQueue.getInstance().pushSnmpManagerQueue("Timestamp      = " + this.trap2Data[6]);
    }

    private String checkGenericTrapCode(String address, int code, String variableBind) {
        String genericTrapDisc = "";
        switch (code) {
            case 0: {
                genericTrapDisc = "coldStart";
                this.snmpV3ConfInfo = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(address);
                if (this.snmpV3ConfInfo == null) break;
                this.snmpV3ConfInfo.setLearned(false);
                logger.info("SnmpEngineBoots and SnmpEngineTime relearned at " + address + " for " + "coldStart");
                break;
            }
            case 1: {
                genericTrapDisc = "warmStart";
                this.snmpV3ConfInfo = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(address);
                if (this.snmpV3ConfInfo == null) break;
                this.snmpV3ConfInfo.setLearned(false);
                logger.info("SnmpEngineBoots and SnmpEngineTime relearned at " + address + " for " + "warmStart");
                break;
            }
            case 2: {
                genericTrapDisc = "linkDown " + variableBind;
                break;
            }
            case 3: {
                genericTrapDisc = "linkUp " + variableBind;
                break;
            }
            case 4: {
                genericTrapDisc = "authenticationFailure";
                break;
            }
            case 5: {
                genericTrapDisc = "egpNeighborLoss " + variableBind;
                break;
            }
            case 6: {
                genericTrapDisc = "enterpriseSpecific " + variableBind;
                break;
            }
            default: {
                genericTrapDisc = Integer.toString(code);
            }
        }
        return genericTrapDisc;
    }

    private String checkGenericTrapOID(String address, String genericTrapOID, String variableBind) {
        String genericTrapDisc = "";
        this.snmpV3ConfInfo = SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(address);
        if (this.snmpV3ConfInfo != null) {
            this.snmpV3ConfInfo.setLearned(false);
            logger.info("SnmpEngineBoots and SnmpEngineTime relearned at " + address);
        }
        genericTrapDisc = genericTrapOID.equals("1.3.6.1.6.3.1.1.5.1") ? "coldStart" : (genericTrapOID.equals("1.3.6.1.6.3.1.1.5.2") ? "warmStart" : (genericTrapOID.equals("1.3.6.1.6.3.1.1.5.3") ? "linkDown " + variableBind : (genericTrapOID.equals("1.3.6.1.6.3.1.1.5.4") ? "linkUp " + variableBind : (genericTrapOID.equals("1.3.6.1.6.3.1.1.5.5") ? "authenticationFailure" : (genericTrapOID.equals("1.3.6.1.6.3.1.1.5.6") ? "egpNeighborLoss " + variableBind : variableBind)))));
        return genericTrapDisc;
    }

    public void showTable(String[] trapShowData) {
        ArrayList<String[]> trapReceiveList = new ArrayList<String[]>();
        String[] trapDataClone = (String[])trapShowData.clone();
        trapReceiveList.add(trapDataClone);
        TrapReceiveMessageQueue.getInstance().pushTrapData(trapReceiveList);
    }

    private String getCommandDescription(byte code) {
        String snmpCode = "";
        switch (code) {
            case -92: {
                snmpCode = "Trap-PDU";
                break;
            }
            case -89: {
                snmpCode = "Trap2-PDU";
                break;
            }
            case -90: {
                snmpCode = "Inform-PDU";
                break;
            }
            case -96: {
                snmpCode = "GetRequest";
                break;
            }
            case -95: {
                snmpCode = "GetNextRequest";
                break;
            }
            case -93: {
                snmpCode = "SetRequest";
                break;
            }
            case -94: {
                snmpCode = "GetResponse";
                break;
            }
            default: {
                snmpCode = "Unknown";
                logger.warning("Undefined SNMP Command code : " + code);
            }
        }
        return snmpCode;
    }

    public static TrapListenerImpl getInstance() {
        return SingletonResource.TRAP_LISTENER_IMPL;
    }

    /* synthetic */ TrapListenerImpl(TrapListenerImpl trapListenerImpl) {
        this();
    }

    private static class SingletonResource {
        static final TrapListenerImpl TRAP_LISTENER_IMPL = new TrapListenerImpl(null);

        private SingletonResource() {
        }
    }
}

