/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.webbrowser.menutree;

import java.util.logging.Logger;
import netjfwatcher.webbrowser.menutree.AbstractMenuTreeListener;
import netjfwatcher.webbrowser.menutree.NetMenuTree;
import netjfwatcher.webbrowser.model.UrlEditorInput;
import netjfwatcher.webbrowser.view.BrowserEditors;
import netjfwatcher.webbrowser.view.BrowserEditorsManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class NetMenuTreeListener
extends AbstractMenuTreeListener {
    private static IWorkbenchPage activePage;
    private static Logger logger;

    static {
        logger = null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        logger = Logger.getLogger(this.getClass().getName());
        StructuredSelection ss = (StructuredSelection)event.getSelection();
        final NetMenuTree entry = (NetMenuTree)ss.getFirstElement();
        logger.info("Name : " + entry.getName());
        logger.info("Url : " + entry.getUrl());
        activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editorPart = BrowserEditorsManager.getInstance().getBrowserEditors(entry.getUrl());
        if (editorPart != null) {
            BrowserEditorsManager.getInstance().removetBrowserEditors(entry.getUrl());
            activePage.closeEditor(editorPart, false);
        }
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    IEditorPart editorPart = activePage.openEditor((IEditorInput)new UrlEditorInput(entry.getName(), entry.getUrl()), BrowserEditors.class.getName());
                    BrowserEditorsManager.getInstance().setBrowserEditors(entry.getUrl(), editorPart);
                }
                catch (PartInitException e) {
                    logger.warning("Menu open error : " + e.getMessage());
                    e.printStackTrace();
                }
            }
        });
    }
}

