/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.webbrowser.nodetree;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.webbrowser.nodetree.NodeListXmlParse;
import netjfwatcher.webbrowser.preferences.HttpAccessPreference;
import netjfwatcher.webbrowser.preferences.HttpAccessPreferenceException;
import netjfwatcher.webbrowser.view.HttpAccessException;

public class NodeListImport {
    private static Logger logger;

    public NodeListImport() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public ArrayList importNodeList() throws HttpAccessException, HttpAccessPreferenceException {
        String nodeListImportUrl = HttpAccessPreference.getInstance().getNodeListImportUrl();
        if (nodeListImportUrl == null) {
            throw new HttpAccessPreferenceException("Node list import url null");
        }
        ArrayList nodeList = null;
        HttpURLConnection urlConnection = null;
        InputStream urlInStream = null;
        BufferedReader in = null;
        try {
            try {
                URL accessURL = new URL(nodeListImportUrl);
                urlConnection = (HttpURLConnection)accessURL.openConnection();
                urlInStream = urlConnection.getInputStream();
                System.out.println("Date : " + new Date(urlConnection.getDate()));
                System.out.println("getContentLength : " + urlConnection.getContentLength());
                NodeListXmlParse xmlParse = NodeListXmlParse.getInstance();
                nodeList = xmlParse.loadAndParseNodeList();
            }
            catch (UnknownHostException e) {
                logger.warning("UnknownHostException " + e.getMessage());
                e.printStackTrace();
                throw new HttpAccessException(String.valueOf(HttpAccessPreference.getInstance().getUrl()) + " : " + e.getMessage());
            }
            catch (MalformedURLException e) {
                logger.warning("MalformedURLException " + e.getMessage());
                e.printStackTrace();
                throw new HttpAccessException(String.valueOf(HttpAccessPreference.getInstance().getUrl()) + " : " + e.getMessage());
            }
            catch (FileNotFoundException e) {
                logger.warning("FileNotFoundException " + e.getMessage());
                e.printStackTrace();
                throw new HttpAccessException(String.valueOf(HttpAccessPreference.getInstance().getUrl()) + " : " + e.getMessage());
            }
            catch (ConnectException e) {
                logger.warning("ConnectException " + e.getMessage());
                e.printStackTrace();
                throw new HttpAccessException(String.valueOf(HttpAccessPreference.getInstance().getUrl()) + " : " + e.getMessage());
            }
            catch (IOException e) {
                logger.warning("IOException " + e.getMessage());
                e.printStackTrace();
                throw new HttpAccessException(String.valueOf(HttpAccessPreference.getInstance().getUrl()) + " : " + e.getMessage());
            }
        }
        finally {
            if (urlInStream != null) {
                try {
                    urlInStream.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            urlConnection.disconnect();
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
        return nodeList;
    }
}

