/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.macaddress.gui;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.macaddress.preference.MacAddressConfig;
import netjfwatcher.macaddress.preference.MacAddressInfo;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MacAddressSearchEditorView
extends AbstractEditorNodeView {
    private static final int VENDOR_SEARCH_TEXT_WIDTH = 150;
    private static final int OUI_SEARCH_TEXT_WIDTH = 100;
    private static Logger logger;
    private static final float COLUMN0_NO_RATIO = 0.05f;
    private static final float COLUMN1_VENDOR_ID_RATIO = 0.1f;
    private static final float COLUMN2_VENDOR_INFO_RATIO = 0.6f;
    private static final String NO = "No.";
    private static final String VENDOR_ID = "Vendor ID";
    private static final String VENDOR_INFO = "Vendor Information";
    private static final int NO_POS = 0;
    private static final int VENDOR_ID_POS = 1;
    private static final int VENDOR_INFO_POS = 2;
    private static final int COLUMN_NO = 3;
    private Map macInfoHashMap;
    private Text vendorIDSearchText;
    private Text vendorInfoSearchText;
    private Button ouiSearchButton;
    private Button vedorSearchButton;
    private Button allViewButton;
    private TableViewer viewer;
    private Color textBackColor;

    public MacAddressSearchEditorView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.textBackColor = Display.getCurrent().getSystemColor(1);
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(7, false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        Label label = new Label(composite, 0);
        label.setText("Vedor ID");
        label.setLayoutData((Object)new GridData());
        this.vendorIDSearchText = new Text(composite, 2048);
        this.vendorIDSearchText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 100;
        this.vendorIDSearchText.setLayoutData((Object)gridData);
        this.ouiSearchButton = new Button(composite, 0);
        this.ouiSearchButton.setText("Search");
        this.ouiSearchButton.setLayoutData((Object)new GridData());
        label = new Label(composite, 0);
        label.setText("Vedor Info");
        label.setLayoutData((Object)new GridData());
        this.vendorInfoSearchText = new Text(composite, 2048);
        this.vendorInfoSearchText.setBackground(this.textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 150;
        this.vendorInfoSearchText.setLayoutData((Object)gridData);
        this.vedorSearchButton = new Button(composite, 0);
        this.vedorSearchButton.setText("Search");
        this.vedorSearchButton.setLayoutData((Object)new GridData());
        this.allViewButton = new Button(composite, 0);
        this.allViewButton.setText("All Show");
        this.allViewButton.setLayoutData((Object)new GridData());
        this.macInfoHashMap = MacAddressConfig.getInstance().getResourceFileParse().getMacInfoHashMap();
        SnmpInterfaceMibTable statisticsTable = new SnmpInterfaceMibTable();
        this.table = statisticsTable.createTable(parent);
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        this.setMacAddressTable();
        this.ouiSearchButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MacAddressSearchEditorView.this.ouiSearchButton.setEnabled(false);
                MacAddressSearchEditorView.this.searchVedorID();
                MacAddressSearchEditorView.this.ouiSearchButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.vedorSearchButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MacAddressSearchEditorView.this.vedorSearchButton.setEnabled(false);
                MacAddressSearchEditorView.this.searchVedorInfo();
                MacAddressSearchEditorView.this.vedorSearchButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.allViewButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MacAddressSearchEditorView.this.allViewButton.setEnabled(false);
                MacAddressSearchEditorView.this.setMacAddressTable();
                MacAddressSearchEditorView.this.allViewButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void searchVedorID() {
        String searchVendorID = this.vendorIDSearchText.getText();
        this.table.removeAll();
        this.viewer.refresh();
        long count = 0L;
        this.macInfoHashMap = MacAddressConfig.getInstance().getResourceFileParse().getMacInfoHashMap();
        Iterator it = this.macInfoHashMap.keySet().iterator();
        while (it.hasNext()) {
            String[] macAddressTableCellArray = new String[3];
            String key = (String)it.next();
            MacAddressInfo macInfo = (MacAddressInfo)this.macInfoHashMap.get(key);
            int hitCount = macInfo.getOui().indexOf(searchVendorID.toUpperCase());
            if (hitCount < 0) continue;
            macAddressTableCellArray[0] = Long.toString(++count);
            macAddressTableCellArray[1] = macInfo.getOui();
            macAddressTableCellArray[2] = macInfo.getVendorInfo();
            TableItem item = new TableItem(this.table, 0);
            item.setText(macAddressTableCellArray);
            item.setData((Object)macAddressTableCellArray);
        }
    }

    private void searchVedorInfo() {
        String searchVendorInfo = this.vendorInfoSearchText.getText();
        this.table.removeAll();
        this.viewer.refresh();
        long count = 0L;
        this.macInfoHashMap = MacAddressConfig.getInstance().getResourceFileParse().getMacInfoHashMap();
        Iterator it = this.macInfoHashMap.keySet().iterator();
        while (it.hasNext()) {
            String[] macAddressTableCellArray = new String[3];
            String key = (String)it.next();
            MacAddressInfo macInfo = (MacAddressInfo)this.macInfoHashMap.get(key);
            int hitCount = macInfo.getVendorInfoUpperCase().indexOf(searchVendorInfo.toUpperCase());
            if (hitCount < 0) continue;
            macAddressTableCellArray[0] = Long.toString(++count);
            macAddressTableCellArray[1] = macInfo.getOui();
            macAddressTableCellArray[2] = macInfo.getVendorInfo();
            TableItem item = new TableItem(this.table, 0);
            item.setText(macAddressTableCellArray);
            item.setData((Object)macAddressTableCellArray);
        }
    }

    private void setMacAddressTable() {
        this.table.removeAll();
        this.viewer.refresh();
        long count = 0L;
        this.macInfoHashMap = MacAddressConfig.getInstance().getResourceFileParse().getMacInfoHashMap();
        Iterator it = this.macInfoHashMap.keySet().iterator();
        while (it.hasNext()) {
            String[] macAddressTableCellArray = new String[3];
            String key = (String)it.next();
            MacAddressInfo macInfo = (MacAddressInfo)this.macInfoHashMap.get(key);
            macAddressTableCellArray[0] = Long.toString(++count);
            macAddressTableCellArray[1] = macInfo.getOui();
            macAddressTableCellArray[2] = macInfo.getVendorInfo();
            TableItem item = new TableItem(this.table, 0);
            item.setText(macAddressTableCellArray);
            item.setData((Object)macAddressTableCellArray);
        }
    }

    private int computeCol0Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.05f);
    }

    private int computeCol1Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol2Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.6f);
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.textBackColor != null) {
            this.textBackColor.dispose();
        }
        if (this.table != null) {
            this.table.dispose();
        }
    }

    private final class SnmpInterfaceMibTable
    extends AbstractTableView {
        private boolean isCol0Direction = false;
        private boolean isCol1Direction = false;
        private boolean isCol2Direction = false;
        private TableColumn col0;
        private TableColumn col1;
        private TableColumn col2;

        private SnmpInterfaceMibTable() {
        }

        private Table createTable(Composite parent) {
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.verticalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            data2.grabExcessVerticalSpace = true;
            this.table = new Table(parent, 66304);
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            this.table.setLayoutData((Object)data2);
            this.col0 = new TableColumn(this.table, 0x1000000);
            this.col0.setText(MacAddressSearchEditorView.NO);
            this.col0.setWidth(MacAddressSearchEditorView.this.computeCol0Width());
            this.col1 = new TableColumn(this.table, 0x1000000);
            this.col1.setText(MacAddressSearchEditorView.VENDOR_ID);
            this.col1.setWidth(MacAddressSearchEditorView.this.computeCol1Width());
            this.col2 = new TableColumn(this.table, 0x1000000);
            this.col2.setText(MacAddressSearchEditorView.VENDOR_INFO);
            this.col2.setWidth(MacAddressSearchEditorView.this.computeCol2Width());
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent event) {
                }

                public void controlResized(ControlEvent event) {
                    SnmpInterfaceMibTable.this.setResizedTableColumnWidth();
                }
            });
            this.col0.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol0Direction = SnmpInterfaceMibTable.this.sortIntegerTable(SnmpInterfaceMibTable.this.table, 0, SnmpInterfaceMibTable.this.isCol0Direction);
                }
            });
            this.col1.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol1Direction = SnmpInterfaceMibTable.this.sortTable(SnmpInterfaceMibTable.this.table, 1, SnmpInterfaceMibTable.this.isCol1Direction);
                }
            });
            this.col2.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SnmpInterfaceMibTable.this.isCol2Direction = SnmpInterfaceMibTable.this.sortTable(SnmpInterfaceMibTable.this.table, 2, SnmpInterfaceMibTable.this.isCol2Direction);
                }
            });
            return this.table;
        }

        protected void setResizedTableColumnWidth() {
            if (MacAddressSearchEditorView.this.getEditorSite().getPage().isPartVisible(MacAddressSearchEditorView.this.getEditorSite().getPart()) && MacAddressSearchEditorView.this.getEditorSite().getShell() != null && MacAddressSearchEditorView.this.getEditorSite().getShell().getSize() != null) {
                this.col0.setWidth(MacAddressSearchEditorView.this.computeCol0Width());
                this.col1.setWidth(MacAddressSearchEditorView.this.computeCol1Width());
                this.col2.setWidth(MacAddressSearchEditorView.this.computeCol2Width());
            }
        }

        protected TableItem setTableItem(Table table, TableItem item, String[] strs) {
            Color obj0 = item.getForeground();
            Color obj1 = item.getBackground();
            item.dispose();
            item = new TableItem(table, 0);
            item.setText(strs);
            item.setData((Object)strs);
            item.setForeground(obj0);
            item.setBackground(obj1);
            return item;
        }
    }
}

