/*
 * Created on 2007/03/12
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemap.perspective;



import netjfwatcher.engine.nodemaneger.list.NodeListTreeView;
import netjfwatcher.nodemap.gui.NodeMapDrawView;
import netjfwatcher.nodemap.gui.icon.NodeIconView;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;



/**
 * m[h Map Draw PerspectiveNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeMapPerspective implements IPerspectiveFactory {
	public static final String ID = "netjfwatcher.nodemap.perspective.NodeMapPerspective";
    private static final float NODE_TREE_RATIO = 0.20f;
    private static final float NODE_LIST_RATIO = 0.40f;
    private static final float ENGINE_LIST_RATIO = 0.85f;
    
    /**
     * PerspectivȅCAEgs܂B
     *
     * @param layout IPageLayout
     */
    public void createInitialLayout(IPageLayout layout) {
        layout.setEditorAreaVisible(false);

        String editorArea = layout.getEditorArea();

        /* PerspectiveɃm[hTree */
        IFolderLayout left =
            layout.createFolder(
                "left", IPageLayout.LEFT, NODE_TREE_RATIO, editorArea);
        left.addView(NodeListTreeView.class.getName());

        /* Perspective EIcon ComboBoxzu  */
        IFolderLayout right =
            layout.createFolder(
                "right", IPageLayout.RIGHT, ENGINE_LIST_RATIO, editorArea);

        right.addView(NodeIconView.class.getName());
        
        /* Perspective㑤Ƀm[hMap  */
        IFolderLayout top =
            layout.createFolder(
                "top", IPageLayout.TOP, NODE_LIST_RATIO, editorArea);
        top.addView(NodeMapDrawView.class.getName());
    }
}
