/*
 * Created on 2004/05/18
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DataAccessObjectApacheDerby;
import netjfwatcher.database.access.control.DataAccessObjectAxion;
import netjfwatcher.database.access.control.DataAccessObjectHSQLDB;
import netjfwatcher.database.access.control.DataAccessObjectMySQL;
import netjfwatcher.database.access.control.DataAccessObjectOracle;
import netjfwatcher.database.access.control.DataAccessObjectPostgreSQL;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyEmbeddedDerby;

/**
 * w肳ꂽf[^x[XvpeBɂăf[^x[X̃eXgs\bh ܂B
 * 
 * EiGWڑmFj EJDBC Driver ̓o^mF Ef[^x[Xւ̃RlNV𐶐 Ef[^x[XEe[u̍쐬
 * Ef[^x[XEe[u̍폜
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class DatabaseTest {
	/** f[^x[XeXgpe[u */
	public static final String DATABASE_TEST_TABLE = "database_test";

	/** f[^x[XeXgpID J */
	public static final String TEST_ID = "id";

	/** f[^x[XeXgpe[uJ */
	public static final String TEST_CHAR = "test_char";

	/** f[^x[XeXgpe[uJ */
	public static final String TEST_DATE = "test_date";

	/* Web-GWڑĩNXł́Agpj */
	private static final int PHASE0_NO = 0;

	/* JDBC Driver ̓o^ */
	private static final int PHASE1_NO = 1;

	/* f[^x[X쐬 */
	private static final int PHASE2_NO = 2;

	/* f[^x[XEe[u쐬 */
	private static final int PHASE3_NO = 3;

	/* ̃e[u폜 */
	private static final int PHASE4_NO = 4;

	/* eXgtF[Y */
	private static final int PHASE_COUNT = 5;

	// MO
	private static Logger logger = null;

	/* f[^x[XғeXgtF[YOKDescription */
	private static final String PHASE1_OK_DESCRIPTION = "Phase 1 OK";

	private static final String PHASE2_OK_DESCRIPTION = "Phase 2 OK";

	private static final String PHASE3_OK_DESCRIPTION = "Phase 3 OK";

	private static final String PHASE4_OK_DESCRIPTION = "Phase 4 OK";

	/* f[^x[X */
	private final String databaseName;

	/* f[^x[XeXgtF[Yʊi[z */
	private String[] checkResult = new String[PHASE_COUNT];

	/* eXgpf[^ANZXIuWFNg */
	private AbstractDataAccessObject dataaccessobject;

	/* f[^x[XANZXURL */
	private String testURL;

	/**
	 * f[^x[XeXgsCX^X𐶐܂B
	 * 
	 * @param paraDatabaseName
	 *            f[^x[X
	 */
	public DatabaseTest(final String paraDatabaseName) {
		logger = Logger.getLogger(this.getClass().getName());
		this.databaseName = paraDatabaseName;
	}

	/**
	 * f[^x[XɉғĂ邩̃`FbNs܂B
	 * 
	 * @param jdbcdriver
	 *            f[^x[XJDBChCo
	 * @param url
	 *            f[^x[XURL
	 * @param username
	 *            f[^x[X̃[U
	 * @param password
	 *            f[^x[X̃pX[h
	 * 
	 * @return checkResult `FbNʂi[镶̔z
	 */
	public String[] checkDatabase(final String jdbcdriver, final String url,
			final String username, final String password) {
		logger.info("Database Test start : " + databaseName);
		logger.info("jdbcdriver : " + jdbcdriver);
		logger.info("url : " + url);
		logger.info("username : " + username);
		logger.info("password : " + password);

		checkResult[PHASE0_NO] = "";
		checkResult[PHASE1_NO] = "";
		checkResult[PHASE2_NO] = "";
		checkResult[PHASE3_NO] = "";
		checkResult[PHASE4_NO] = "";
		testURL = "";
		dataaccessobject = null;

		/*
		 * JDBC Driver ̓o^`FbN
		 */
		checkResult = checkPhase1(jdbcdriver);

		if (!checkResult[PHASE1_NO].equals(PHASE1_OK_DESCRIPTION)) {
			return checkResult;
		}

		/*
		 * f[^x[Xւ̃RlNV𐶐eXg
		 */
		checkResult = checkPhase2(url, username, password);

		if (!checkResult[PHASE2_NO].equals(PHASE2_OK_DESCRIPTION)) {
			return checkResult;
		}

		/*
		 * f[^x[XɑΉf[^ANZXIuWFNg𐶐 yуf[^x[XEe[u쐬eXg
		 */
		checkResult = checkPhase3(username, password);

		if (!checkResult[PHASE3_NO].equals(PHASE3_OK_DESCRIPTION)) {
			return checkResult;
		}

		/*
		 * eXgpe[uɃf[^i[yуe[u폜eXg
		 */
		checkResult = checkPhase4(username, password);

		if (!checkResult[PHASE4_NO].equals(PHASE4_OK_DESCRIPTION)) {
			return checkResult;
		}

		return checkResult;
	}

	/**
	 * f[^x[XғeXgtF[Y1s܂B
	 * 
	 * @param jdbcdriver
	 *            JDBChCo
	 * @return checkResult `FbN
	 */
	private String[] checkPhase1(final String jdbcdriver) {
		try {
			if (databaseName.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
				/* Booting derbyɂEmbeddedDerbyғ󋵂UZbg */
				ApacheDerbyEmbeddedDerby.getInstance().setEmbeddedDerby(false);
			}

			// JDBC Driver ̓o^
			Class.forName(jdbcdriver).newInstance();

			if (databaseName.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
				/* Booting derbyɂEmbeddedDerbyғ󋵂ZbgB */
				ApacheDerbyEmbeddedDerby.getInstance().setEmbeddedDerby(true);
			}

			checkResult[PHASE1_NO] = PHASE1_OK_DESCRIPTION;
			logger.info(checkResult[PHASE1_NO]);
		} catch (ExceptionInInitializerError e) {
			checkResult[PHASE1_NO] = "ExceptionInInitializerError: "
					+ e.getMessage();
			logger.warning(checkResult[1]);
			e.printStackTrace();

			return checkResult;
		} catch (InstantiationException e) {
			checkResult[PHASE1_NO] = "InstantiationException: "
					+ e.getMessage();
			logger.warning(checkResult[1]);
			e.printStackTrace();

			return checkResult;
		} catch (IllegalAccessException e) {
			checkResult[PHASE1_NO] = "IllegalAccessException: "
					+ e.getMessage();
			logger.warning(checkResult[1]);
			e.printStackTrace();

			return checkResult;
		} catch (ClassNotFoundException e) {
			checkResult[PHASE1_NO] = "ClassNotFoundException: "
					+ e.getMessage();
			logger.warning(checkResult[1]);
			e.printStackTrace();

			return checkResult;
		} catch (NoClassDefFoundError e) {
			checkResult[PHASE1_NO] = "NoClassDefFoundError: " + e.getMessage();
			logger.warning(checkResult[1]);
			e.printStackTrace();

			return checkResult;
		}

		return checkResult;
	}

	/**
	 * f[^x[XғeXgtF[Y2s܂B
	 * 
	 * @param url
	 *            f[^x[XANZXURL
	 * @param username
	 *            f[^x[X[U
	 * @param password
	 *            f[^x[XpX[h
	 * @return checkResult `FbN
	 */
	private String[] checkPhase2(final String url, final String username,
			final String password) {
		Connection con = null;
		Statement stmt = null;

		String sql = "";

		/*
		 * eXgf[^x[XMySQLyPostgreSQL̏ꍇŉғ f[^x[X҂łȂꍇ́Af[^x[X𐶐 
		 */
		String nowData = DatabaseAccessControlKind.getInstance()
				.getDatabaseName();

		try {
			if (!databaseName.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
				if (databaseName.equals(AbstractDataAccessObject.DERBY)) {
					// Apache Derby f[^x[Xւ̃RlNV𐶐
					testURL = url + AbstractDataAccessObject.DATABASE_URL + ";"
							+ ApacheDerbyDatabaseInit.DERBY_ATTRIBUTES;
				} else if (databaseName.equals(AbstractDataAccessObject.MYSQL)) {
					// MySQLł̃f[^x[Xւ̃RlNV𐶐
					testURL = url + AbstractDataAccessObject.MYSQL_USE_DATABASE;
				} else {
					// Apache DerbyyMySQLȊOł̃f[^x[Xւ̃RlNV𐶐
					testURL = url + AbstractDataAccessObject.USE_DATABASE;
				}

				con = DriverManager.getConnection(testURL, username, password);
			} else {
				/* Embedded Derby̏ꍇ̃f[^x[XRlNV */
				testURL = "jdbc:derby:" + AbstractDataAccessObject.DATABASE_URL
						+ ";" + ApacheDerbyDatabaseInit.DERBY_ATTRIBUTES;
				con = DriverManager.getConnection(testURL);
			}

			// SQL Xe[ggEIuWFNg̍쐬
			stmt = con.createStatement();

			if (databaseName.equals(AbstractDataAccessObject.MYSQL)
					&& !nowData.equals(AbstractDataAccessObject.MYSQL)) {
				// f[^x[X폜
				sql = MySQLDatabaseInit.DROP;
				stmt.executeUpdate(sql);

				// f[^x[X쐬 nodewatch
				sql = MySQLDatabaseInit.CREATE;
				stmt.executeUpdate(sql);
			} else if (databaseName.equals(AbstractDataAccessObject.POSTGRESQL)
					&& !nowData.equals(AbstractDataAccessObject.POSTGRESQL)) {
				try {
					// f[^x[X폜
					sql = PostgreSQLDatabaseInit.DROP;
					stmt.executeUpdate(sql);
				} catch (SQLException e) {
					/*
					 * PostgreSQL̏ꍇɂ݂͑Ȃf[^x[X폜ł
					 * SQLExceptionɂȂ邽߁AG[ƂȂ
					 */
					logger.info(databaseName + " SQL=" + sql + " : "
							+ e.getMessage());
				}

				// f[^x[X쐬 nodewatch
				sql = PostgreSQLDatabaseInit.CREATE;
				stmt.executeUpdate(sql);
			}

			checkResult[PHASE2_NO] = PHASE2_OK_DESCRIPTION;
			logger.info(checkResult[PHASE2_NO]);
		} catch (SQLException e1) {
			e1.printStackTrace();

			if (e1.getNextException() != null) {
				checkResult[PHASE2_NO] = "SQLException: " + e1.getMessage()
						+ " Next exception: " + e1.getNextException();
			} else {
				checkResult[PHASE2_NO] = "SQLException: " + e1.getMessage();
			}
			logger.warning("SQLException " + "URL = " + testURL + " : User = "
					+ username + " : Password = " + password);
			logger.warning(checkResult[PHASE2_NO]);
			logger.warning("SQLException " + "SQL=" + sql);

			// e1.printStackTrace();
			return checkResult;
		} catch (NoClassDefFoundError e1) {
			checkResult[PHASE2_NO] = "NoClassDefFoundError: " + e1.getMessage();
			logger.warning("NoClassDefFoundError " + "URL = " + testURL
					+ " : User = " + username + " : Password = " + password);
			logger.warning(checkResult[PHASE2_NO]);
			logger.warning("NoClassDefFoundError " + "SQL=" + sql);

			// e1.printStackTrace();
			return checkResult;
		} finally {
			if (stmt != null) {
				try {
					stmt.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				stmt = null;
			}

			if (con != null) {
				try {
					con.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}
			}
		}

		return checkResult;
	}

	/**
	 * f[^x[XғeXgtF[Y3s܂B
	 * 
	 * @param username
	 *            f[^x[X[U
	 * @param password
	 *            f[^x[XpX[h
	 * @return checkResult `FbN
	 */
	private String[] checkPhase3(final String username, final String password) {
		Connection con = null;
		Statement stmt = null;

		// f[^x[XɑΉf[^ANZXIuWFNg𐶐
		if (databaseName.equals(AbstractDataAccessObject.HSQLDB)) {
			dataaccessobject = new DataAccessObjectHSQLDB();
		} else if (databaseName.equals(AbstractDataAccessObject.DERBY)
				|| databaseName.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
			dataaccessobject = new DataAccessObjectApacheDerby();
		} else if (databaseName.equals(AbstractDataAccessObject.MYSQL)) {
			dataaccessobject = new DataAccessObjectMySQL();
		} else if (databaseName.equals(AbstractDataAccessObject.POSTGRESQL)) {
			dataaccessobject = new DataAccessObjectPostgreSQL();
		} else if (databaseName.equals(AbstractDataAccessObject.ORACLE)) {
			dataaccessobject = new DataAccessObjectOracle();
		} else if (databaseName.equals(AbstractDataAccessObject.AXION)) {
			dataaccessobject = new DataAccessObjectAxion();
		} else {
			logger.warning("Database Nosuport : " + databaseName);
			checkResult[PHASE3_NO] = "Database Nosuport : " + databaseName;

			return checkResult;
		}

		logger.info("Database Kind : " + databaseName);

		try {
			if (!databaseName.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
				con = DriverManager.getConnection(testURL, username, password);
			} else {
				con = DriverManager.getConnection(testURL);
			}

			// SQL Xe[ggEIuWFNg̍쐬
			stmt = con.createStatement();

			// f[^x[XEe[u쐬
			stmt
					.executeUpdate(dataaccessobject
							.getCreateDatabaseTestTableSQL());

			checkResult[PHASE3_NO] = PHASE3_OK_DESCRIPTION;
			logger.info(checkResult[PHASE3_NO]);
		} catch (SQLException e2) {
			checkResult[PHASE3_NO] = "SQLException: " + e2.getMessage();
			logger.warning("SQL : "
					+ dataaccessobject.getCreateDatabaseTestTableSQL());
			logger.warning(checkResult[PHASE3_NO]);

			// e2.printStackTrace();

			/*
			 * f[^x[X̃e[uɎsꍇAe[uɑ݂ꍇȂǂ l̂returnɎ̃e[u폜s
			 */

			// return checkResult;
		} finally {
			if (stmt != null) {
				try {
					stmt.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				stmt = null;
			}

			if (con != null) {
				try {
					con.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}
			}
		}

		return checkResult;
	}

	/**
	 * f[^x[XғeXgtF[Y4s܂B
	 * 
	 * @param username
	 *            f[^x[X[U
	 * @param password
	 *            f[^x[XpX[h
	 * @return checkResult `FbN
	 */
	private String[] checkPhase4(final String username, final String password) {
		Connection con = null;
		Statement stmt = null;

		try {
			con = DriverManager.getConnection(testURL, username, password);

			// SQL Xe[ggEIuWFNg̍쐬
			stmt = con.createStatement();

			// ̃e[u폜
			if (databaseName.equals(AbstractDataAccessObject.POSTGRESQL)) {
				// PostgrȅꍇV[PXe[u폜
				stmt.executeUpdate(dataaccessobject
						.getDropDatabaseTestSequenceSQL());
			}

			stmt.executeUpdate(dataaccessobject.getDropDatabaseTestTableSQL());

			checkResult[PHASE4_NO] = PHASE4_OK_DESCRIPTION;
			logger.info(checkResult[PHASE4_NO]);
		} catch (SQLException e3) {
			checkResult[PHASE4_NO] = "SQLException: " + e3.getMessage();

			// e3.printStackTrace();
			return checkResult;
		} finally {
			if (stmt != null) {
				try {
					stmt.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				stmt = null;
			}

			if (con != null) {
				try {
					con.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}
			}
		}

		return checkResult;
	}

	/**
	 * f[^x[XeXgƂăeXgpe[uɃf[^i[܂B
	 * 
	 * @param count
	 *            f[^x[XeXgf[^
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV 擾oȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	public void putDatabaseTest(int count) throws DatabaseConnectionException,
			SQLException {
		Date date = Calendar.getInstance().getTime();
		DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance()
				.popQueueDatabaseAccess();

		try {
			// f[^x[XeXgƂăeXgf[^DBɊi[
			databaseAccess.executeUpdate("insert into " + DATABASE_TEST_TABLE
					+ " ( " + TEST_CHAR + ", " + TEST_DATE + " )"
					+ " VALUES( '" + "Test" + Integer.toString(count) + "', '"
					+ dateformat.format(date) + "'" + ");");
		} finally {
			if (databaseAccess != null) {
				DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
						databaseAccess);
			}
		}
	}

	/**
	 * 
	 * 
	 * @return databaseTestResultList f[^x[XeXgʂ i[List
	 * @throws DatabaseConnectionException
	 *             f[^x[XRlNV擾oȂꍇ
	 * @throws SQLException
	 *             f[^x[XANZXɎsꍇ
	 */
	public ArrayList findAll() throws DatabaseConnectionException, SQLException {
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		ArrayList databaseTestResultList = null;

		DatabaseAccess dataaccess = DatabaseAccessPool.getInstance()
				.popQueueDatabaseAccess();

		try {
			// sql̍쐬
			String sql;

			sql = "SELECT * from " + DATABASE_TEST_TABLE + " order by "
					+ TEST_ID;

			conn = dataaccess.getConnection();

			// SQLXe[ggIuWFNg̍쐬
			stmt = conn.createStatement();

			// select̎s
			rs = stmt.executeQuery(sql);
			databaseTestResultList = new ArrayList();

			while (rs.next()) {
				DatabaseTestInfo testInfo = new DatabaseTestInfo();

				testInfo.setTestStringData(rs.getObject(TEST_CHAR).toString());
				testInfo.setTestDate(rs.getObject(TEST_DATE).toString());
				testInfo.setTestID(rs.getObject(TEST_ID).toString());

				databaseTestResultList.add(testInfo);
			}

			return databaseTestResultList;
		} catch (DatabaseConnectionException ex) {
			ex.printStackTrace();
			throw ex;
		} catch (SQLException ex) {
			ex.printStackTrace();
			throw ex;
		} finally {
			if (rs != null) {
				try {
					rs.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				rs = null;
			}

			if (stmt != null) {
				try {
					stmt.close();
				} catch (SQLException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}

				stmt = null;
			}

			if (conn != null) {
				if (dataaccess != null) {
					dataaccess.releaseConnection(conn);
					conn = null;
					DatabaseAccessPool.getInstance()
							.releaseQueueDatabaseAccess(dataaccess);
				}
			}
		}
	}
}
