/*
 * Created on 2006/10/15
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.mail;

import java.util.regex.Pattern;

import netjfwatcher.engine.preferance.AlarmFilterPreferencePage;

public abstract class FilterEffectAlarm {
	protected String alarmLevelFilterString = AlarmFilterPreferencePage.ALARM_LEVEL_INFO;

	protected boolean isAvailMessage = false;

	protected String availMessageFilterString = "";

	protected String[] availMessageItem;

	public void setMessageFilterString(boolean isAvailMessage,
			String alarmLevelFilterString, String availMessageFilterString) {
		this.isAvailMessage = isAvailMessage;
		this.alarmLevelFilterString = alarmLevelFilterString;
		this.availMessageFilterString = availMessageFilterString;
		Pattern pattern;
		pattern = Pattern.compile(",");
		availMessageItem = pattern.split(availMessageFilterString);

	}

	public boolean checkAlarmLevelFilter(String alarmLevel) {
		boolean isHit = false;

		if (alarmLevelFilterString
				.equals(AlarmFilterPreferencePage.ALARM_LEVEL_INFO)) {
			isHit = true;
		} else if (alarmLevelFilterString
				.equals(AlarmFilterPreferencePage.ALARM_LEVEL_WARNING)) {
			if (alarmLevel
					.equals(AlarmFilterPreferencePage.ALARM_LEVEL_WARNING)
					|| alarmLevel
							.equals(AlarmFilterPreferencePage.ALARM_LEVEL_ERROR)) {
				isHit = true;
			}
		} else if (alarmLevelFilterString
				.equals(AlarmFilterPreferencePage.ALARM_LEVEL_ERROR)) {
			if (alarmLevel.equals(AlarmFilterPreferencePage.ALARM_LEVEL_ERROR)) {
				isHit = true;
			}
		}
		return isHit;
	}

	public boolean checkMessageFilter(String message) {

		boolean isHit = false;
		if (!isAvailMessage) {
			return true;
		}
		if (availMessageFilterString == null
				|| availMessageFilterString.equals("")) {
			return true;
		}

		for (int itemCont = 0; itemCont < availMessageItem.length; itemCont++) {

			if (availMessageItem[itemCont] != null) {
				if (message.indexOf(availMessageItem[itemCont]) >= 0) {
					isHit = true;
					break;
				}
			}
		}

		return isHit;
	}
}
