/*
 * Created on 2004/06/10
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.nodecontrol;

import java.sql.SQLException;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableDatabaseWatcher;
import netjfwatcher.database.access.model.DBTableManagement;
import netjfwatcher.database.access.model.DBTableMapLink;
import netjfwatcher.database.access.model.DBTableNetworkCamera;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.server.protocol.control.ListQueueDatabaseWatchControl;
import netjfwatcher.engine.server.protocol.control.ListQueueDefaultSnmpMibControl;
import netjfwatcher.engine.server.protocol.control.ListQueueHTTPControl;
import netjfwatcher.engine.server.protocol.control.ListQueuePingControl;
import netjfwatcher.engine.server.protocol.control.ListQueueStatisticsMibControl;
import netjfwatcher.engine.socket.CommandInfo;


/**
 * m[h폜郁\bhNXłB
 * m[h폜ɂĈȉ̏s܂B
 * E쒆̊ĎXbh̒~
 * Ef[^x[Xe[u̍폜
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class NodeDelete {
    /* MO */
    private static Logger logger;

    /*
     * m[h폜郁\bhNXCX^X
     * ܂B
     */
    private NodeDelete() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * m[h폜܂B
     *
     *
     * @param com R}h
     */
    public void deleteNode(CommandInfo com) {
        logger = Logger.getLogger(this.getClass().getName());

        String ipaddress = com.getIpaddress();
        logger.info("Node Delete IP=" + ipaddress);

        // Thread쒆̊Ďm[hXg폜
        this.removeThreadList(com);
    }

    /**
     * Thread샊Xgw̃m[h폜܂B
     *
     * @param com R}h
     */
    private void removeThreadList(CommandInfo com) {
        String ipaddress = com.getIpaddress();

        BaseNodeWatchInfoList.getInstance().removeNodeWatchInfo(ipaddress);

        // PingĎXg폜
        ListQueuePingControl.getInstance().removePingNode(ipaddress);

        // ftHgSNMP̎惊Xg폜
        ListQueueDefaultSnmpMibControl.getInstance().removeDefaultSnmpNode(
            ipaddress);

        // vMIB̎惊Xg폜
        ListQueueStatisticsMibControl.getInstance().removeStatisticsMibGetNode(
            ipaddress);

        // HTTP`FbNXg폜
        ListQueueHTTPControl.getInstance().removeHTTPNode(ipaddress);

        // Database`FbNXg폜
        ListQueueDatabaseWatchControl.getInstance().removeDatabaseNode(ipaddress);
        
        // f[^x[Xe[uǗm[h폜
        DBTableManagement tablemanagement = new DBTableManagement();

        // m[hMapN̊Ym[h폜
        DBTableMapLink tableMapLink = new DBTableMapLink();
        DBTableNodeRegister nodeRegister = DBTableNodeRegister.getInstance();
		// Network Camerae[u
		DBTableNetworkCamera networkCameraTable = DBTableNetworkCamera
				.getInstance();		
        try {
            nodeRegister.deleteNode(com.getIpaddress());
            tablemanagement.delete(ipaddress, null);
            // m[hMapN폜
            tableMapLink.deleteNode(ipaddress);
            networkCameraTable.deleteCameraNodeIP(ipaddress);
            // f[^x[XĎe[u폜
            DBTableDatabaseWatcher.getInstance().deleteDatabaseWatcherNodeIP(ipaddress);
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (SQLException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }

    /**
     *
     *
     * @param ipaddress m[hIPAhX
     */
    public void removeThreadList(String ipaddress) {
        //
        BaseNodeWatchInfoList.getInstance().removeNodeWatchInfo(ipaddress);

        // PingĎXg폜
        ListQueuePingControl.getInstance().removePingNode(ipaddress);

        // ftHgSNMP̎惊Xg폜
        ListQueueDefaultSnmpMibControl.getInstance().removeDefaultSnmpNode(
            ipaddress);

        // vMIB̎惊Xg폜
        ListQueueStatisticsMibControl.getInstance().removeStatisticsMibGetNode(
            ipaddress);

        // HTTP`FbNXg폜
        ListQueueHTTPControl.getInstance().removeHTTPNode(ipaddress);

        // f[^x[Xe[uǗm[h폜
        DBTableManagement tablemanagement = new DBTableManagement();

        // m[hMapN̊Ym[h폜
        DBTableMapLink tableMapLink = new DBTableMapLink();
        DBTableNodeRegister nodeRegister = DBTableNodeRegister.getInstance();

		// Network Camerae[u
		DBTableNetworkCamera networkCameraTable = DBTableNetworkCamera
				.getInstance();	
        try {
            nodeRegister.deleteNode(ipaddress);
            tablemanagement.delete(ipaddress, null);
            // m[hMapN폜
            tableMapLink.deleteNode(ipaddress);
            // lbg[NJ e[u폜            
            networkCameraTable.deleteCameraNodeIP(ipaddress);
            // f[^x[XĎe[u폜
            DBTableDatabaseWatcher.getInstance().deleteDatabaseWatcherNodeIP(ipaddress);
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (SQLException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static NodeDelete getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final NodeDelete RESOURCE = new NodeDelete();
    }
}
