/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.preferance;

import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.mail.MailSendFilter;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.MailProperty;
import netjfwatcher.engine.socket.info.ResourceInfo;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * MailMvpeBPreferencePageNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MailSendPreferencePage extends AbstractEnginePreferancePage
		implements IWorkbenchPreferencePage {
	public static final String MAIL_SEND_ON = "on";

	public static final String MAIL_SEND_OFF = "off";

	/* Text */
	private static final int TEXT_WIDTH = 200;

	/* Filter Text */
	private static final int FILTER_TEXT_WIDTH = 300;

	/* Combo */
	private static final int COMBO_WIDTH = 120;

	/* MailMK[h^CText */
	private static final int GUARD_TIME_TEXT_WIDTH = 120;

	/* MailMzXgCombo Box */
	private static final int HOST_VALID_COMBO = 80;

	private static final int HORIZONTAL_SPAN2 = 2;

	/* MO */
	private static Logger logger;

	/* \[X */
	private ResourceInfo info;

	/* MailvpeBXg */
	private ArrayList mailPropList;

	/* MailvpeBz */
	private MailProperty[] mailprop;

	/* SMTPzXgIIndex */
	private int smtpHostSelectIndex = 0;

	/* SMTPzXgComboBox */
	private Combo smtpHostCombo;

	/* SMTPzXgValid ComboBox */
	private Combo smtpHostValidCombo;

	/* MailM惊Xg */
	private List mailDestinationList;

	/* Mail From\Text */
	private Text mailFromText;

	/* Mail\Text */
	private Text destinationText;

	/* MailMK[h^C\Text */
	private Text mailSendGuardTimeText;

	/* SMTPzXgǉ{^ */
	private Button smtpHostAddButton;

	/* SMTPzXg폜{^ */
	private Button smtpHostDeleteButton;

	/* Mail FromҏW{^ */
	private Button mailFromEditButton;

	/* MailMǉ{^ */
	private Button destinationAddButton;

	/* MailM폜{^ */
	private Button destinationDeleteButton;

	/* Mail Filter Alarmx */
	private Combo alarmLevelCombo;

	/* Mail bZ[WFilter `FbNBox */
	private Button messageFilterCheckButton;

	/* Mail bZ[WFilter bZ[WText */
	private Text mailCheckStringText;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#init(IWorkbench)
	 */
	public void init(IWorkbench workbench) {
		logger = Logger.getLogger(this.getClass().getName());

		// Initialize the preference store we wish to use
		setPreferenceStore(NetJFWatcherPlugin.getInstance()
				.getPreferenceStore());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {
		/* MailMvpeBZbg */
		info = SystemResourceConfig.getInstance().getResourceFileParse()
				.getResourceInfo();

		mailprop = info.getMailPropertyList();
		mailPropList = info.getMailPropertyArrayList();

		/*
		 * eCompositezueLayout ieCompositec1ɔzuj
		 */
		GridLayout layout = new GridLayout(1, false);
		parent.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayout = new GridLayout(4, false);
		Composite composite = new Composite(parent, SWT.NULL);

		composite.setLayout(gridLayout);
		composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		Label label = new Label(composite, SWT.NONE);
		label.setText("Mail send guard time (sec)");
		label.setLayoutData(new GridData());
		mailSendGuardTimeText = new Text(composite, SWT.BORDER | SWT.RIGHT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = GUARD_TIME_TEXT_WIDTH;
		mailSendGuardTimeText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("SMTP Host");
		label.setLayoutData(new GridData());

		smtpHostCombo = new Combo(composite, SWT.DROP_DOWN);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		smtpHostCombo.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Valid");
		gridData = new GridData();
		label.setLayoutData(gridData);

		smtpHostValidCombo = new Combo(composite, SWT.DROP_DOWN | SWT.READ_ONLY);

		smtpHostValidCombo.add(MAIL_SEND_ON);
		smtpHostValidCombo.add(MAIL_SEND_OFF);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = HOST_VALID_COMBO;
		smtpHostValidCombo.setLayoutData(gridData);

		smtpHostAddButton = new Button(composite, SWT.NONE);
		smtpHostAddButton.setText("SMTP Host Add");
		smtpHostAddButton.setLayoutData(new GridData());

		smtpHostDeleteButton = new Button(composite, SWT.NONE);
		smtpHostDeleteButton.setText("SMTP Host Delete");
		smtpHostDeleteButton.setLayoutData(new GridData());

		/* Dummy column */
		label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("From");
		label.setLayoutData(new GridData());
		mailFromText = new Text(composite, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		mailFromText.setLayoutData(gridData);

		mailFromEditButton = new Button(composite, SWT.NONE);
		mailFromEditButton.setText("From Edit");
		mailFromEditButton.setLayoutData(new GridData());

		/* Dummy column */
		label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Destination list");
		gridData = new GridData();
		label.setLayoutData(gridData);

		mailDestinationList = new List(composite, SWT.SINGLE | SWT.BORDER
				| SWT.V_SCROLL);

		GridData data = new GridData(GridData.FILL_BOTH);
		data.horizontalSpan = 1;
		data.verticalSpan = 7;
		data.widthHint = 200;
		data.heightHint = mailDestinationList.getItemHeight() * 8;

		mailDestinationList.setLayoutData(data);

		/* Dummy column */
		label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		GridLayout gridLayout2 = new GridLayout(4, false);
		Composite composite2 = new Composite(parent, SWT.NONE);
		composite2.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		composite2.setLayout(gridLayout2);

		destinationAddButton = new Button(composite2, SWT.NONE);
		destinationAddButton.setText("Add");
		destinationAddButton.setLayoutData(new GridData());

		destinationDeleteButton = new Button(composite2, SWT.NONE);
		destinationDeleteButton.setText("Delete");
		destinationDeleteButton.setLayoutData(new GridData());

		label = new Label(composite2, SWT.NONE);
		label.setText("Destination");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		destinationText = new Text(composite2, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 200;
		destinationText.setLayoutData(gridData);

		GridLayout gridLayout3 = new GridLayout(4, false);
		Composite composite3 = new Composite(parent, SWT.NONE);
		composite3.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		composite3.setLayout(gridLayout3);

		label = new Label(composite3, SWT.NONE);
		label.setText("Alarm level filter");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		alarmLevelCombo = new Combo(composite3, SWT.BORDER | SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = COMBO_WIDTH;
		alarmLevelCombo.setLayoutData(gridData);
		alarmLevelCombo.add(AlarmFilterPreferencePage.ALARM_LEVEL_INFO);
		alarmLevelCombo.add(AlarmFilterPreferencePage.ALARM_LEVEL_WARNING);
		alarmLevelCombo.add(AlarmFilterPreferencePage.ALARM_LEVEL_ERROR);

		alarmLevelCombo.select(0);

		/* Dummy column */
		label = new Label(composite3, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		messageFilterCheckButton = new Button(composite3, SWT.CHECK);
		messageFilterCheckButton.setText("Message filter");

		mailCheckStringText = new Text(composite3, SWT.BORDER | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = FILTER_TEXT_WIDTH;
		mailCheckStringText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite3, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		setListener();

		setShowTextData(0);

		return composite;
	}

	private void setListener() {
		smtpHostAddButton.addSelectionListener(new SelectionListener() {

			public void widgetSelected(SelectionEvent event) {
				String smtpHost = smtpHostCombo.getText();

				String[] check = smtpHostCombo.getItems();

				for (int i = 0; i < check.length; i++) {
					if (check[i].equals(smtpHost)) {

						MessageDialog.openError(getShell(), "Error",
								"Already SMTP Host = " + smtpHost);

						return;
					}
				}

				MailProperty addmailProp = new MailProperty();
				addmailProp.setSmtpHost(smtpHost);
				addmailProp.setFrom(mailFromText.getText());
				addmailProp.setMailSendFlag("off");

				mailPropList.add(addmailProp);
				info.setMailPropertyArrayList(mailPropList);
				mailprop = info.getMailPropertyList();

				smtpHostCombo.add(smtpHost);

				setShowTextData(smtpHostCombo.getItemCount() - 1);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/* SMTP Host폜{^ */
		smtpHostDeleteButton.addSelectionListener(new SelectionListener() {

			public void widgetSelected(SelectionEvent event) {
				String smtpHost = smtpHostCombo.getText();

				if (MessageDialog.openQuestion(getShell(), "Confirm", "Remove "
						+ smtpHost + " ?")) {
					mailPropList.clear();
					smtpHostCombo.removeAll();

					for (int i = 0; i < mailprop.length; i++) {
						if (mailprop[i].getSmtpHost().equals(smtpHost)) {
							logger.info("SMTP host delete : " + smtpHost);
						} else {
							mailPropList.add(mailprop[i]);
							smtpHostCombo.add(mailprop[i].getSmtpHost());
						}
					}

					/* XVmailXgɊi[čXV */
					info.setMailPropertyArrayList(mailPropList);
					mailprop = info.getMailPropertyList();

					setShowTextData(0);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/* SMTP Host CombBoxI */
		smtpHostCombo.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				smtpHostSelectIndex = smtpHostCombo.getSelectionIndex();

				if(smtpHostSelectIndex >= 0) {
					setShowTextData(smtpHostSelectIndex);
				}
			}
		});

		/* SMTP HostMLtOChange */
		smtpHostValidCombo.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				/* ێĂmailvpeBXV */
				mailprop[smtpHostSelectIndex]
						.setMailSendFlag(smtpHostValidCombo.getText());
				info.setMailPropertyList(mailprop);
			}
		});

		/* Mail惊XgI */
		mailDestinationList.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				int index = mailDestinationList.getSelectionIndex();
				if(index < 0) {
					return;
				}
				destinationText.setText(mailDestinationList.getItem(index));
			}
		});

		/* Mail惊Xgǉ{^ */
		destinationAddButton.addSelectionListener(new SelectionListener() {

			public void widgetSelected(SelectionEvent event) {
				String detination = destinationText.getText();
				int formCheck0 = detination.indexOf("@");

				if (formCheck0 < 0) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error",
							"Format error at mail address = " + detination);

					return;
				}

				String[] check = mailDestinationList.getItems();

				for (int i = 0; i < check.length; i++) {
					if (check[i].equals(detination)) {

						MessageDialog.openError(getShell(), "Error",
								"Already To mail address = " + detination);

						return;
					}
				}

				mailprop[smtpHostSelectIndex].setTo(detination);

				/* ێĂmailvpeBXV */
				mailDestinationList.add(detination);
				info.setMailPropertyList(mailprop);

				/* \XV */
				destinationText.setText("");
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/* Mail惊Xg폜{^ */
		destinationDeleteButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				String detination = destinationText.getText();

				if (MessageDialog.openQuestion(getShell(), "Confirm", "Remove "
						+ detination + " ?")) {
					String[] check = mailDestinationList.getItems();

					for (int i = 0; i < check.length; i++) {
						if (check[i].equals(detination)) {
							mailDestinationList.remove(i);
						}
					}

					String[] updateToList = mailDestinationList.getItems();
					mailprop[smtpHostSelectIndex].setTo(updateToList);

					/* ێĂmailvpeBXV */
					info.setMailPropertyList(mailprop);

					/* \XV */
					destinationText.setText("");
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/* Mail FromҏW{^ */
		mailFromEditButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				String fromString = mailFromText.getText();
				int formCheck0 = fromString.indexOf("@");

				if (formCheck0 < 0) {
					MessageDialog.openError(getShell(), "Error",
							"Format error at mail address = " + fromString);

					return;
				}

				mailprop[smtpHostSelectIndex].setFrom(fromString);

				/* ێĂmailvpeBXV */
				info.setMailPropertyList(mailprop);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		messageFilterCheckButton.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent event) {
			}

			public void widgetSelected(SelectionEvent event) {
				Button bChk = (Button) event.widget;

				if (bChk.getSelection()) {

					mailCheckStringText.setEnabled(true);
				} else {

					mailCheckStringText.setEnabled(false);
				}
			}
		});
	}

	/*
	 * wSMTP HostԍMailvtFX\܂B
	 */
	private void setShowTextData(int index) {
		smtpHostCombo.removeAll();
		mailDestinationList.removeAll();

		mailSendGuardTimeText.setText(info.getMailGuardTime());

		/* SMTP Host ComboBoxUNAčēxAZbg */
		for (int i = 0; i < mailprop.length; i++) {
			smtpHostCombo.add(mailprop[i].getSmtpHost());
		}

		smtpHostCombo.select(index);

		/* SMTP Host mailMLtOZbg */
		if (mailprop[index].getMailSendFlag().equals(MAIL_SEND_ON)) {
			smtpHostValidCombo.select(0);
		} else {
			smtpHostValidCombo.select(1);
		}

		/* Mail FromZbg */
		mailFromText.setText(mailprop[index].getFrom());

		/* Mail惊XgZbg */
		ArrayList mailToList = mailprop[index].getToList();

		for (int i = 0; i < mailToList.size(); i++) {
			mailDestinationList.add((String) mailToList.get(i));
		}

		alarmLevelCombo.setText(info.getMailFilterErrorLevel());

		messageFilterCheckButton.setSelection(info.isMailFilterStringFlag());

		mailCheckStringText.setText(info.getMailFilterString());
		if (messageFilterCheckButton.getSelection()) {
			mailCheckStringText.setEnabled(true);
		} else {
			mailCheckStringText.setEnabled(false);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
	 */
	protected void performDefaults() {
		/* MailvpeBNAāA\[Xǂݒ */
		info = SystemResourceConfig.getInstance().getResourceFileParse()
				.getResourceInfo();
		mailprop = info.getMailPropertyList();
		mailPropList = info.getMailPropertyArrayList();

		/* ftHgɂĕ\Zbg */
		setShowTextData(0);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#performOk()
	 */
	public boolean performOk() {
		info.setMailGuardTime(mailSendGuardTimeText.getText());
		info.setMailPropertyList(mailprop);
		info.setMailFilterErrorLevel(alarmLevelCombo.getText());
		info.setMailFilterStringFlag(messageFilterCheckButton.getSelection());
		info.setMailFilterString(mailCheckStringText.getText());

		MailSendFilter.getInstance().setMessageFilterString(
				messageFilterCheckButton.getSelection(),
				alarmLevelCombo.getText(), mailCheckStringText.getText());

		/* \`XMLt@CXV */
		saveResourceXMLInfo(info);

		return super.performOk();
	}
}
