/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.preferance;

import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.ResourceInfo;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;



/**
 * Ping Preferance PageNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class PingPreferancePage extends AbstractEnginePreferancePage
    implements IWorkbenchPreferencePage {
    /** ftHgPing^CAEgl(ms) */
    public static final String PING_DEFAULT_TIMEOUT = "4000";

    /** ftHgPinggC */
    public static final String PING_DEFAULT_COUNT = "4";

    /* eLXg */
    public static final int TEXT_WIDTH = 120;

    /* MO */
    private static Logger logger;

    /* \[X */
    private ResourceInfo resourceInfo;

    /* PingĎ^CAEgText */
    private Text pingTimeoutText;

    /* PinggCText */
    private Text pingCountText;

    /*
     * (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#init(IWorkbench)
     */
    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(this.getClass().getName());

        // Initialize the preference store we wish to use
        setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#createContents(Composite)
     */
    protected Control createContents(Composite parent) {
        resourceInfo =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo();

        /*
         * eCompositezueLayout
         * ieCompositec1ɔzuj
         */
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout(layout);

        GridData gridData = null;

        /*
         * Snmp V3 AgentAhXAOIDȂǂzuComposite
         */
        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite = new Composite(parent, SWT.NULL);

        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        gridData = new GridData();

        Label label = new Label(composite, SWT.NONE);
        label.setText("Ping Timeout(ms)");
        label.setLayoutData(new GridData());
        pingTimeoutText = new Text(composite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        pingTimeoutText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Ping Count");
        gridData = new GridData();
        label.setLayoutData(gridData);

        pingCountText = new Text(composite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        pingCountText.setLayoutData(gridData);

        showPingProp();

        return composite;
    }

    /*
     * PingĎvpeB̕\Zbg܂B
     */
    private void showPingProp() {
        pingTimeoutText.setText(resourceInfo.getPingTimeout());
        pingCountText.setText(resourceInfo.getPingRetry());
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
     */
    protected void performDefaults() {
        resourceInfo =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo();
        resourceInfo.setPingTimeout(PING_DEFAULT_TIMEOUT);
        resourceInfo.setPingRetry(PING_DEFAULT_COUNT);
        showPingProp();
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#performOk()
     */
    public boolean performOk() {
        /*  */
        resourceInfo.setPingTimeout(pingTimeoutText.getText());
        resourceInfo.setPingRetry(pingCountText.getText());

        /*  */
        saveResourceXMLInfo(resourceInfo);

        return super.performOk();
    }
}
