/*
 * Created on 2004/12/13
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;

import netjfwatcher.engine.filepreference.FilePreference;



/**
 * vMIB`CSVt@CǂݍOIDƂĕێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class StatisticsMibFileParse {
    /** CSVt@C̍sɂdescriptionoʒu */
    public static final int DESCRIP_POS = 0;

    /** CSVt@C̍sɂOIDoʒu */
    public static final int OID_POS = 1;

    /** CSVt@C̍sɂtypeoʒu */
    public static final int TYPE_POS = 2;

    /** CSVt@C̍sɂaccessoʒu */
    public static final int ACCESS_POS = 3;

    /** CSVt@C̍sɂunitoʒu */
    public static final int UNIT_POS = 4;

    /* MO */
    private static Logger logger = null;

    /* OIDKeyƂĒPʂi[ */
    private final HashMap statisticsMibMapList = new HashMap();

    /* DescriptionKeyƂOIDi[ */
    private final ArrayList statisticsMibSelectList = new ArrayList();

    /**
     * vMIB`CSVt@CǂݍOIDƂMAPɕێ܂B
     *
     */
    public StatisticsMibFileParse() {
        logger = Logger.getLogger(this.getClass().getName());

        File f = new File(FilePreference.SNMP_STATISTICS_MIB_FILE);

        if (f == null) {
            return;
        }

        logger.info("Path : " + f.getAbsolutePath());

        FileReader fi = null;
        BufferedReader buffReader = null;

        try {
            fi = new FileReader(FilePreference.SNMP_STATISTICS_MIB_FILE);
            buffReader = new BufferedReader(fi);

            String str;
            Pattern pattern;
            String[] item;

            while ((str = buffReader.readLine()) != null) {
                pattern = Pattern.compile(",");
                item = pattern.split(str);

                for (int k = 0; k < item.length; k++) {
                    if (item.length >= 5) {
                        /* OIDKeyƂĒPʂi[ */
                        statisticsMibMapList.put(item[OID_POS], item[UNIT_POS]);
                    }
                }

                statisticsMibSelectList.add(item);
            }
        } catch (FileNotFoundException e1) {
            e1.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (buffReader != null) {
                try {
                    buffReader.close();
                } catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }

            if (fi != null) {
                try {
                    fi.close();
                } catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }

    /**
     * OIDKeyƂĒPʂi[MapԂ܂B
     *
     * @return statisticsMibMapList OIDKeyƂĒPʂi[Map
     */
    public HashMap getStatisticsMibMapList() {
        return statisticsMibMapList;
    }

    /**
     * DescriptionKeyƂOIDi[ListԂ܂B
     *
     * @return statisticsMibSelectList DescriptionKeyƂ
     * OIDi[List
     */
    public ArrayList getStatisticsMibSelectList() {
        return statisticsMibSelectList;
    }
}
