/*
 * Created on 2003/08/21
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.resourceconfig;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.engine.filepreference.FilePreference;
import netjfwatcher.engine.resource.XMLOutputterFormat;

import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;


/**
 * GW̐ڑ񃊃\[Xt@C͂āAێ
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version .10
 */
public class EngineResourceConfigFileParse {
    /* GWڑ^CAEgftHgl */
    private static final String ENGINE_TIMEOUT_DEFAULT = "0";

    /* conf TAG */
    private static final String CONF_TAG = "conf";

    /* Engine TAG */
    private static final String ENGINE_TAG = "engine";

    /* GWIP Address TAG */
    private static final String ENGINE_IPADDRESS_TAG = "ipaddress";

    /* GWR}hPort TAG */
    private static final String ENGINE_PORT_TAG = "port";

    /* Timeout TAG */
    private static final String ENGINE_TIMEOUT_TAG = "timeout";
	/* user name TAG */
	private static final String USER_NAME_TAG = "user_name";

	/* password TAG */
	private static final String PASSWORD_TAG = "password";
    /* XML Scoketڑ|[g TAG */
    private static final String ENGINE_XML_SOCKET_PORT_TAG = "xmlSocketPort";

    /* Client TAG */
    private static final String CLIENT_TAG = "client";

    /* Node Register Status Report Port */
    private static final String NODE_REGISTER_PORT_TAG = "xmlSocketReportPort";

    /* l */
    private static final String ATTRIBUTE_VALUE = "value";

    /* Logging */
    private static Logger logger = null;

    /* GW\[X񃊃Xg */
    private ArrayList engineInfoList = new ArrayList();

    /* ڑGWIPAhX */
    private String engineIPAddress;

    /* GWƐڑ|[g */
    private String enginePort;

    /* GWƂ̐ڑ^CAEgl */
    private String engineTimeout;
    /* GWƂ̐ڑ[U */
    private String userName;
    /* GWƂ̐ڑpX[h */
    private String password;
    
    /* Flash ClientƃGWXML Socketڑ|[g */
    private String engineFlashXMLSocketPort;

    /* Flash ClientWebAvԂł̃m[hꊇo^󋵕񍐗pڑ|[g */
    private String clientXmlSocketPort;

    /**
     * GW̐ڑ񃊃\[XXMLt@C͂܂B
     *
     */
    public EngineResourceConfigFileParse() {
        logger = Logger.getLogger(this.getClass().getName());

        Document doc = null;
        BufferedReader d = null;

        try {
            FileReader fi = new FileReader(FilePreference.ENGINE_XML_FILE);
            d = new BufferedReader(fi);
        } catch (FileNotFoundException e1) {
            e1.printStackTrace();

            return;
        }

        try {
            // FileInputStream stream = new FileInputStream(f);
            SAXBuilder builder = new SAXBuilder();

            if (builder == null) {
                return;
            }

            doc = builder.build(d);
        } catch (JDOMException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        try {
            // rootvfo
            Element root = doc.getRootElement();

            try {
                List targetList = root.getChildren(ENGINE_TAG);

                // System.out.println("Parse target List : " + targetList.size());
                int targetCount = 0;
                Iterator iterator0 = targetList.iterator();

                while (iterator0.hasNext()) {
                    try {
                        EngineResourceInfo engineInfo =
                            new EngineResourceInfo();

                        targetCount++;

                        Element targetListEl = (Element) iterator0.next();

                        /* Engine IP Address */
                        engineIPAddress =
                            (targetListEl.getChild(ENGINE_IPADDRESS_TAG))
                            .getAttributeValue(ATTRIBUTE_VALUE);
                        engineInfo.setEngineIPaddress(engineIPAddress);

                        /* Engine Port */
                        enginePort =
                            (targetListEl.getChild(ENGINE_PORT_TAG))
                            .getAttributeValue(ATTRIBUTE_VALUE);
                        engineInfo.setEnginePort(enginePort);

                        /* Engine Timeout */
                        if (targetListEl.getChild(ENGINE_TIMEOUT_TAG) != null) {
                            engineTimeout =
                                (targetListEl.getChild(ENGINE_TIMEOUT_TAG))
                                .getAttributeValue(ATTRIBUTE_VALUE);

                            engineInfo.setEngineTimeout(engineTimeout);
                        } else {
                            engineInfo.setEngineTimeout(ENGINE_TIMEOUT_DEFAULT);
                        }
                        /* [U */
                        if (targetListEl.getChild(USER_NAME_TAG) != null) {
                            userName =
                                (targetListEl.getChild(USER_NAME_TAG))
                                .getAttributeValue(ATTRIBUTE_VALUE);

                            engineInfo.setUserName(userName);
                        } else {
                            engineInfo.setUserName("admin");
                        }
                        /* pX[h */
                        if (targetListEl.getChild(PASSWORD_TAG) != null) {
                            password =
                                (targetListEl.getChild(PASSWORD_TAG))
                                .getAttributeValue(ATTRIBUTE_VALUE);

                            engineInfo.setPassword(password);
                        } else {
                            engineInfo.setPassword("admin");
                        }
                        /* Flash XML Socket Port */
                        engineFlashXMLSocketPort =
                            (targetListEl.getChild(ENGINE_XML_SOCKET_PORT_TAG))
                            .getAttributeValue(ATTRIBUTE_VALUE);
                        engineInfo.setEngineFlashXMLSocketPort(
                            engineFlashXMLSocketPort);

                        /*
                         * GWڑXgɊi[
                         */
                        engineInfoList.add(engineInfo);
                    } catch (NullPointerException e) {
                        e.printStackTrace();
                        logger.warning(
                            "Abort Engine XML File parse at target No."
                            + targetCount);
                    }
                }
            } catch (NullPointerException e) {
                e.printStackTrace();
            }

            /*
             * Client xml socket connect
             * Node Register Status Report Port
             */
            Element clientEl = root.getChild(CLIENT_TAG);
            clientXmlSocketPort =
                (clientEl.getChild(NODE_REGISTER_PORT_TAG)).getAttributeValue(
                    ATTRIBUTE_VALUE);
        } catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    /**
     * GW\[XXV܂B
     *
     * @param engineInfoList GW񃊃Xg
     * @param xmlSocketReportPort Flash Abv[hԒʒm|[g
     */
    public void updateEngineResource(
        ArrayList engineInfoList, String xmlSocketReportPort) {
        // VXe\[XXV
        Document dom = this.updateDocument(engineInfoList, xmlSocketReportPort);
        BufferedWriter bufWriter = getResourceFileWriter();

        if ((dom != null) && (bufWriter != null)) {
            // XMLt@Co
            this.outputXMLFile(bufWriter, dom);
        }
    }

    /*
     * \[X񂩂Document𐶐AԂ܂B
     *
     * @param engineInfoList GWڑ񃊃Xg
     * @return Document
     */
    private Document updateDocument(
        ArrayList engineInfoList, String xmlSocketReportPort) {
        Element confElement = new Element(CONF_TAG);
        Document doc = new Document(confElement);

        if (engineInfoList == null) {
            return null;
        }

        // Engine Connect Rg
        confElement.addContent(new Comment("Engine Communication Information"));

        EngineResourceInfo engineInfo = null;

        for (int i = 0; engineInfoList.size() > i; i++) {
            engineInfo = (EngineResourceInfo) engineInfoList.get(i);

            if (engineInfo == null) {
                logger.warning("Not found SNMP Config at index=" + i);

                break;
            }

            Element engineEl = new Element(ENGINE_TAG);
            confElement.addContent(engineEl);

            Element ipAddressEl = new Element(ENGINE_IPADDRESS_TAG);
            engineEl.addContent(ipAddressEl);

            Element enginePortEl = new Element(ENGINE_PORT_TAG);
            engineEl.addContent(enginePortEl);

            Element engineTimeoutEl = new Element(ENGINE_TIMEOUT_TAG);
            engineEl.addContent(engineTimeoutEl);
            Element userNameEl = new Element(USER_NAME_TAG);
            engineEl.addContent(userNameEl);
            Element passwordEl = new Element(PASSWORD_TAG);
            engineEl.addContent(passwordEl);
            
            Element xmlSocketPortEl = new Element(ENGINE_XML_SOCKET_PORT_TAG);
            engineEl.addContent(xmlSocketPortEl);

            ipAddressEl.setAttribute(
                new Attribute(ATTRIBUTE_VALUE, engineInfo.getEngineIPaddress()));
            enginePortEl.setAttribute(
                new Attribute(ATTRIBUTE_VALUE, engineInfo.getEnginePort()));

            if (engineInfo.getEngineTimeout() != null) {
                engineTimeoutEl.setAttribute(
                    new Attribute(
                        ATTRIBUTE_VALUE, engineInfo.getEngineTimeout()));
            }
            userNameEl.setAttribute(
                    new Attribute(ATTRIBUTE_VALUE, engineInfo.getUserName()));
            passwordEl.setAttribute(
                    new Attribute(ATTRIBUTE_VALUE, engineInfo.getPassword()));
            xmlSocketPortEl.setAttribute(
                new Attribute(
                    ATTRIBUTE_VALUE, engineInfo.getEngineFlashXMLSocketPort()));
        }

        Element clientEl = new Element(CLIENT_TAG);

        // Node Register Status Report Port Rg
        clientEl.addContent(new Comment("Node Register Status Report Port"));
        confElement.addContent(clientEl);

        Element xmlSocketReportPortEl = new Element(NODE_REGISTER_PORT_TAG);
        clientEl.addContent(xmlSocketReportPortEl);

        if (xmlSocketReportPort != null) {
            xmlSocketReportPortEl.setAttribute(
                new Attribute(ATTRIBUTE_VALUE, xmlSocketReportPort));
        }

        return doc;
    }

    /*
     * GW\[XBufferedWriterԂ܂B
     *
     * @return bufferedWriter BufferedWriter
     */
    private BufferedWriter getResourceFileWriter() {
        File f = new File(FilePreference.ENGINE_XML_FILE);
        logger.info("Path : " + f.getAbsolutePath());

        if (f == null) {
            return null;
        }

        BufferedWriter bufferedWriter = null;

        try {
            FileWriter fi = new FileWriter(FilePreference.ENGINE_XML_FILE);
            bufferedWriter = new BufferedWriter(fi);
        } catch (IOException e1) {
            e1.printStackTrace();

            return null;
        }

        return bufferedWriter;
    }

    /**
     * GWIPAhXԂ܂B
     *
     * @return engineIPAddress GWIPAhX
     */
    public String getEngineIPAddress() {
        return engineIPAddress;
    }

    /**
     * Flash ClientWebAvԂł̃m[hꊇo^󋵕񍐗p
     * ڑ|[gԂ܂B
     *
     * @return clientXmlSocketPort Flash ClientWebAv
     * ł̃m[hꊇo^󋵕񍐗pڑ|[g
     */
    public String getClientXmlSocketPort() {
        return clientXmlSocketPort;
    }

    /**
     * GW\[X񃊃XgԂ܂B
     *
     * @return engineInfoList GW\[X񃊃Xg
     */
    public ArrayList getEngineInfoList() {
        return engineInfoList;
    }

    /*
     * wBufferedWriterɎwDocumento͂܂B
     *
     * @param bufWriter BufferedWriter
     * @param dom Document
     */
    private void outputXMLFile(BufferedWriter bufWriter, Document dom) {
        /*
         * qGgeGg2wAGgԂ̉sw͂Ȃ
         * iXMLt@CŌXsĂ邽߁j
         * XMLOutputter outputter = new XMLOutputter("  ", true);
         */
        XMLOutputter outputter =
            XMLOutputterFormat.getInstance().getXMLOutputterFormat();

        FileWriter writer = null;

        try {
            outputter.output(dom, System.out);
            outputter.output(dom, bufWriter);
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }
}
