/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;


/**
 * OIDPʂɍ̎MIBێNXłB
 * SNMP}l[WƂăG[WFg̎Mf[^͂āA
 * MIBƂĈȉ̏ێAf[^\Ei[Ɏgp܂B
 * EMIB
 * EOID
 * EType
 * EValue
 * ENext OID
 * EAccess
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MibValue {
    // MIB
    private String mibName;

    // MIB OID
    private String mibOid;

    // OID Type
    private String mibType;

    // OIDCX^Xl
    private String mibValue;

    // OID
    private String mibNextOid;

    // OIDANZX^Cv
    private String mibAccess;

    /**
     * OIDPʂɍ̎MIBێNXCX^X
     * ܂B
     */
    public MibValue() {
        // nothing
    }

    /**
     * SnmpG[WFg̉͂ꂽMf[^ɂwMIB
     * ێ܂B
     *
     * @param mibName MIB
     * @param mibOid MIB OID
     * @param mibType OID Type
     * @param mibValue OIDCX^Xl
     * @param mibNextOid OID
     * @param mibAccess@OIDANZX^Cv
     */
    public void setMibValue(
        final String mibName, final String mibOid, final String mibType,
        final String mibValue, final String mibNextOid, final String mibAccess) {
        this.mibName = mibName;
        this.mibOid = mibOid;
        this.mibType = mibType;
        this.mibValue = mibValue;
        this.mibNextOid = mibNextOid;
        this.mibAccess = mibAccess;
    }

    /**
     * MIBԂ܂B
     *
     * @return mibName MIB
     */
    public String getMibName() {
        return mibName;
    }

    /**
     * MIB OIDԂ܂B
     *
     * @return mibOid MIB OID
     */
    public String getMibOid() {
        return mibOid;
    }

    /**
     *@OID TypeԂ܂B
     *
     * @return mibType@OID Type
     */
    public String getMibType() {
        return mibType;
    }

    /**
     * OIDCX^XlԂ܂B
     *
     * @return mibValue OIDCX^Xl
     */
    public String getMibValue() {
        return mibValue;
    }

    /**
     * OIDԂ܂B
     *
     * @return mibNextOid OID
     */
    public String getMibNextOid() {
        return mibNextOid;
    }

    /**
     * OIDANZX^CvԂ܂B
     *
     * @return mibAccess OIDANZX^Cv
     */
    public String getMibAccess() {
        return mibAccess;
    }
}
