/*
 * Created on 2004/06/05
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.socket.info.ResourceInfo;


/**
 * GWɃf[^x[XғeXgʒmNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConnectionDatabaseTest extends AbstractConnectionEngine {
    /* Web-GWڑ */
    private static final int PHASE0 = 0;

    /* JDBC Driver ̓o^ */
    private static final int PHASE1 = 1;

    /* f[^x[X쐬 */
    private static final int PHASE2 = 2;

    /* f[^x[XEe[u쐬 */
    private static final int PHASE3 = 3;

    /* ̃e[u폜 */
    private static final int PHASE4 = 4;

    /* eXgtF[Y */
    private static final int PHASE_NO = 5;

    /*  */
    private static Logger logger = null;

    /**
     * GWɃf[^x[XғeXgʒmNXCX^X
     * 𐶐܂B
     *
     * @param engineAddress GWAhX
     */
    public ConnectionDatabaseTest(final String engineAddress) {
        super(engineAddress);
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * f[^x[XғeXgʒmAʂ擾܂B
     *
     * @param databaseName f[^x[X
     * @param databaseDriver f[^x[XhCo
     * @param databaseUrl f[^x[XURL
     * @param databaseUser f[^x[X[U
     * @param databasePassword f[^x[XpX[h
     * @return testResult eXg
     */
    public String[] checkDatabase(
        final String databaseName, final String databaseDriver,
        final String databaseUrl, final String databaseUser,
        final String databasePassword) {
        /*  */
        String[] testResult = new String[PHASE_NO];
        testResult[PHASE0] = "";
        testResult[PHASE1] = "";
        testResult[PHASE2] = "";
        testResult[PHASE3] = "";
        testResult[PHASE4] = "";

        ResourceInfo resourceInfo = new ResourceInfo();

        resourceInfo.setDatabaseName(databaseName);
        resourceInfo.setDatabaseDriver(databaseDriver);
        resourceInfo.setDatabaseUrl(databaseUrl);
        resourceInfo.setDatabaseUser(databaseUser);
        resourceInfo.setDatabasePassword(databasePassword);

        CommandInfo commandInfo = new CommandInfo();

        commandInfo.setResourceInfo(resourceInfo);
        commandInfo.setCode(
            CommandMappingTableResource.DATABASE_TEST_COMMAND_ID);

        try {
            testResult = (String[]) this.communicationToEngine(commandInfo);
        } catch (EngineConnectException e) {
            /* GWƂ̐ڑُ */
            logger.warning("Abort test Database : " + e.getMessage());
            testResult[0] = "Abort connect engine : " + e.getMessage();
        } catch (IOException e) {
            /* GWƂ̐ڑُ */
            logger.warning("Abort test Database : " + e.getMessage());
            testResult[0] = "Abort connect engine : " + e.getMessage();
        }

        return testResult;
    }
}
