/*
 * Created on 2007/02/02
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;
import java.util.ArrayList;

import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.socket.info.NetworkCameraInfo;


public class ConnectionNetworkCameraInfo extends AbstractConnectionEngine {

    public ConnectionNetworkCameraInfo(final String engineAddress) {
        super(engineAddress);
    }

    public NetworkCameraInfo getNetworkCameraInfo(
        final String targetIPAddress)
        throws EngineConnectException, IOException {
        NetworkCameraInfo networkCameraInfo = null;

        CommandInfo commandInfo = new CommandInfo();
        commandInfo.setCode(CommandMappingTableResource.NETWORK_PRINTER_COMMAND_ID);
        commandInfo.setIpaddress(targetIPAddress);

        ArrayList list = (ArrayList) this.communicationToEngine(commandInfo);

        if (list.size() > 0) {
        	networkCameraInfo = (NetworkCameraInfo) list.get(0);
        }

        return networkCameraInfo;
    }
}